/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util;

public abstract class TagProcessor {
    public static final int RESULT_IN_ESCAPE_CHAR = 0;
    public static final int RESULT_ESCAPE_END_CHAR = 1;
    public static final int RESULT_NORMAL_CHAR = 2;
    public static final int RESULT_WRONG_CHAR = -1;
    public static final int INITIAL_STATE = 0;
    int state = 0;
    StringBuffer tag_string;
    char escape_char;
    boolean is_escape = false;

    public TagProcessor(char _escape_char) {
        this.escape_char = _escape_char;
        this.tag_string = new StringBuffer();
    }

    public char getStartingEscapeChar() {
        return this.escape_char;
    }

    public String getTagString() {
        return this.tag_string.toString();
    }

    public int accept(char ch) {
        if (this.tag_string.length() == 0 && ch == this.escape_char) {
            return 2;
        }
        int acpt = this.acceptChar(ch);
        if (acpt == 0 && this.isTagChar(ch)) {
            this.tag_string.append(ch);
        }
        return acpt;
    }

    abstract int acceptChar(char var1);

    abstract boolean isTagChar(char var1);

    public boolean isEscapeState() {
        return this.is_escape;
    }

    public void setEscapeState(boolean b) {
        this.is_escape = b;
        if (b) {
            this.state = 0;
            this.tag_string.setLength(0);
        }
    }

    public void clear() {
        if (this.tag_string != null) {
            this.tag_string.setLength(0);
            this.tag_string = null;
        }
    }
}

