/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.amq;

import aurora.application.features.msg.IConsumer;
import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageDispatcher;
import aurora.application.features.msg.IMessageHandler;
import aurora.application.features.msg.IMessageStub;
import aurora.plugin.jms.JMSStub;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import uncertain.composite.CompositeMap;
import uncertain.core.ILifeCycle;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.MessageFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.util.resource.ILocatable;

public class AMQClientInstance
extends AbstractLocatableObject
implements ILifeCycle,
JMSStub {
    public static final String PLUGIN = "aurora.plugin.amq";
    private IMessageDispatcher[] mMessageDispatchers;
    private IMessageHandler[] mMessageHandlers;
    private IConsumer[] consumers;
    private String url;
    private IObjectRegistry registry;
    public ILogger logger;
    private Map<String, IMessageHandler> handlersMap = new HashMap<String, IMessageHandler>();
    private Map<String, IMessageDispatcher> dispatchersMap = new HashMap<String, IMessageDispatcher>();
    private ActiveMQConnectionFactory factory;
    private Map<String, IConsumer> consumerMap;
    private boolean inited = false;

    public AMQClientInstance(IObjectRegistry registry) {
        this.registry = registry;
    }

    public boolean startup() {
        if (this.inited) {
            return true;
        }
        this.logger = LoggingContext.getLogger((String)PLUGIN, (IObjectRegistry)this.registry);
        MessageFactory.loadResource((String)"resources.aurora_plugin_amq");
        if (this.url == null) {
            BuiltinExceptionFactory.createOneAttributeMissing((ILocatable)this, (String)"url");
        }
        this.factory = new ActiveMQConnectionFactory(this.url);
        this.registry.registerInstance(ConnectionFactory.class, (Object)this.factory);
        this.consumerMap = new HashMap<String, IConsumer>();
        if (this.consumers != null) {
            for (int i = 0; i < this.consumers.length; ++i) {
                this.consumerMap.put(this.consumers[i].getTopic(), this.consumers[i]);
            }
        }
        new Thread(){

            @Override
            public void run() {
                if (AMQClientInstance.this.consumers != null) {
                    for (int i = 0; i < AMQClientInstance.this.consumers.length; ++i) {
                        try {
                            AMQClientInstance.this.consumers[i].init((IMessageStub)AMQClientInstance.this);
                            continue;
                        }
                        catch (Exception e) {
                            AMQClientInstance.this.logger.log(Level.SEVERE, "init jms consumers failed!", (Throwable)e);
                        }
                    }
                }
            }
        }.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    AMQClientInstance.this.onShutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.registry.registerInstance(IMessageStub.class, (Object)this);
        this.inited = true;
        return true;
    }

    public void onShutdown() throws Exception {
        if (this.consumers != null) {
            for (int i = 0; i < this.consumers.length; ++i) {
                this.consumers[i].onShutdown();
            }
        }
    }

    public IMessageHandler getMessageHandler(String name) {
        return this.handlersMap.get(name);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public IMessageHandler[] getMessageHandlers() {
        return this.mMessageHandlers;
    }

    public void setMessageHandlers(IMessageHandler[] messageHandlers) {
        this.mMessageHandlers = messageHandlers;
        for (int i = 0; i < messageHandlers.length; ++i) {
            this.handlersMap.put(messageHandlers[i].getName(), messageHandlers[i]);
        }
    }

    public IMessageDispatcher[] getMessageDispatchers() {
        return this.mMessageDispatchers;
    }

    public void setMessageDispatchers(IMessageDispatcher[] messageDispatchers) {
        this.mMessageDispatchers = messageDispatchers;
        for (int i = 0; i < messageDispatchers.length; ++i) {
            this.dispatchersMap.put(messageDispatchers[i].getTopic(), messageDispatchers[i]);
        }
    }

    public IConsumer[] getConsumers() {
        return this.consumers;
    }

    public void setConsumers(IConsumer[] consumers) {
        this.consumers = consumers;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public ActiveMQConnectionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ActiveMQConnectionFactory factory) {
        this.factory = factory;
    }

    public IConsumer getConsumer(String topic) {
        return this.consumerMap.get(topic);
    }

    public void shutdown() {
        try {
            this.onShutdown();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "shutdown jms instance failed!", (Throwable)e);
        }
    }

    public IMessageDispatcher getDispatcher(String topic) {
        return this.dispatchersMap.get(topic);
    }

    public void send(String topic, IMessage message, CompositeMap context) throws Exception {
        IMessageDispatcher sender = this.getDispatcher(topic);
        if (sender == null) {
            throw new IllegalArgumentException("Don't not define the MessageDispatcher for topic:" + topic);
        }
        sender.send(message, context);
    }

    @Override
    public Connection createConnection() throws JMSException {
        if (this.factory == null) {
            throw new IllegalStateException("ConnectionFactory is not initialiaze!");
        }
        return this.factory.createConnection();
    }
}

