/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.jco3;

import aurora.plugin.sap.jco3.Parameter;
import aurora.plugin.sap.jco3.SapConfig;
import aurora.plugin.sap.jco3.Structure;
import aurora.plugin.sap.jco3.Table;
import aurora.service.http.HttpServiceInstance;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.ConfigurationError;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class JcoInvoke
extends AbstractEntry {
    public static final String LOGGING_TOPIC = "aurora.plugin.sap.jco3";
    public Parameter[] parameters;
    public String sid;
    public Table[] tables;
    public Structure[] structures;
    public String function;
    public String return_target;
    SapConfig sapConfig;
    ILogger logger;

    public JcoInvoke(SapConfig config) {
        this.sapConfig = config;
    }

    public void run(ProcedureRunner runner) throws Exception {
        Table table;
        JCoStructure stc;
        int i;
        String t;
        CompositeMap context = runner.getContext();
        this.logger = LoggingContext.getLogger((CompositeMap)context, (String)LOGGING_TOPIC);
        this.logger.config("jco-invoke");
        this.logger.config("===================================");
        this.logger.log(Level.CONFIG, "config:{0}", new Object[]{this});
        HttpServiceInstance service = (HttpServiceInstance)HttpServiceInstance.getInstance((CompositeMap)context.getRoot());
        CompositeMap target = null;
        CompositeMap model = null;
        model = service != null ? service.getServiceContext().getModel() : context.getRoot().getChild("model");
        if (model == null) {
            model = context.getRoot().createChild("model");
        }
        if (this.return_target != null && (target = (CompositeMap)model.getObject(t = TextParser.parse((String)this.return_target, (CompositeMap)context))) == null) {
            target = model.createChildByTag(t);
        }
        JCoDestination destination = this.sapConfig.getJCoDestination(this.sid);
        String functionName = this.function;
        JCoFunctionTemplate ftemplate = destination.getRepository().getFunctionTemplate(functionName);
        this.logger.info("function template:" + functionName);
        if (ftemplate == null) {
            this.logger.log(Level.SEVERE, "Function '" + this.function + "' not found in SAP system.");
            throw new IllegalArgumentException("Function '" + this.function + "' not found in SAP system.");
        }
        JCoFunction function = ftemplate.getFunction();
        JCoParameterList input = function.getImportParameterList();
        JCoParameterList output = function.getExportParameterList();
        if (this.parameters != null) {
            for (i = 0; i < this.parameters.length; ++i) {
                Parameter param = this.parameters[i];
                if (param.Return_field != null) continue;
                String o = param.Source_field == null ? param.Value : context.getObject(param.Source_field);
                String value = o == null ? "" : o.toString();
                input.setValue(param.Name, value);
                this.logger.log(Level.CONFIG, "parameter {0} -> {1}", new Object[]{param.Name, value});
            }
        }
        if (this.structures != null) {
            for (i = 0; i < this.structures.length; ++i) {
                Structure structure = this.structures[i];
                structure.setLogger(this.logger);
                if (!structure.isImport()) continue;
                stc = structure.getJCOStructure(input);
                structure.fillJCOStructure(stc, context);
                input.setValue(structure.Name, stc);
            }
        }
        if (this.tables != null) {
            JCoParameterList list = function.getTableParameterList();
            for (int i2 = 0; i2 < this.tables.length; ++i2) {
                table = this.tables[i2];
                table.setLogger(this.logger);
                if (!table.isImport()) continue;
                JCoTable tbl = table.getJCOTable(list);
                Object o = context.getObject(table.Source_field);
                this.logger.config("transfer import table " + table.Name + " from '" + table.Source_field + "':" + o);
                if (!(o instanceof CompositeMap)) continue;
                table.fillJCOTable(tbl, context);
            }
        }
        this.logger.config("call function " + function);
        function.execute(destination);
        if (this.parameters != null) {
            for (int i3 = 0; i3 < this.parameters.length; ++i3) {
                Parameter param = this.parameters[i3];
                if (param.Return_field == null) continue;
                if (target == null) {
                    throw new ConfigurationError("<jco-invoke>:must set 'return_target' attribute if there is return field");
                }
                String vl = output.getString(param.Name);
                if (vl == null && !param.Nullable) {
                    throw new IllegalArgumentException("jco-invoke: return field " + param.Name + " is null");
                }
                String f = TextParser.parse((String)param.Return_field, (CompositeMap)context);
                target.putObject(f, (Object)vl);
                this.logger.config("return: " + param.Name + "=" + vl + " -> " + f);
            }
        }
        if (this.structures != null) {
            for (int i4 = 0; i4 < this.structures.length; ++i4) {
                Structure structure = this.structures[i4];
                structure.setLogger(this.logger);
                if (structure.isImport()) continue;
                if (structure.Target == null) {
                    throw new ConfigurationError("Must set 'target' attribute for Structures " + structure.Name);
                }
                stc = structure.getJCOStructure(output);
                CompositeMap result = (CompositeMap)context.getObject(structure.Target);
                if (result == null) {
                    result = context.createChildByTag(structure.Target);
                }
                structure.fillCompositeMap(stc, result);
            }
        }
        if (this.tables != null) {
            JCoParameterList list = function.getTableParameterList();
            if (list == null) {
                throw new IllegalArgumentException("Function '" + function + "' doesn't return tables");
            }
            for (int i5 = 0; i5 < this.tables.length; ++i5) {
                table = this.tables[i5];
                if (table.isImport()) continue;
                if (table.Target == null) {
                    throw new ConfigurationError("Must set 'target' attribute for table " + table.Name);
                }
                table.setLogger(this.logger);
                JCoTable records = table.getJCOTable(list);
                CompositeMap result = (CompositeMap)context.getObject(table.Target);
                if (result == null) {
                    result = context.createChildByTag(table.Target);
                }
                table.fillCompositeMap(records, result);
                int rc = 0;
                if (result.getChilds() != null) {
                    rc = result.getChilds().size();
                }
                this.logger.config("loading export table " + table.Name + " into path '" + table.Target + "', total " + rc + " record(s)");
            }
        }
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameter[] parameters) {
        this.parameters = parameters;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public Table[] getTables() {
        return this.tables;
    }

    public void setTables(Table[] tables) {
        this.tables = tables;
    }

    public Structure[] getStructures() {
        return this.structures;
    }

    public void setStructures(Structure[] structures) {
        this.structures = structures;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public String getReturn_target() {
        return this.return_target;
    }

    public void setReturn_target(String return_target) {
        this.return_target = return_target;
    }
}

