/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.sync.idoc;

import aurora.plugin.sap.sync.idoc.AuroraIDocException;
import aurora.plugin.sap.sync.idoc.DataBaseUtil;
import aurora.plugin.sap.sync.idoc.IDocBackup;
import aurora.plugin.sap.sync.idoc.IDocFile;
import aurora.plugin.sap.sync.idoc.IDocSync;
import aurora.plugin.sap.sync.idoc.LoggerUtil;
import aurora.plugin.sap.sync.idoc.ServerConnection;
import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocXMLProcessor;
import com.sap.conn.idoc.jco.JCoIDoc;
import com.sap.conn.idoc.jco.JCoIDocHandler;
import com.sap.conn.idoc.jco.JCoIDocHandlerFactory;
import com.sap.conn.idoc.jco.JCoIDocServer;
import com.sap.conn.idoc.jco.JCoIDocServerContext;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerContextInfo;
import com.sap.conn.jco.server.JCoServerErrorListener;
import com.sap.conn.jco.server.JCoServerExceptionListener;
import com.sap.conn.jco.server.JCoServerState;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.sql.DataSource;

public class IDocServer {
    public JCoIDocServer iDocServer;
    private String serverName;
    private DataBaseUtil dbUtil;
    public LinkedList syncFiles = new LinkedList();
    public LinkedList backupFils = new LinkedList();
    private String idocDir;
    private DataSource dataSource;
    private int server_id = -1;
    private boolean isDeleteFileImmediately;
    private boolean isEnableInterfaceHistory;
    private ServerConnection reConnect;
    private boolean shutdownByCommand = false;

    public IDocServer(String idocDir, DataSource ds, String serverName, boolean isDeleteFileImmediately, boolean isEnableInterfaceHistory, int reconnectTime, int maxReconnectTime) {
        this.idocDir = idocDir;
        this.dataSource = ds;
        this.serverName = serverName;
        this.isDeleteFileImmediately = isDeleteFileImmediately;
        this.isEnableInterfaceHistory = isEnableInterfaceHistory;
        this.reConnect = new ServerConnection(this, reconnectTime, maxReconnectTime);
    }

    public void start() {
        this.start(false);
        if (!this.reConnect.isAlive()) {
            this.reConnect.start();
        }
    }

    public void reStart() {
        this.start(true);
    }

    private void start(boolean isRestart) {
        if (this.shutdownByCommand) {
            return;
        }
        String context = "";
        try {
            this.dbUtil = this.getConnection();
            LoggerUtil.getLogger().config("begin start IDocServer " + this.serverName + "...");
            context = "Get Server by Config File:" + this.serverName;
            if (!isRestart) {
                this.iDocServer = JCoIDoc.getServer((String)this.serverName);
                context = "";
                this.addListeners(this.iDocServer);
                LoggerUtil.getLogger().config(this.serverName + " ConnectionCount= " + this.iDocServer.getConnectionCount());
                if (this.iDocServer.getConnectionCount() == 0) {
                    this.iDocServer.setConnectionCount(1);
                }
                this.server_id = this.dbUtil.registerSapServers(this.iDocServer);
            }
            context = "Get HistoryIdocs " + this.iDocServer.getProgramID();
            this.handleHistoryFile();
            context = "";
            this.iDocServer.start();
            if (!this.isRunning()) {
                LoggerUtil.getLogger().log(this.serverName + "'s status is " + this.iDocServer.getState());
                this.shutdown();
                return;
            }
            IDocSync sync = new IDocSync(this);
            sync.start();
            LoggerUtil.getLogger().config("begin handle " + this.serverName + " HistoryIdocs...");
            IDocBackup backup = new IDocBackup(this);
            backup.start();
            LoggerUtil.getLogger().config("IDocServer " + this.serverName + " start successful!");
            System.out.println("IDocServer " + this.serverName + " start successful!");
        }
        catch (Throwable e) {
            this.shutdown(context, e);
            return;
        }
    }

    private void handleHistoryFile() {
        try {
            this.dbUtil.getHistoryIdocs(this.iDocServer.getProgramID(), this.syncFiles);
        }
        catch (AuroraIDocException e) {
            this.log(e);
        }
    }

    private void addListeners(JCoIDocServer iDocServer) {
        if (iDocServer == null) {
            return;
        }
        MyIDocHandlerFactory idocHanlerFactory = new MyIDocHandlerFactory();
        iDocServer.setIDocHandlerFactory((JCoIDocHandlerFactory)idocHanlerFactory);
        iDocServer.setTIDHandler((JCoServerTIDHandler)new MyTidHandler());
        MyThrowableListener listener = new MyThrowableListener();
        iDocServer.addServerErrorListener((JCoServerErrorListener)listener);
        iDocServer.addServerExceptionListener((JCoServerExceptionListener)listener);
    }

    private DataBaseUtil getConnection() throws SQLException, AuroraIDocException {
        Connection dbConn = this.dataSource.getConnection();
        if (dbConn == null) {
            throw new AuroraIDocException("Can not get Connection from DataSource");
        }
        DataBaseUtil dbUtil = new DataBaseUtil(dbConn);
        return dbUtil;
    }

    public DataBaseUtil getDbUtil() {
        return this.dbUtil;
    }

    public void setDbUtil(DataBaseUtil dbUtil) {
        this.dbUtil = dbUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleXMLFile(String file) throws IOException {
        BufferedReader input = null;
        PrintWriter output = null;
        File inFile = new File(file);
        File outFile = new File(file + ".temp");
        boolean containSpecialChar = false;
        try {
            input = new BufferedReader(new FileReader(inFile));
            output = new PrintWriter(new FileWriter(outFile));
            String line = null;
            while ((line = input.readLine()) != null) {
                int index = line.indexOf("&");
                if (index != -1) {
                    containSpecialChar = true;
                    int firstTagEnd = line.indexOf(">");
                    int secondTagbegin = line.indexOf("<", index);
                    if (firstTagEnd < index && secondTagbegin != -1) {
                        String text = "<![CDATA[" + line.substring(firstTagEnd + 1, secondTagbegin) + "]]>";
                        line = line.substring(0, firstTagEnd + 1) + text + line.substring(secondTagbegin);
                    }
                }
                output.println(line);
            }
            input.close();
            output.flush();
            output.close();
            if (containSpecialChar) {
                if (inFile.delete()) {
                    outFile.renameTo(new File(file));
                }
            } else {
                outFile.delete();
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    public synchronized void addSyncFile(IDocFile file) {
        this.syncFiles.addLast(file);
    }

    public synchronized IDocFile getSyncFile() {
        if (this.syncFiles.size() <= 0) {
            return null;
        }
        IDocFile file = (IDocFile)this.syncFiles.getFirst();
        this.syncFiles.remove(0);
        return file;
    }

    public synchronized void addBackupFile(IDocFile file) {
        if (this.isEnableInterfaceHistory) {
            this.backupFils.addLast(file);
        }
    }

    public synchronized IDocFile getBckupFile() {
        if (this.backupFils.size() <= 0) {
            return null;
        }
        IDocFile file = (IDocFile)this.backupFils.getFirst();
        this.backupFils.remove(0);
        return file;
    }

    public boolean isRunning() {
        return JCoServerState.ALIVE.equals((Object)this.iDocServer.getState()) || JCoServerState.STARTED.equals((Object)this.iDocServer.getState());
    }

    public boolean isShutdown() {
        return JCoServerState.DEAD.equals((Object)this.iDocServer.getState()) || JCoServerState.STOPPED.equals((Object)this.iDocServer.getState());
    }

    public boolean isFinished() {
        return this.syncFiles.size() <= 0;
    }

    public int getServerId() {
        return this.server_id;
    }

    public void setServerId(int serverId) {
        this.server_id = serverId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public JCoIDocServer getJCoIDocServer() {
        return this.iDocServer;
    }

    public boolean isDeleteFileImmediately() {
        return this.isDeleteFileImmediately;
    }

    public void log(Throwable e) {
        if (e instanceof AuroraIDocException && e.getCause() != null) {
            LoggerUtil.getLogger().log(Level.SEVERE, e.getMessage(), e);
        } else {
            LoggerUtil.getLogger().log(Level.SEVERE, "", e);
        }
    }

    public void shutdown(String errorMessage, Throwable e) {
        LoggerUtil.getLogger().log(Level.SEVERE, errorMessage, e);
        this.shutdown();
    }

    public void shutdown() {
        LoggerUtil.getLogger().log("close dbconnection ");
        this.shutdownDB();
        LoggerUtil.getLogger().log("stop iDocServer \uff1a" + this.serverName);
        this.shutdownIDocServer();
        if (this.shutdownByCommand) {
            this.reConnect.interrupt();
        }
        LoggerUtil.getLogger().log("...........shutdown " + this.serverName + " finished.............. ");
    }

    private void shutdownDB() {
        if (this.dbUtil != null) {
            try {
                this.dbUtil.getConnection().rollback();
                this.dbUtil.getConnection().setAutoCommit(true);
                if (this.server_id != -1) {
                    this.dbUtil.stopSapServers(this.server_id);
                }
            }
            catch (Throwable e) {
                this.log(e);
            }
            this.dbUtil.dispose();
        }
    }

    private void shutdownIDocServer() {
        if (this.iDocServer == null) {
            return;
        }
        try {
            if (this.isRunning()) {
                this.iDocServer.stop();
            }
        }
        catch (Throwable e) {
            this.log(e);
        }
    }

    public void setShutdownByCommand(boolean shutdownByCommand) {
        this.shutdownByCommand = shutdownByCommand;
    }

    public boolean isShutdownByCommand() {
        return this.shutdownByCommand;
    }

    class MyTidHandler
    implements JCoServerTIDHandler {
        MyTidHandler() {
        }

        public boolean checkTID(JCoServerContext serverCtx, String tid) {
            return true;
        }

        public void confirmTID(JCoServerContext serverCtx, String tid) {
        }

        public void commit(JCoServerContext serverCtx, String tid) {
        }

        public void rollback(JCoServerContext serverCtx, String tid) {
        }
    }

    class MyThrowableListener
    implements JCoServerErrorListener,
    JCoServerExceptionListener {
        MyThrowableListener() {
        }

        public void serverErrorOccurred(JCoServer server, String connectionId, JCoServerContextInfo ctx, Error error) {
            IDocServer.this.shutdown(">>> Error occured on " + server.getProgramID() + " connection " + connectionId, error);
        }

        public void serverExceptionOccurred(JCoServer server, String connectionId, JCoServerContextInfo ctx, Exception error) {
            IDocServer.this.shutdown(">>> Exception occured on " + server.getProgramID() + " connection " + connectionId, error);
        }
    }

    class MyIDocHandlerFactory
    implements JCoIDocHandlerFactory {
        private JCoIDocHandler handler;

        MyIDocHandlerFactory() {
            this.handler = new MyIDocHandler();
        }

        public JCoIDocHandler getIDocHandler(JCoIDocServerContext serverCtx) {
            return this.handler;
        }

        public JCoIDocHandler getIDocHandler() {
            return this.handler;
        }
    }

    class MyIDocHandler
    implements JCoIDocHandler {
        MyIDocHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRequest(JCoServerContext serverCtx, IDocDocumentList idocList) {
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            try {
                IDocXMLProcessor xmlProcessor = JCoIDoc.getIDocFactory().getIDocXMLProcessor();
                String fileName = serverCtx.getTID() + "_idoc.xml";
                String filePath = IDocServer.this.idocDir + File.separator + fileName;
                fos = new FileOutputStream(filePath);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
                xmlProcessor.render(idocList, (Writer)osw, 7);
                osw.flush();
                osw.close();
                int idoc_id = IDocServer.this.dbUtil.addIdoc(IDocServer.this.server_id, filePath);
                LoggerUtil.getLogger().log("Receive Idoc file, id=" + idoc_id);
                IDocServer.this.addSyncFile(new IDocFile(filePath, idoc_id, IDocServer.this.server_id));
            }
            catch (Throwable thr) {
                IDocServer.this.shutdown("", thr);
            }
            finally {
                try {
                    if (osw != null) {
                        osw.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    LoggerUtil.getLogger().log(Level.SEVERE, "", (Throwable)e);
                }
            }
        }
    }
}

