/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IInputParameterBinding;
import org.eclipse.birt.data.engine.api.IJoinCondition;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.odaconsumer.ParameterHint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparatorUtil {
    private static final int B_FALSE = 0;
    private static final int B_UNKNOWN = 1;
    private static final int B_TRUE = 2;

    private static boolean isEqualObject(Object ob1, Object ob2) {
        if (ob1 == ob2) {
            return true;
        }
        if (ob1 == null || ob2 == null) {
            return false;
        }
        return ob1.equals(ob2);
    }

    public static boolean isEqualString(String str1, String str2) {
        return ComparatorUtil.isEqualObject(str1, str2);
    }

    public static boolean isEqualProps(Map map1, Map map2) {
        if (map1 == map2) {
            return true;
        }
        if (map1 == null || map2 == null) {
            if (map1 == null) {
                return map2.size() == 0;
            }
            return map1.size() == 0;
        }
        if (map1.keySet().size() != map2.keySet().size()) {
            return false;
        }
        Set set = map1.entrySet();
        for (Map.Entry ob : set) {
            Object value2;
            Object value1 = ob.getValue();
            if (ComparatorUtil.isEqualObject(value1, value2 = map2.get(ob.getKey()))) continue;
            return false;
        }
        return true;
    }

    public static int isEqualBasicCol(Collection col1, Collection col2) {
        if (col1 == col2) {
            return 2;
        }
        if (col1 == null || col2 == null) {
            if (col1 == null) {
                if (col2.size() == 0) {
                    return 2;
                }
                return 0;
            }
            if (col1.size() == 0) {
                return 2;
            }
            return 0;
        }
        if (col1.size() == col2.size()) {
            return 1;
        }
        return 0;
    }

    public static boolean isEqualFilters(List filters1, List filters2) {
        int i = ComparatorUtil.isEqualBasicCol(filters1, filters2);
        if (i == 2) {
            return true;
        }
        if (i == 0) {
            return false;
        }
        Iterator itr1 = filters1.iterator();
        Iterator itr2 = filters2.iterator();
        while (itr1.hasNext()) {
            IFilterDefinition fd1 = (IFilterDefinition)itr1.next();
            IFilterDefinition fd2 = (IFilterDefinition)itr2.next();
            if (ComparatorUtil.isEqualExpression(fd1.getExpression(), fd2.getExpression())) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualExpression(IBaseExpression be, IBaseExpression be2) {
        if (be == be2) {
            return true;
        }
        if (be == null || be2 == null) {
            return false;
        }
        if (be instanceof IScriptExpression && be2 instanceof IScriptExpression) {
            IScriptExpression se = (IScriptExpression)be;
            IScriptExpression se2 = (IScriptExpression)be2;
            return ComparatorUtil.isEqualExpression2(se, se2);
        }
        if (be instanceof IConditionalExpression && be2 instanceof IConditionalExpression) {
            IConditionalExpression ce = (IConditionalExpression)be;
            IConditionalExpression ce2 = (IConditionalExpression)be2;
            return ce.getDataType() == ce2.getDataType() && ce.getOperator() == ce2.getOperator() && ComparatorUtil.isEqualExpression2(ce.getExpression(), ce2.getExpression()) && ComparatorUtil.isEqualExpression(ce.getOperand1(), ce2.getOperand1()) && ComparatorUtil.isEqualExpression(ce.getOperand2(), ce2.getOperand2());
        }
        if (be instanceof IExpressionCollection && be2 instanceof IExpressionCollection) {
            return be.getDataType() == be2.getDataType() && ComparatorUtil.isEqualExpressionArray(((IExpressionCollection)be).getExpressions(), ((IExpressionCollection)be2).getExpressions());
        }
        return false;
    }

    public static boolean isEqualExpression2(IScriptExpression se, IBaseExpression se2) {
        if (se == se2) {
            return true;
        }
        if (se == null || se2 == null) {
            return false;
        }
        return se.getDataType() == se2.getDataType() && ComparatorUtil.isEqualString(se.getText(), ((IScriptExpression)se2).getText());
    }

    public static boolean isEqualExpressionArray(Collection op1, Collection op2) {
        Object[] operands2;
        if (op1 == op2) {
            return true;
        }
        Object[] operands1 = op1.toArray();
        if (operands1.length != (operands2 = op2.toArray()).length) {
            return false;
        }
        int i = 0;
        while (i < operands1.length) {
            if (!ComparatorUtil.isEqualExpression((IBaseExpression)operands1[i], (IBaseExpression)operands2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEqualComputedColumns(List computedCol1, List computedCol2) {
        List<IComputedColumn> newComputedCol2;
        if (computedCol1 == computedCol2) {
            return true;
        }
        List<IComputedColumn> newComputedCol1 = ComparatorUtil.getRealComputedColumn(computedCol1);
        int basicCol = ComparatorUtil.isEqualBasicCol(newComputedCol1, newComputedCol2 = ComparatorUtil.getRealComputedColumn(computedCol2));
        if (basicCol == 2) {
            return true;
        }
        if (basicCol == 0) {
            return false;
        }
        Iterator<IComputedColumn> it = newComputedCol1.iterator();
        Iterator<IComputedColumn> it2 = newComputedCol2.iterator();
        while (it.hasNext()) {
            IComputedColumn cc2;
            IComputedColumn cc = it.next();
            if (ComparatorUtil.isEqualComputedCol(cc, cc2 = it2.next())) continue;
            return false;
        }
        return true;
    }

    public static List<IComputedColumn> getRealComputedColumn(List computedCols) {
        if (computedCols == null) {
            return null;
        }
        ArrayList<IComputedColumn> list = new ArrayList<IComputedColumn>();
        int i = 0;
        while (i < computedCols.size()) {
            IComputedColumn cc = (IComputedColumn)computedCols.get(i);
            if (!(cc.getName().matches("\\Q_{$TEMP_GROUP_\\E\\d*\\Q$}_\\E") || cc.getName().matches("\\Q_{$TEMP_SORT_\\E\\d*\\Q$}_\\E") || cc.getName().matches("\\Q_{$TEMP_FILTER_\\E\\d*\\Q$}_\\E"))) {
                list.add(cc);
            }
            ++i;
        }
        return list;
    }

    public static boolean isEqualComputedCol(IComputedColumn cc, IComputedColumn cc2) {
        return cc.getDataType() == cc2.getDataType() && ComparatorUtil.isEqualString(cc.getName(), cc2.getName()) && ComparatorUtil.isEqualExpression(cc.getExpression(), cc2.getExpression());
    }

    public static boolean isEqualParameters(List params1, List params2) {
        if (params1 == params2) {
            return true;
        }
        int basicCol = ComparatorUtil.isEqualBasicCol(params1, params2);
        if (basicCol == 2) {
            return true;
        }
        if (basicCol == 0) {
            return false;
        }
        Iterator it = params1.iterator();
        Iterator it2 = params2.iterator();
        while (it.hasNext()) {
            IParameterDefinition pd2;
            IParameterDefinition pd = (IParameterDefinition)it.next();
            if (ComparatorUtil.isEqualParameter(pd, pd2 = (IParameterDefinition)it2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualParameter(IParameterDefinition pd, IParameterDefinition pd2) {
        return pd.getPosition() == pd2.getPosition() && pd.getType() == pd2.getType() && pd.getNativeType() == pd2.getNativeType() && pd.isInputMode() == pd2.isInputMode() && pd.isInputOptional() == pd2.isInputOptional() && pd.isNullable() == pd2.isNullable() && pd.isOutputMode() == pd2.isOutputMode() && ComparatorUtil.isEqualString(pd.getDefaultInputValue(), pd2.getDefaultInputValue());
    }

    public static boolean isEqualParameterHints(Collection paramsBinding1, Collection paramsBinding2) {
        if (paramsBinding1 == paramsBinding2) {
            return true;
        }
        int basicCol = ComparatorUtil.isEqualBasicCol(paramsBinding1, paramsBinding2);
        if (basicCol == 2) {
            return true;
        }
        if (basicCol == 0) {
            return false;
        }
        Iterator it = paramsBinding1.iterator();
        Iterator it2 = paramsBinding2.iterator();
        while (it.hasNext()) {
            if (ComparatorUtil.isEqualParamterOjbect(it.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualParamterOjbect(Object param1, Object param2) {
        if (param1 instanceof ParameterHint && param2 instanceof ParameterHint) {
            return ComparatorUtil.isEqualParameterHint((ParameterHint)param1, (ParameterHint)param2);
        }
        if (param1 instanceof IInputParameterBinding && param2 instanceof IInputParameterBinding) {
            return ComparatorUtil.isEqualParameterBinding((IInputParameterBinding)param1, (IInputParameterBinding)param2);
        }
        return false;
    }

    public static boolean isEqualParameterBinding(IInputParameterBinding param1, IInputParameterBinding param2) {
        return param1.getName().equals(param2.getName()) && param1.getPosition() == param2.getPosition() && ComparatorUtil.isEqualExpression(param1.getExpr(), param2.getExpr());
    }

    public static boolean isEqualParameterHint(ParameterHint pb, ParameterHint pb2) {
        return pb.getPosition() == pb2.getPosition() && ComparatorUtil.isEqualString(pb.getName(), pb2.getName()) && ComparatorUtil.isEqualObject(pb.getDefaultInputValue(), pb2.getDefaultInputValue()) && DataTypeUtil.toApiDataType((Class)pb.getDataType()) == DataTypeUtil.toApiDataType((Class)pb2.getDataType()) && pb.getNativeDataType() == pb2.getNativeDataType();
    }

    public static boolean isEqualResultHints(List resultHints1, List resultHints2) {
        if (resultHints1 == resultHints2) {
            return true;
        }
        int basicCol = ComparatorUtil.isEqualBasicCol(resultHints1, resultHints2);
        if (basicCol == 2) {
            return true;
        }
        if (basicCol == 0) {
            return false;
        }
        Iterator it = resultHints1.iterator();
        Iterator it2 = resultHints2.iterator();
        while (it.hasNext()) {
            IColumnDefinition cd2;
            IColumnDefinition cd = (IColumnDefinition)it.next();
            if (ComparatorUtil.isEqualColumnDefn(cd, cd2 = (IColumnDefinition)it2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualColumnDefn(IColumnDefinition cd, IColumnDefinition cd2) {
        if (cd == cd2) {
            return true;
        }
        if (cd == null || cd2 == null) {
            return false;
        }
        return cd.getColumnPosition() == cd2.getColumnPosition() && cd.getDataType() == cd2.getDataType() && cd.getNativeDataType() == cd2.getNativeDataType() && cd.getExportHint() == cd2.getExportHint() && cd.getSearchHint() == cd2.getSearchHint() && ComparatorUtil.isEqualString(cd.getAlias(), cd2.getAlias()) && ComparatorUtil.isEqualString(cd.getColumnName(), cd2.getColumnName());
    }

    public static boolean isEqualJointCondition(List joinConditions1, List joinConditions2) {
        if (joinConditions1 == joinConditions2) {
            return true;
        }
        int basicCol = ComparatorUtil.isEqualBasicCol(joinConditions1, joinConditions2);
        if (basicCol == 2) {
            return true;
        }
        if (basicCol == 0) {
            return false;
        }
        Iterator it = joinConditions1.iterator();
        Iterator it2 = joinConditions2.iterator();
        while (it.hasNext() || it2.hasNext()) {
            IJoinCondition cc2;
            IJoinCondition cc = (IJoinCondition)it.next();
            if (ComparatorUtil.isEqualJointConditionItem(cc, cc2 = (IJoinCondition)it2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualJointConditionItem(IJoinCondition cc1, IJoinCondition cc2) {
        if (cc1 == cc2) {
            return true;
        }
        if (cc1 == null || cc2 == null) {
            return false;
        }
        return ComparatorUtil.isEqualExpression2(cc1.getLeftExpression(), cc2.getLeftExpression()) && ComparatorUtil.isEqualExpression2(cc1.getRightExpression(), cc2.getRightExpression()) && cc1.getOperator() == cc2.getOperator();
    }
}

