/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IJointDataSetDesign;
import org.eclipse.birt.data.engine.api.IOdaDataSetDesign;
import org.eclipse.birt.data.engine.api.IScriptDataSetDesign;
import org.eclipse.birt.data.engine.executor.ComparatorUtil;

public class OSDataSetDesignComparator {
    public static boolean isEqualOSDataSetDesign(IBaseDataSetDesign dataSetDesign, IBaseDataSetDesign dataSetDesign2) {
        if (dataSetDesign instanceof IOdaDataSetDesign && dataSetDesign2 instanceof IOdaDataSetDesign) {
            IOdaDataSetDesign dataSet = (IOdaDataSetDesign)dataSetDesign;
            IOdaDataSetDesign dataSet2 = (IOdaDataSetDesign)dataSetDesign2;
            return ComparatorUtil.isEqualString(dataSet.getQueryText(), dataSet2.getQueryText()) && ComparatorUtil.isEqualString(dataSet.getExtensionID(), dataSet2.getExtensionID()) && ComparatorUtil.isEqualString(dataSet.getPrimaryResultSetName(), dataSet2.getPrimaryResultSetName()) && ComparatorUtil.isEqualProps(dataSet.getPublicProperties(), dataSet2.getPublicProperties()) && ComparatorUtil.isEqualProps(dataSet.getPrivateProperties(), dataSet2.getPrivateProperties());
        }
        if (dataSetDesign instanceof IScriptDataSetDesign && dataSetDesign2 instanceof IScriptDataSetDesign) {
            IScriptDataSetDesign dataSet = (IScriptDataSetDesign)dataSetDesign;
            IScriptDataSetDesign dataSet2 = (IScriptDataSetDesign)dataSetDesign2;
            return ComparatorUtil.isEqualString(dataSet.getOpenScript(), dataSet2.getOpenScript()) && ComparatorUtil.isEqualString(dataSet.getFetchScript(), dataSet2.getFetchScript()) && ComparatorUtil.isEqualString(dataSet.getCloseScript(), dataSet2.getCloseScript()) && ComparatorUtil.isEqualString(dataSet.getDescribeScript(), dataSet2.getDescribeScript());
        }
        if (dataSetDesign instanceof IJointDataSetDesign && dataSetDesign2 instanceof IJointDataSetDesign) {
            IJointDataSetDesign design1 = (IJointDataSetDesign)dataSetDesign;
            IJointDataSetDesign design2 = (IJointDataSetDesign)dataSetDesign2;
            return ComparatorUtil.isEqualString(design1.getLeftDataSetDesignName(), design2.getLeftDataSetDesignName()) && ComparatorUtil.isEqualString(design1.getLeftDataSetDesignQulifiedName(), design2.getLeftDataSetDesignQulifiedName()) && ComparatorUtil.isEqualString(design1.getRightDataSetDesignName(), design2.getRightDataSetDesignName()) && ComparatorUtil.isEqualString(design1.getRightDataSetDesignQulifiedName(), design2.getRightDataSetDesignQulifiedName()) && design1.getJoinType() == design2.getJoinType() && ComparatorUtil.isEqualJointCondition(design1.getJoinConditions(), design2.getJoinConditions());
        }
        return false;
    }

    public static boolean isEqualBaseDataSetDesign(IBaseDataSetDesign dataSetDesign, IBaseDataSetDesign dataSetDesign2) {
        if (dataSetDesign == dataSetDesign2) {
            return true;
        }
        if (dataSetDesign == null || dataSetDesign2 == null) {
            return false;
        }
        if (!ComparatorUtil.isEqualString(dataSetDesign.getName(), dataSetDesign2.getName())) {
            return false;
        }
        if (dataSetDesign.getRowFetchLimit() != dataSetDesign2.getRowFetchLimit()) {
            return false;
        }
        if (!(ComparatorUtil.isEqualString(dataSetDesign.getBeforeOpenScript(), dataSetDesign2.getBeforeOpenScript()) && ComparatorUtil.isEqualString(dataSetDesign.getAfterOpenScript(), dataSetDesign2.getAfterOpenScript()) && ComparatorUtil.isEqualString(dataSetDesign.getBeforeCloseScript(), dataSetDesign2.getBeforeCloseScript()) && ComparatorUtil.isEqualString(dataSetDesign.getAfterCloseScript(), dataSetDesign2.getAfterCloseScript()) && ComparatorUtil.isEqualString(dataSetDesign.getOnFetchScript(), dataSetDesign2.getOnFetchScript()))) {
            return false;
        }
        if (!(ComparatorUtil.isEqualComputedColumns(dataSetDesign.getComputedColumns(), dataSetDesign2.getComputedColumns()) && ComparatorUtil.isEqualFilters(dataSetDesign.getFilters(), dataSetDesign2.getFilters()) && ComparatorUtil.isEqualParameters(dataSetDesign.getParameters(), dataSetDesign2.getParameters()) && ComparatorUtil.isEqualResultHints(dataSetDesign.getResultSetHints(), dataSetDesign2.getResultSetHints()))) {
            return false;
        }
        return dataSetDesign.getCacheRowCount() == dataSetDesign2.getCacheRowCount();
    }
}

