/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.executor.cache.disk.DiskDataExport;
import org.eclipse.birt.data.engine.executor.cache.disk.IRowIterator;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

class DiskCacheResultSet {
    private Map infoMap;
    private int dataCount;
    private DiskDataExport databaseExport;
    private ResultObjectUtil resultObjectUtil;
    private IRowIterator rowIterator;
    private DataEngineSession session;

    DiskCacheResultSet(Map infoMap, DataEngineSession session) {
        this.infoMap = infoMap;
        this.session = session;
    }

    public void processStartResultObjects(IResultObject[] resultObjects, Comparator comparator) throws IOException, DataException {
        IResultClass rsMetaData = resultObjects[0].getResultClass();
        assert (rsMetaData != null);
        this.resultObjectUtil = ResultObjectUtil.newInstance(rsMetaData, this.session);
        this.databaseExport = DiskDataExport.newInstance(this.infoMap, comparator, rsMetaData, this.resultObjectUtil, this.session);
        this.databaseExport.exportStartDataToDisk(resultObjects);
        this.dataCount = resultObjects.length;
    }

    public void processRestResultObjects(IResultObject resultObject, IRowResultSet rs, int maxRows) throws DataException, IOException {
        this.dataCount += this.databaseExport.exportRestDataToDisk(resultObject, rs, maxRows);
        this.rowIterator = this.databaseExport.getRowIterator();
    }

    public int getCount() {
        return this.dataCount;
    }

    public IResultObject nextRow() throws IOException, DataException {
        return this.rowIterator.fetch();
    }

    public void reset() throws DataException {
        this.rowIterator.reset();
    }

    public void close() throws DataException {
        if (this.rowIterator != null) {
            this.rowIterator.close();
            this.rowIterator = null;
        }
        if (this.databaseExport != null) {
            this.databaseExport.close();
            this.databaseExport = null;
        }
        this.resultObjectUtil = null;
    }
}

