/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.cache.CachedList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.OrderingInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBoundaryInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupBy;
import org.eclipse.birt.data.engine.executor.transform.group.GroupCalculationUtil;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfoWithIndex;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfoWithIndexComparator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;

public class GroupInformationUtil {
    private List[] groups;
    private int leafGroupIdx = -1;
    private GroupCalculationUtil groupCalculationUtil;
    private String tempDir;
    private DataEngineSession session;

    GroupInformationUtil(GroupCalculationUtil groupCalculationUtil, DataEngineSession session) {
        this.groupCalculationUtil = groupCalculationUtil;
        this.tempDir = this.groupCalculationUtil.getResultSetPopoulator().getSession().getTempDir();
        this.groups = new List[0];
        this.session = session;
    }

    public void setLeaveGroupIndex(int index) {
        this.leafGroupIdx = index;
    }

    public int getEndingGroupLevel() throws DataException {
        this.checkHasCurrentRow();
        if (this.groupCalculationUtil.getResultSetCache().getCurrentIndex() == this.groupCalculationUtil.getResultSetCache().getCount() - 1) {
            return 0;
        }
        if (this.groups.length == 0) {
            return 1;
        }
        int childGroupIdx = this.groupCalculationUtil.getResultSetCache().getCurrentIndex();
        int currentGroupIdx = this.leafGroupIdx;
        int level = this.groups.length - 1;
        while (level >= 0) {
            GroupInfo nextGroup = GroupUtil.findGroup(level, currentGroupIdx + 1, this.groups);
            if (nextGroup == null || childGroupIdx != nextGroup.firstChild - 1) break;
            childGroupIdx = currentGroupIdx;
            currentGroupIdx = GroupUtil.findGroup((int)level, (int)currentGroupIdx, (List[])this.groups).parent;
            --level;
        }
        return level + 2;
    }

    private void checkStarted() throws DataException {
        if (this.groupCalculationUtil.getResultSetCache() == null) {
            throw new DataException("data.engine.NoCurrentRow");
        }
    }

    private void checkHasCurrentRow() throws DataException {
        this.checkStarted();
        if (this.groupCalculationUtil.getResultSetCache().getCurrentResult() == null) {
            throw new DataException("data.engine.NoCurrentRow");
        }
    }

    public int getStartingGroupLevel() throws DataException {
        this.checkHasCurrentRow();
        if (this.groupCalculationUtil.getResultSetCache().getCurrentIndex() == 0) {
            return 0;
        }
        if (this.groups.length == 0) {
            return 1;
        }
        int childGroupIdx = this.groupCalculationUtil.getResultSetCache().getCurrentIndex();
        int currentGroupIdx = this.leafGroupIdx;
        int level = this.groups.length - 1;
        while (level >= 0) {
            GroupInfo currentGroup = GroupUtil.findGroup(level, currentGroupIdx, this.groups);
            if (childGroupIdx != currentGroup.firstChild) break;
            childGroupIdx = currentGroupIdx;
            currentGroupIdx = currentGroup.parent;
            --level;
        }
        return level + 2;
    }

    private int findCurrentGroup(int groupLevel) {
        int currentGroupIdx = this.leafGroupIdx;
        int i = this.groups.length - 1;
        while (i > groupLevel) {
            currentGroupIdx = GroupUtil.findGroup((int)i, (int)currentGroupIdx, (List[])this.groups).parent;
            --i;
        }
        return currentGroupIdx;
    }

    public void first(int groupLevel) throws DataException {
        if (groupLevel > this.groups.length || groupLevel < 0) {
            throw new DataException("data.engine.InvalidGroupLevel", groupLevel);
        }
        if (groupLevel == 0) {
            this.leafGroupIdx = 0;
            this.groupCalculationUtil.getResultSetCache().reset();
            this.groupCalculationUtil.getResultSetCache().next();
            return;
        }
        int currentGroupIdx = this.findCurrentGroup(--groupLevel);
        int i = groupLevel + 1;
        while (i < this.groups.length) {
            currentGroupIdx = GroupUtil.findGroup((int)(i - 1), (int)currentGroupIdx, (List[])this.groups).firstChild;
            ++i;
        }
        this.leafGroupIdx = currentGroupIdx;
        int currentRowID = GroupUtil.findGroup((int)(this.groups.length - 1), (int)this.leafGroupIdx, (List[])this.groups).firstChild;
        this.groupCalculationUtil.getResultSetCache().moveTo(currentRowID);
    }

    public void last(int groupLevel) throws DataException {
        if (groupLevel > this.groups.length || groupLevel < 0) {
            throw new DataException("data.engine.InvalidGroupLevel", groupLevel);
        }
        int currentGroupIdx = -1;
        if (--groupLevel >= 0) {
            currentGroupIdx = this.findCurrentGroup(groupLevel);
        }
        if (groupLevel < 0 || currentGroupIdx >= this.groups[groupLevel].size() - 1) {
            int currentRowID = this.groupCalculationUtil.getResultSetCache().getCount() - 1;
            this.groupCalculationUtil.getResultSetCache().moveTo(currentRowID);
            if (this.groups.length > 0) {
                this.leafGroupIdx = this.groups[this.groups.length - 1].size() - 1;
            }
            return;
        }
        ++currentGroupIdx;
        int i = groupLevel + 1;
        while (i < this.groups.length) {
            currentGroupIdx = GroupUtil.findGroup((int)(i - 1), (int)currentGroupIdx, (List[])this.groups).firstChild;
            ++i;
        }
        int currentRowID = GroupUtil.findGroup((int)(this.groups.length - 1), (int)currentGroupIdx, (List[])this.groups).firstChild - 1;
        this.groupCalculationUtil.getResultSetCache().moveTo(currentRowID);
        this.leafGroupIdx = currentGroupIdx - 1;
    }

    public int getCurrentGroupIndex(int groupLevel) throws DataException {
        if (groupLevel == 0) {
            return 0;
        }
        this.checkHasCurrentRow();
        if (groupLevel < 0 || groupLevel > this.groups.length) {
            throw new DataException("data.engine.InvalidGroupLevel", groupLevel);
        }
        int currentGroupIdx = this.leafGroupIdx;
        int level = this.groups.length - 1;
        while (level > groupLevel - 1) {
            GroupInfo currentGroup = GroupUtil.findGroup(level, currentGroupIdx, this.groups);
            currentGroupIdx = currentGroup.parent;
            --level;
        }
        return currentGroupIdx;
    }

    public void next(boolean hasNext) throws DataException {
        GroupInfo nextLeafGroup;
        if (hasNext && this.groups.length > 0 && (nextLeafGroup = GroupUtil.findGroup(this.groups.length - 1, this.leafGroupIdx + 1, this.groups)) != null && this.groupCalculationUtil.getResultSetCache().getCurrentIndex() >= nextLeafGroup.firstChild) {
            ++this.leafGroupIdx;
        }
    }

    public int[] getGroupStartAndEndIndex(int groupLevel) throws DataException {
        if (groupLevel == 0) {
            int[] nArray = new int[2];
            nArray[1] = this.groupCalculationUtil.getResultSetCache().getCount();
            return nArray;
        }
        int unitCountInOneGroup = this.groups[groupLevel - 1].size();
        if (unitCountInOneGroup == 1) {
            int[] nArray = new int[2];
            nArray[1] = this.groupCalculationUtil.getResultSetCache().getCount();
            return nArray;
        }
        int[] unitInfo = new int[unitCountInOneGroup * 2];
        int i = 0;
        while (i < unitCountInOneGroup) {
            int startIndex = i;
            int endIndex = startIndex + 1;
            startIndex = GroupUtil.getGroupFirstRowIndex(groupLevel, startIndex, this.groups, this.groupCalculationUtil.getResultSetCache().getCount());
            endIndex = GroupUtil.getGroupFirstRowIndex(groupLevel, endIndex, this.groups, this.groupCalculationUtil.getResultSetCache().getCount());
            unitInfo[i * 2] = startIndex;
            unitInfo[i * 2 + 1] = endIndex;
            ++i;
        }
        return unitInfo;
    }

    public void doGrouping() throws DataException {
        assert (this.groupCalculationUtil.getResultSetCache() != null);
        this.groups = new CachedList[this.groupCalculationUtil.getGroupDefn().length];
        if (this.groups.length == 0) {
            return;
        }
        int i = 0;
        while (i < this.groupCalculationUtil.getGroupDefn().length) {
            this.groups[i] = new CachedList(this.tempDir, DataEngineSession.getCurrentClassLoader(), GroupInfo.getCreator());
            ++i;
        }
        IResultObject prevRow = null;
        this.groupCalculationUtil.getResultSetCache().reset();
        int i2 = 0;
        while (i2 < this.groupCalculationUtil.getGroupDefn().length) {
            this.groupCalculationUtil.getGroupDefn()[i2].reset();
            ++i2;
        }
        int rowID = 0;
        while (rowID < this.groupCalculationUtil.getResultSetCache().getCount()) {
            if (this.session.getStopSign().isStopped()) break;
            IResultObject currRow = this.groupCalculationUtil.getResultSetCache().fetch();
            int breakLevel = rowID == 0 ? 0 : this.getBreakLevel(currRow, prevRow);
            int level = breakLevel;
            while (level < this.groups.length) {
                GroupInfo group = new GroupInfo();
                if (level != 0) {
                    group.parent = this.groups[level - 1].size() - 1;
                }
                group.firstChild = level == this.groups.length - 1 ? rowID : this.groups[level + 1].size();
                this.groups[level].add(group);
                ++level;
            }
            prevRow = currRow;
            ++rowID;
        }
        this.groupCalculationUtil.getResultSetCache().reset();
        this.setLeaveGroupIndex(0);
    }

    private int getBreakLevel(IResultObject currRow, IResultObject prevRow) throws DataException {
        assert (currRow != null);
        assert (prevRow != null);
        int breakLevel = 0;
        while (breakLevel < this.groupCalculationUtil.getGroupDefn().length) {
            GroupBy groupBy;
            int colIndex = this.groupCalculationUtil.getGroupDefn()[breakLevel].getColumnIndex();
            Object currObjectValue = null;
            Object prevObjectValue = null;
            if (colIndex >= 0) {
                currObjectValue = currRow.getFieldValue(colIndex);
                prevObjectValue = prevRow.getFieldValue(colIndex);
            }
            if (!(groupBy = this.groupCalculationUtil.getGroupDefn()[breakLevel]).isInSameGroup(currObjectValue, prevObjectValue)) {
                int i = breakLevel + 1;
                while (i < this.groupCalculationUtil.getGroupDefn().length) {
                    this.groupCalculationUtil.getGroupDefn()[i].reset();
                    ++i;
                }
                break;
            }
            ++breakLevel;
        }
        return breakLevel;
    }

    public int[] getCurrentGroupInfo(int groupLevel) throws DataException {
        if (groupLevel == 0) {
            int[] nArray = new int[2];
            nArray[1] = this.groupCalculationUtil.getResultSetCache().getCount();
            return nArray;
        }
        int groupLevelIndex = this.leafGroupIdx;
        int i = this.groups.length - 1;
        while (i > groupLevel - 1) {
            List parentGroupInfo = this.groups[i];
            GroupInfo groupInfo = (GroupInfo)parentGroupInfo.get(groupLevelIndex);
            groupLevelIndex = groupInfo.parent;
            --i;
        }
        int startIndex = groupLevelIndex;
        int endIndex = startIndex + 1;
        startIndex = GroupUtil.getGroupFirstRowIndex(groupLevel, startIndex, this.groups, this.groupCalculationUtil.getResultSetCache().getCount());
        endIndex = GroupUtil.getGroupFirstRowIndex(groupLevel, endIndex, this.groups, this.groupCalculationUtil.getResultSetCache().getCount());
        return new int[]{startIndex, endIndex};
    }

    void readGroupsFromStream(InputStream inputStream) throws IOException {
        int size = IOUtil.readInt((InputStream)inputStream);
        this.groups = new CachedList[size];
        int i = 0;
        while (i < size) {
            CachedList list = new CachedList(this.tempDir, DataEngineSession.getCurrentClassLoader(), GroupInfo.getCreator());
            int asize = IOUtil.readInt((InputStream)inputStream);
            int j = 0;
            while (j < asize) {
                GroupInfo groupInfo = new GroupInfo();
                groupInfo.parent = IOUtil.readInt((InputStream)inputStream);
                groupInfo.firstChild = IOUtil.readInt((InputStream)inputStream);
                list.add(groupInfo);
                ++j;
            }
            this.groups[i] = list;
            ++i;
        }
    }

    void saveGroupsToStream(OutputStream outputStream) throws IOException {
        int size = this.groups.length;
        IOUtil.writeInt((OutputStream)outputStream, (int)size);
        int i = 0;
        while (i < size) {
            List list = this.groups[i];
            int asize = list.size();
            IOUtil.writeInt((OutputStream)outputStream, (int)asize);
            int j = 0;
            while (j < asize) {
                GroupInfo groupInfo = (GroupInfo)list.get(j);
                IOUtil.writeInt((OutputStream)outputStream, (int)groupInfo.parent);
                IOUtil.writeInt((OutputStream)outputStream, (int)groupInfo.firstChild);
                ++j;
            }
            ++i;
        }
    }

    List[] getGroupBoundaryInfos() throws DataException {
        List[] groupBoundaryInfos = new List[this.groups.length];
        int i = 1;
        while (i <= this.groups.length) {
            groupBoundaryInfos[i - 1] = new CachedList(this.tempDir, DataEngineSession.getCurrentClassLoader(), GroupBoundaryInfo.getCreator());
            int j = 0;
            while (j < this.groups[i - 1].size()) {
                groupBoundaryInfos[i - 1].add(this.getGroupBoundaryInfo(i, j));
                ++j;
            }
            ++i;
        }
        return groupBoundaryInfos;
    }

    private GroupBoundaryInfo getGroupBoundaryInfo(int groupLevel, int groupIndex) throws DataException {
        int startIdx = GroupUtil.getGroupFirstRowIndex(groupLevel, groupIndex, this.groups, this.groupCalculationUtil.getResultSetCache().getCount());
        int endIdx = this.groupCalculationUtil.getResultSetCache().getCount() - 1;
        if (groupIndex < this.groups[groupLevel - 1].size() - 1) {
            endIdx = GroupUtil.getGroupFirstRowIndex(groupLevel, groupIndex + 1, this.groups, this.groupCalculationUtil.getResultSetCache().getCount()) - 1;
        }
        assert (startIdx >= 0);
        assert (endIdx >= 0);
        GroupBoundaryInfo result = new GroupBoundaryInfo(startIdx, endIdx);
        return result;
    }

    private List mergeTwoGroupBoundaryInfoGroups(List higherGroup, List lowerGroup) throws IOException {
        GroupInfoWithIndex groupInfoWithIndex;
        CachedList result = new CachedList(this.tempDir, DataEngineSession.getCurrentClassLoader(), GroupBoundaryInfo.getCreator());
        DiskSortedStack higherSortedStack = new DiskSortedStack(0, false, new GroupInfoWithIndexComparator(2), GroupInfoWithIndex.getCreator());
        DiskSortedStack lowerSortedStack = new DiskSortedStack(0, false, new GroupInfoWithIndexComparator(2), GroupInfoWithIndex.getCreator());
        int i = 0;
        while (i < higherGroup.size()) {
            groupInfoWithIndex = new GroupInfoWithIndex();
            groupInfoWithIndex.groupIndex = i;
            groupInfoWithIndex.groupBoundaryInfo = (GroupBoundaryInfo)higherGroup.get(i);
            higherSortedStack.push(groupInfoWithIndex);
            ++i;
        }
        i = 0;
        while (i < lowerGroup.size()) {
            groupInfoWithIndex = new GroupInfoWithIndex();
            groupInfoWithIndex.groupIndex = i;
            groupInfoWithIndex.groupBoundaryInfo = (GroupBoundaryInfo)lowerGroup.get(i);
            lowerSortedStack.push(groupInfoWithIndex);
            ++i;
        }
        DiskSortedStack resultSortedStack = new DiskSortedStack(0, false, new GroupInfoWithIndexComparator(1), GroupInfoWithIndex.getCreator());
        GroupInfoWithIndex gbiL = (GroupInfoWithIndex)lowerSortedStack.pop();
        int i2 = 0;
        while (i2 < higherSortedStack.size()) {
            GroupInfoWithIndex gbiH = (GroupInfoWithIndex)higherSortedStack.pop();
            while (gbiL != null && gbiL.groupBoundaryInfo.getStartIndex() <= gbiH.groupBoundaryInfo.getEndIndex()) {
                if (gbiH.groupBoundaryInfo.isInBoundary(gbiL.groupBoundaryInfo)) {
                    gbiL.parentGroupIndex = gbiH.groupIndex;
                    resultSortedStack.push(gbiL);
                }
                gbiL = (GroupInfoWithIndex)lowerSortedStack.pop();
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < resultSortedStack.size()) {
            result.add(((GroupInfoWithIndex)resultSortedStack.pop()).groupBoundaryInfo);
            ++i2;
        }
        return result;
    }

    OrderingInfo getOrderingInfo(List[] groups) {
        int i = 1;
        while (i < groups.length) {
            try {
                groups[i] = this.mergeTwoGroupBoundaryInfoGroups(groups[i - 1], groups[i]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        OrderingInfo odInfo = new OrderingInfo();
        int i2 = 0;
        while (i2 < groups[groups.length - 1].size()) {
            odInfo.add(((GroupBoundaryInfo)groups[groups.length - 1].get(i2)).getStartIndex(), ((GroupBoundaryInfo)groups[groups.length - 1].get(i2)).getEndIndex());
            ++i2;
        }
        return odInfo;
    }
}

