/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.BaseQuery;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.transform.IExpressionProcessor;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupCalculationUtil;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInstanceFilter;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInstanceSorter;
import org.eclipse.birt.data.engine.impl.DataEngineSession;

public class GroupProcessorManager {
    private GroupCalculationUtil groupCalculationUtil;
    private ResultSetPopulator populator;
    private IExpressionProcessor exprProcessor;

    public GroupProcessorManager(BaseQuery query, ResultSetPopulator populator, DataEngineSession session) throws DataException {
        this.populator = populator;
        this.groupCalculationUtil = new GroupCalculationUtil(query, this.populator, session);
    }

    public void doGroupFiltering(ResultSetCache rsCache, IExpressionProcessor exprProc) throws DataException {
        this.populator.setCache(rsCache);
        this.exprProcessor = exprProc;
        this.exprProcessor.setResultIterator(this.populator.getResultIterator());
        new GroupInstanceFilter(this).doGroupFiltering(this.populator.getSession().getEngineContext().getScriptContext());
    }

    public void doGroupSorting(ResultSetCache rsCache, IExpressionProcessor exprProc) throws DataException {
        this.populator.setCache(rsCache);
        this.exprProcessor = exprProc;
        this.exprProcessor.setResultIterator(this.populator.getResultIterator());
        new GroupInstanceSorter(this).doGroupSorting(this.populator.getSession().getEngineContext().getScriptContext());
    }

    void calculateExpressionList(List expressionList, List groupLevelList, int type) throws DataException {
        int[] groupLevelArray = new int[groupLevelList.size()];
        int i = 0;
        while (i < groupLevelList.size()) {
            groupLevelArray[i] = (Integer)groupLevelList.get(i);
            ++i;
        }
        this.exprProcessor.evaluateMultiPassExprOnGroup(expressionList.toArray(), groupLevelArray, type);
    }

    public IExpressionProcessor getExpressionProcessor() {
        return this.exprProcessor;
    }

    public ResultSetPopulator getResultSetPopulator() {
        return this.populator;
    }

    public GroupCalculationUtil getGroupCalculationUtil() {
        return this.groupCalculationUtil;
    }
}

