/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IGroupInstanceInfo;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.IPLSDataPopulator;
import org.eclipse.birt.data.engine.impl.document.ResultIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PLSDataPopulator
implements IPLSDataPopulator {
    protected List<Boundary> targetBoundaries;
    protected int jumpGroupLevel = 0;
    protected int rowIndex = -1;
    protected ResultIterator docIt;
    protected Boundary currentBoundary;
    protected boolean isEmpty;

    PLSDataPopulator(List<IGroupInstanceInfo> targetGroups, ResultIterator docIt) throws DataException {
        this.docIt = docIt;
        this.populateBoundary(targetGroups);
        this.populateEmptyInfo();
    }

    @Override
    public ResultIterator getDocumentIterator() {
        return this.docIt;
    }

    private void populateEmptyInfo() {
        this.isEmpty = this.currentBoundary == null || this.currentBoundary.getStart() >= this.docIt.getExprResultSet().getDataSetResultSet().getRowCount();
    }

    private void populateBoundary(List<IGroupInstanceInfo> targetGroups) {
        ArrayList<IGroupInstanceInfo> groups = new ArrayList<IGroupInstanceInfo>(targetGroups);
        Collections.sort(groups, new Comparator<IGroupInstanceInfo>(){

            @Override
            public int compare(IGroupInstanceInfo arg0, IGroupInstanceInfo arg1) {
                if (arg0.getGroupLevel() < arg1.getGroupLevel()) {
                    return -1;
                }
                if (arg0.getGroupLevel() > arg1.getGroupLevel()) {
                    return 1;
                }
                if (arg0.getRowId() < arg1.getRowId()) {
                    return -1;
                }
                if (arg0.getRowId() > arg1.getRowId()) {
                    return 1;
                }
                return 0;
            }
        });
        LinkedList<Boundary> boundaries = new LinkedList<Boundary>();
        block0: for (IGroupInstanceInfo info : groups) {
            int[] groupStartEndingIndex = this.docIt.getExprResultSet().getGroupStartAndEndIndex(info.getGroupLevel());
            int i = 0;
            while (i < groupStartEndingIndex.length) {
                if (groupStartEndingIndex[i] <= info.getRowId() && groupStartEndingIndex[i + 1] > info.getRowId()) {
                    Boundary b = new Boundary(info.getGroupLevel(), groupStartEndingIndex[i], groupStartEndingIndex[i + 1] - 1);
                    for (Boundary target : boundaries) {
                        if (b.containedBy(target)) continue block0;
                    }
                    boundaries.add(b);
                    continue block0;
                }
                i += 2;
            }
        }
        Collections.sort(boundaries, new Comparator<Boundary>(){

            @Override
            public int compare(Boundary o1, Boundary o2) {
                if (o1.start < o2.start) {
                    return -1;
                }
                if (o1.start > o2.start) {
                    return 1;
                }
                return 0;
            }
        });
        this.populateStartingEndingGroupLevel(groups, boundaries);
        if (boundaries.size() > 0) {
            this.currentBoundary = (Boundary)boundaries.get(0);
        }
        this.targetBoundaries = boundaries;
    }

    private void populateStartingEndingGroupLevel(List<IGroupInstanceInfo> groups, List<Boundary> boundaries) {
        int matteredGroupLevel = groups.get(groups.size() - 1).getGroupLevel();
        int i = 0;
        while (i <= matteredGroupLevel) {
            int[] starEndGroupIndex = this.docIt.getExprResultSet().getGroupStartAndEndIndex(i);
            ArrayList<Boundary> temp = new ArrayList<Boundary>(boundaries);
            int j = 0;
            while (j < starEndGroupIndex.length) {
                if (temp.isEmpty()) break;
                ArrayList<Boundary> contained = new ArrayList<Boundary>();
                Iterator it = temp.iterator();
                while (it.hasNext()) {
                    Boundary b = (Boundary)it.next();
                    if (b.groupLevel <= i) {
                        it.remove();
                        continue;
                    }
                    if (b.start >= starEndGroupIndex[j] && b.end <= starEndGroupIndex[j + 1] - 1) {
                        contained.add(b);
                        it.remove();
                        continue;
                    }
                    if (b.start > starEndGroupIndex[j + 1]) break;
                }
                if (!contained.isEmpty()) {
                    ((Boundary)contained.get((int)0)).startGroupLevel = ((Boundary)contained.get((int)0)).startGroupLevel < i ? ((Boundary)contained.get((int)0)).startGroupLevel : i;
                    ((Boundary)contained.get((int)(contained.size() - 1))).endGroupLevel = ((Boundary)contained.get((int)(contained.size() - 1))).endGroupLevel < i ? ((Boundary)contained.get((int)(contained.size() - 1))).endGroupLevel : i;
                }
                j += 2;
            }
            ++i;
        }
    }

    @Override
    public void close() throws BirtException {
        this.docIt.close();
    }

    @Override
    public boolean next() throws DataException {
        block7: {
            if (this.isEmpty) {
                return false;
            }
            try {
                if (!this.docIt.next()) break block7;
                if (this.docIt.getExprResultSet().getCurrentIndex() < this.currentBoundary.start) {
                    this.docIt.moveTo(this.currentBoundary.start);
                } else if (this.docIt.getExprResultSet().getCurrentIndex() > this.currentBoundary.end) {
                    this.targetBoundaries.remove(this.currentBoundary);
                    if (this.targetBoundaries.size() == 0) break block7;
                    this.currentBoundary = this.targetBoundaries.get(0);
                    this.docIt.moveTo(this.currentBoundary.start);
                }
                ++this.rowIndex;
                return true;
            }
            catch (BirtException e1) {
                throw DataException.wrap(e1);
            }
        }
        return false;
    }

    protected static class Boundary {
        private int start;
        private int end;
        private int groupLevel;
        int startGroupLevel;
        int endGroupLevel;

        Boundary(int groupLevel, int start, int end) {
            this.start = start;
            this.end = end;
            this.startGroupLevel = groupLevel;
            this.endGroupLevel = groupLevel;
            this.groupLevel = groupLevel;
        }

        public boolean containedBy(Boundary target) {
            return target.start <= this.start && target.end >= this.end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

