/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl;

import java.util.logging.Logger;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.impl.DimColumn;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFacttableFilterEvalHelper;

public class AggregationFunctionDefinition {
    private String name;
    private String measureName;
    private String paraColName;
    private String functionName;
    private DimLevel paraLevel;
    private IJSFacttableFilterEvalHelper filterEvalHelper;
    private Object paraValue;
    private static Logger logger = Logger.getLogger(AggregationFunctionDefinition.class.getName());

    public Object getParaValue() {
        return this.paraValue;
    }

    public void setParaValue(Object paraValue) {
        this.paraValue = paraValue;
    }

    public AggregationFunctionDefinition(String name, String measureName, String functionName) {
        this(name, measureName, null, null, functionName, null);
    }

    public AggregationFunctionDefinition(String name, String measureName, DimLevel paraLevel, String paraColName, String functionName) {
        this(name, measureName, paraLevel, paraColName, functionName, null);
    }

    public AggregationFunctionDefinition(String name, String measureName, DimLevel paraLevel, String paraColName, String functionName, IJSFacttableFilterEvalHelper filterEvalHelper) {
        Object[] params = new Object[]{name, measureName, functionName};
        logger.entering(AggregationFunctionDefinition.class.getName(), "AggregationFunctionDefinition", params);
        this.name = name;
        this.paraLevel = paraLevel;
        this.paraColName = paraColName;
        this.measureName = measureName;
        this.functionName = functionName;
        this.filterEvalHelper = filterEvalHelper;
        logger.exiting(AggregationFunctionDefinition.class.getName(), "AggregationFunctionDefinition");
    }

    public AggregationFunctionDefinition(String measureName, String functionName) {
        this(null, measureName, null, null, functionName, null);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getMeasureName() {
        return this.measureName;
    }

    public String getName() {
        return this.name;
    }

    public DimColumn getParaCol() {
        if (this.paraLevel == null) {
            return null;
        }
        return new DimColumn(this.paraLevel.getDimensionName(), this.paraLevel.getLevelName(), this.paraColName);
    }

    public IJSFacttableFilterEvalHelper getFilterEvalHelper() {
        return this.filterEvalHelper;
    }
}

