/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.SizeOfUtil;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.document.DocumentObjectCache;
import org.eclipse.birt.data.engine.olap.data.document.DocumentObjectUtil;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentObject;
import org.eclipse.birt.data.engine.olap.data.impl.NamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionKey;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionRow;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.DimensionDivider;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.DimensionDivision;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FTSUNameSaveHelper;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTable;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableRow;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.Bytes;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

public class FactTableAccessor {
    private IDocumentManager documentManager = null;
    private static Logger logger = Logger.getLogger(FactTableAccessor.class.getName());
    private long memoryCacheSize = 0L;

    public FactTableAccessor(IDocumentManager documentManager) {
        logger.entering(FactTableAccessor.class.getName(), "FactTableAccessor", documentManager);
        this.documentManager = documentManager;
        logger.exiting(FactTableAccessor.class.getName(), "FactTableAccessor");
    }

    public FactTable saveFactTable(String factTableName, String[][] factTableJointColumnNames, String[][] DimJointColumnNames, IDatasetIterator iterator, Dimension[] dimensions, String[] measureColumnName, StopSign stopSign) throws BirtException, IOException {
        DiskSortedStack sortedFactTableRows = this.getSortedFactTableRows(iterator, factTableJointColumnNames, measureColumnName, stopSign);
        int segmentCount = FactTableAccessor.getSegmentCount(sortedFactTableRows.size());
        DimensionDivider.DimensionPositionSeeker.DimensionInfo[] dimensionInfo = FactTableAccessor.getDimensionInfo(dimensions);
        MeasureInfo[] measureInfo = FactTableAccessor.getMeasureInfo(iterator, measureColumnName);
        this.saveFactTableMetadata(factTableName, dimensionInfo, measureInfo, segmentCount);
        DimensionDivision[] subDimensions = FactTableAccessor.calculateDimensionDivision(FactTableAccessor.getDimensionMemberCount(dimensions), segmentCount);
        int[][][] columnIndex = this.getColumnIndex(DimJointColumnNames, dimensions);
        DimensionDivider.DimensionPositionSeeker[] dimensionSeekers = new DimensionDivider.DimensionPositionSeeker[dimensions.length];
        int i = 0;
        while (i < dimensionSeekers.length) {
            dimensionSeekers[i] = new DimensionDivider.DimensionPositionSeeker(FactTableAccessor.getDimCombinatedKey(columnIndex[i], dimensions[i].getAllRows(stopSign)));
            ++i;
        }
        FactTableRow currentRow = null;
        FactTableRow lastRow = null;
        int[] dimensionPosition = new int[dimensions.length];
        DocumentObjectCache documentObjectManager = new DocumentObjectCache(this.documentManager);
        DimensionDivider.CombinedPositionContructor combinedPositionCalculator = new DimensionDivider.CombinedPositionContructor(subDimensions);
        FTSUNameSaveHelper saveHelper = new FTSUNameSaveHelper(this.documentManager, factTableName);
        Object popObject = sortedFactTableRows.pop();
        boolean invalidDimensionKey = false;
        int invalidRowNumber = 0;
        while (popObject != null && !stopSign.isStopped()) {
            currentRow = (FactTableRow)popObject;
            if (lastRow != null && currentRow.equals(lastRow)) {
                throw new DataException("data.olap.FacttableRowNotDistinct", currentRow.toString());
            }
            invalidDimensionKey = false;
            int i2 = 0;
            while (i2 < dimensionPosition.length) {
                dimensionPosition[i2] = dimensionSeekers[i2].find(currentRow.getDimensionKeys()[i2]);
                if (dimensionPosition[i2] < 0) {
                    invalidDimensionKey = true;
                    logger.fine("The fact table of cube " + factTableName + " has an invalid data row where the value of dimension key " + Arrays.toString(factTableJointColumnNames[i2]) + " is " + currentRow.getDimensionKeys()[i2].toString() + " which however does not exist in dimension " + dimensions[i2].getName() + ".");
                }
                ++i2;
            }
            if (invalidDimensionKey) {
                popObject = sortedFactTableRows.pop();
                lastRow = currentRow;
                ++invalidRowNumber;
                continue;
            }
            int[] subDimensionIndex = FactTableAccessor.getSubDimensionIndex(dimensionPosition, subDimensions);
            String FTSUDocName = FTSUDocumentObjectNamingUtil.getDocumentObjectName(NamingUtil.getFactTableName(factTableName), subDimensionIndex);
            saveHelper.add(FTSUDocName);
            IDocumentObject documentObject = documentObjectManager.getIDocumentObject(FTSUDocName);
            documentObject.writeBytes(new Bytes(combinedPositionCalculator.calculateCombinedPosition(subDimensionIndex, dimensionPosition).toByteArray()));
            int i3 = 0;
            while (i3 < measureInfo.length) {
                DocumentObjectUtil.writeValue(documentObject, measureInfo[i3].getDataType(), currentRow.getMeasures()[i3]);
                ++i3;
            }
            popObject = sortedFactTableRows.pop();
            lastRow = currentRow;
        }
        saveHelper.save();
        if (invalidRowNumber > 0) {
            logger.warning("The fact table of cube " + factTableName + " has " + invalidRowNumber + "invalid rows where the value of dimension key does not exist in dimension.");
        }
        documentObjectManager.closeAll();
        this.documentManager.flush();
        return new FactTable(factTableName, this.documentManager, dimensionInfo, measureInfo, segmentCount, subDimensions);
    }

    private int[][][] getColumnIndex(String[][] keyColumnNames, Dimension[] dimensions) throws DataException {
        int[][][] columnIndex = new int[keyColumnNames.length][][];
        int i = 0;
        while (i < keyColumnNames.length) {
            columnIndex[i] = new int[keyColumnNames[i].length][];
            ILevel[] levels = dimensions[i].getHierarchy().getLevels();
            int j = 0;
            while (j < keyColumnNames[i].length) {
                columnIndex[i][j] = new int[3];
                columnIndex[i][j][0] = -1;
                int k = 0;
                while (k < levels.length) {
                    String[] columns = levels[k].getKeyNames();
                    int index = this.find(columns, keyColumnNames[i][j]);
                    if (index >= 0) {
                        columnIndex[i][j][0] = 0;
                        columnIndex[i][j][1] = k;
                        columnIndex[i][j][2] = index;
                        break;
                    }
                    columns = levels[k].getAttributeNames();
                    index = this.find(columns, keyColumnNames[i][j]);
                    if (index >= 0) {
                        columnIndex[i][j][0] = 1;
                        columnIndex[i][j][1] = k;
                        columnIndex[i][j][2] = index;
                        break;
                    }
                    ++k;
                }
                if (columnIndex[i][j][0] == -1) {
                    throw new DataException("data.olap.FacttableJointColumnNotExist", keyColumnNames[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return columnIndex;
    }

    private int find(String[] strArray, String str) {
        if (strArray == null) {
            return -1;
        }
        int i = 0;
        while (i < strArray.length) {
            if (strArray[i].equals(str)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static IDiskArray getDimCombinatedKey(int[][] columnIndex, IDiskArray dimRowArray) throws IOException {
        BufferedStructureArray resultArray = new BufferedStructureArray(DimensionKey.getCreator(), dimRowArray.size());
        int i = 0;
        while (i < dimRowArray.size()) {
            DimensionRow dimRow = (DimensionRow)dimRowArray.get(i);
            DimensionKey key = new DimensionKey(columnIndex.length);
            Object[] values = new Object[columnIndex.length];
            int j = 0;
            while (j < columnIndex.length) {
                values[j] = columnIndex[j][0] == 0 ? dimRow.getMembers()[columnIndex[j][1]].getKeyValues()[columnIndex[j][2]] : dimRow.getMembers()[columnIndex[j][1]].getAttributes()[columnIndex[j][2]];
                ++j;
            }
            key.setKeyValues(values);
            key.setDimensionPos(i);
            resultArray.add(key);
            ++i;
        }
        return resultArray;
    }

    private static int getSegmentCount(int factTableRowCount) {
        int segmentCount = factTableRowCount / 2048;
        if (segmentCount * 2048 < factTableRowCount) {
            ++segmentCount;
        }
        return segmentCount;
    }

    private static DimensionDivider.DimensionPositionSeeker.DimensionInfo[] getDimensionInfo(Dimension[] dimension) {
        DimensionDivider.DimensionPositionSeeker.DimensionInfo[] dimensionInfo = new DimensionDivider.DimensionPositionSeeker.DimensionInfo[dimension.length];
        int i = 0;
        while (i < dimension.length) {
            dimensionInfo[i] = new DimensionDivider.DimensionPositionSeeker.DimensionInfo();
            dimensionInfo[i].dimensionName = dimension[i].getName();
            dimensionInfo[i].dimensionLength = dimension[i].length();
            ++i;
        }
        return dimensionInfo;
    }

    private static MeasureInfo[] getMeasureInfo(IDatasetIterator iterator, String[] measureColumnName) throws BirtException {
        MeasureInfo[] measureInfo = new MeasureInfo[measureColumnName.length];
        int i = 0;
        while (i < measureColumnName.length) {
            measureInfo[i] = new MeasureInfo(measureColumnName[i], iterator.getFieldType(measureColumnName[i]));
            ++i;
        }
        return measureInfo;
    }

    private void saveFactTableMetadata(String factTableName, DimensionDivider.DimensionPositionSeeker.DimensionInfo[] dimensionInfo, MeasureInfo[] measureInfo, int segmentNumber) throws IOException, BirtException {
        IDocumentObject documentObject = this.documentManager.createDocumentObject(NamingUtil.getFactTableName(factTableName));
        documentObject.writeInt(dimensionInfo.length);
        int i = 0;
        while (i < dimensionInfo.length) {
            documentObject.writeString(dimensionInfo[i].dimensionName);
            documentObject.writeInt(dimensionInfo[i].dimensionLength);
            ++i;
        }
        documentObject.writeInt(measureInfo.length);
        i = 0;
        while (i < measureInfo.length) {
            documentObject.writeString(measureInfo[i].getMeasureName());
            documentObject.writeInt(measureInfo[i].getDataType());
            ++i;
        }
        documentObject.writeInt(segmentNumber);
        documentObject.close();
    }

    public void setMemoryCacheSize(long memoryCacheSize) {
        this.memoryCacheSize = memoryCacheSize;
    }

    private static int getObjectSize(int[] dataType) {
        int size = 0;
        int i = 0;
        while (i < dataType.length) {
            size += SizeOfUtil.sizeOf(dataType[i]);
            ++i;
        }
        return size += SizeOfUtil.getArraySize(dataType.length);
    }

    private DiskSortedStack getSortedFactTableRows(IDatasetIterator iterator, String[][] keyColumnNames, String[] measureColumnNames, StopSign stopSign) throws BirtException, IOException {
        DiskSortedStack result = null;
        if (this.memoryCacheSize != 0L) {
            int bufferSize = this.caculateBufferSize(iterator, keyColumnNames, measureColumnNames);
            result = new DiskSortedStack(bufferSize, true, false, FactTableRow.getCreator());
        } else {
            result = new DiskSortedStack(10000, true, false, FactTableRow.getCreator());
            result.setUseMemoryOnly(true);
        }
        int[][] levelKeyColumnIndex = new int[keyColumnNames.length][];
        int[] measureColumnIndex = new int[measureColumnNames.length];
        int i = 0;
        while (i < keyColumnNames.length) {
            levelKeyColumnIndex[i] = new int[keyColumnNames[i].length];
            int j = 0;
            while (j < keyColumnNames[i].length) {
                levelKeyColumnIndex[i][j] = iterator.getFieldIndex(keyColumnNames[i][j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < measureColumnIndex.length) {
            measureColumnIndex[i] = iterator.getFieldIndex(measureColumnNames[i]);
            ++i;
        }
        while (iterator.next() && !stopSign.isStopped()) {
            FactTableRow factTableRow = new FactTableRow();
            DimensionKey[] dimensionKeys = new DimensionKey[levelKeyColumnIndex.length];
            int i2 = 0;
            while (i2 < levelKeyColumnIndex.length) {
                dimensionKeys[i2] = new DimensionKey(levelKeyColumnIndex[i2].length);
                int j = 0;
                while (j < levelKeyColumnIndex[i2].length) {
                    if (levelKeyColumnIndex[i2][j] >= 0) {
                        dimensionKeys[i2].getKeyValues()[j] = iterator.getValue(levelKeyColumnIndex[i2][j]);
                    }
                    ++j;
                }
                ++i2;
            }
            factTableRow.setDimensionKeys(dimensionKeys);
            Object[] measures = new Object[measureColumnIndex.length];
            int i3 = 0;
            while (i3 < measureColumnIndex.length) {
                measures[i3] = iterator.getValue(measureColumnIndex[i3]);
                ++i3;
            }
            factTableRow.setMeasures(measures);
            result.push(factTableRow);
        }
        return result;
    }

    private int caculateBufferSize(IDatasetIterator iterator, String[][] keyColumnNames, String[] measureColumnNames) throws BirtException {
        int[][] levelKeyColumnDataType = new int[keyColumnNames.length][];
        int[] measureColumnType = new int[measureColumnNames.length];
        int i = 0;
        while (i < keyColumnNames.length) {
            levelKeyColumnDataType[i] = new int[keyColumnNames[i].length];
            int j = 0;
            while (j < keyColumnNames[i].length) {
                levelKeyColumnDataType[i][j] = iterator.getFieldType(keyColumnNames[i][j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < measureColumnType.length) {
            measureColumnType[i] = iterator.getFieldType(measureColumnNames[i]);
            ++i;
        }
        int levelSize = 0;
        int i2 = 0;
        while (i2 < levelKeyColumnDataType.length) {
            levelSize += FactTableAccessor.getObjectSize(levelKeyColumnDataType[i2]);
            ++i2;
        }
        int measureSize = FactTableAccessor.getObjectSize(measureColumnType);
        int rowSize = 16 + (4 + (levelSize + measureSize) - 1) / 8 * 8;
        return (int)(this.memoryCacheSize / (long)rowSize);
    }

    private static int[] getDimensionMemberCount(Dimension[] dimension) {
        int[] dimensionMemberCount = new int[dimension.length];
        int i = 0;
        while (i < dimension.length) {
            dimensionMemberCount[i] = dimension[i].length();
            ++i;
        }
        return dimensionMemberCount;
    }

    static DimensionDivision[] calculateDimensionDivision(int[] dimensionMemberCount, int blockNumber) {
        int[] subDimensionCount = DimensionDivider.divideDimension(dimensionMemberCount, blockNumber);
        DimensionDivision[] result = new DimensionDivision[dimensionMemberCount.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new DimensionDivision(dimensionMemberCount[i], subDimensionCount[i]);
            ++i;
        }
        return result;
    }

    private static int[] getSubDimensionIndex(int[] dimensionPosition, DimensionDivision[] dimensionDivision) {
        assert (dimensionPosition.length == dimensionDivision.length);
        int[] result = new int[dimensionPosition.length];
        int i = 0;
        while (i < result.length) {
            result[i] = dimensionDivision[i].getSubDimensionIndex(dimensionPosition[i]);
            ++i;
        }
        return result;
    }

    public FactTable load(String factTableName, StopSign stopSign) throws IOException {
        int segmentNumber = 0;
        IDocumentObject documentObject = this.documentManager.openDocumentObject(NamingUtil.getFactTableName(factTableName));
        DimensionDivider.DimensionPositionSeeker.DimensionInfo[] dimensionInfo = new DimensionDivider.DimensionPositionSeeker.DimensionInfo[documentObject.readInt()];
        int i = 0;
        while (i < dimensionInfo.length) {
            dimensionInfo[i] = new DimensionDivider.DimensionPositionSeeker.DimensionInfo();
            dimensionInfo[i].dimensionName = documentObject.readString();
            dimensionInfo[i].dimensionLength = documentObject.readInt();
            ++i;
        }
        MeasureInfo[] measureInfo = new MeasureInfo[documentObject.readInt()];
        int i2 = 0;
        while (i2 < measureInfo.length) {
            measureInfo[i2] = new MeasureInfo(documentObject.readString(), documentObject.readInt());
            ++i2;
        }
        segmentNumber = documentObject.readInt();
        int[] dimensionMemberCount = new int[dimensionInfo.length];
        int i3 = 0;
        while (i3 < dimensionInfo.length) {
            dimensionMemberCount[i3] = dimensionInfo[i3].dimensionLength;
            ++i3;
        }
        DimensionDivision[] subDimensions = FactTableAccessor.calculateDimensionDivision(dimensionMemberCount, segmentNumber);
        documentObject.close();
        return new FactTable(factTableName, this.documentManager, dimensionInfo, measureInfo, segmentNumber, subDimensions);
    }

    public static class FTSUDocumentObjectNamingUtil {
        static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        private static char[] buffer = new char[100];

        public static String getDocumentObjectName(String factTableName, int[] subDimensionNumber) {
            int radix = 10;
            int position = 0;
            int k = subDimensionNumber.length - 1;
            while (k >= 0) {
                int i = subDimensionNumber[k];
                while (i > radix) {
                    FTSUDocumentObjectNamingUtil.buffer[position++] = digits[i % radix];
                    i /= radix;
                }
                FTSUDocumentObjectNamingUtil.buffer[position++] = digits[i % radix];
                if (k != 0) {
                    FTSUDocumentObjectNamingUtil.buffer[position++] = 88;
                }
                --k;
            }
            k = 0;
            while (k < position / 2) {
                char c = buffer[position - 1 - k];
                FTSUDocumentObjectNamingUtil.buffer[position - 1 - k] = buffer[k];
                FTSUDocumentObjectNamingUtil.buffer[k] = c;
                ++k;
            }
            return String.valueOf(factTableName) + new String(buffer, 0, position);
        }
    }
}

