/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.File;
import org.eclipse.birt.data.engine.core.security.PropertySecurity;

public class TempPathManager {
    private String tmpPath = PropertySecurity.getSystemProperty("java.io.tmpdir");

    public void setTempPath(String tmpPath) {
        this.tmpPath = tmpPath.endsWith("" + File.separatorChar) ? tmpPath.substring(0, tmpPath.length() - 1) : tmpPath;
    }

    public String getTempFileName(String fileNamePrefix, int objectID, String extName) {
        this.checkTempDir();
        if (extName == null || extName.equals("")) {
            return String.valueOf(this.tmpPath) + File.separatorChar + fileNamePrefix + objectID;
        }
        return String.valueOf(this.tmpPath) + File.separatorChar + fileNamePrefix + objectID + "." + extName;
    }

    private void checkTempDir() {
        File tmpDir = new File(this.tmpPath);
        if (!tmpDir.exists() || !tmpDir.isDirectory()) {
            tmpDir.mkdirs();
        }
        if (!tmpDir.exists() || !tmpDir.isDirectory()) {
            this.tmpPath = PropertySecurity.getSystemProperty("java.io.tmpdir");
        }
    }
}

