/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.util.Collection;
import org.eclipse.birt.data.engine.api.CollectionConditionalExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.olap.api.query.CubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.CubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeElementFactory;
import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperationFactory;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ISubCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.CubeOperationFactory;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.impl.query.SubCubeQueryDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeElementFactory
implements ICubeElementFactory {
    @Override
    public ICubeQueryDefinition createCubeQuery(String name) {
        return new CubeQueryDefinition(name);
    }

    @Override
    public ISubCubeQueryDefinition createSubCubeQuery(String name) {
        return new SubCubeQueryDefinition(name);
    }

    @Override
    public ICubeFilterDefinition creatCubeFilterDefinition(IBaseExpression filterExpr, ILevelDefinition targetLevel, ILevelDefinition[] axisQulifierLevel, Object[] axisQulifierValue) {
        return new CubeFilterDefinition(filterExpr, targetLevel, axisQulifierLevel, axisQulifierValue);
    }

    @Override
    public IFilterDefinition creatLevelMemberFilterDefinition(Collection<IScriptExpression> targetLevels, int operator, Collection<Collection<IScriptExpression>> memberValues) {
        return new FilterDefinition(new CollectionConditionalExpression(targetLevels, operator, memberValues));
    }

    @Override
    public ICubeSortDefinition createCubeSortDefinition(String filterExpr, ILevelDefinition targetLevel, ILevelDefinition[] axisQulifierLevel, Object[] axisQulifierValue, int sortDirection) {
        return this.createCubeSortDefinition(new ScriptExpression(filterExpr), targetLevel, axisQulifierLevel, axisQulifierValue, sortDirection);
    }

    @Override
    public ILevelDefinition createLevel(String dimensionName, String hierarchyName, String levelName) {
        return null;
    }

    @Override
    public ICubeOperationFactory getCubeOperationFactory() {
        return CubeOperationFactory.getInstance();
    }

    @Override
    public ICubeSortDefinition createCubeSortDefinition(IScriptExpression filterExpr, ILevelDefinition targetLevel, ILevelDefinition[] axisQulifierLevel, Object[] axisQulifierValue, int sortDirection) {
        CubeSortDefinition cubeSortDefn = new CubeSortDefinition();
        cubeSortDefn.setExpression(filterExpr);
        cubeSortDefn.setTargetLevel(targetLevel);
        cubeSortDefn.setAxisQualifierLevels(axisQulifierLevel);
        cubeSortDefn.setAxisQualifierValues(axisQulifierValue);
        cubeSortDefn.setSortDirection(sortDirection);
        return cubeSortDefn;
    }
}

