/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.impl.document.stream.VersionManager;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDrillFilter;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IBindingValueFetcher;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationResultSetSaveUtil;
import org.eclipse.birt.data.engine.olap.data.impl.CachedAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.DrilledAggregation;
import org.eclipse.birt.data.engine.olap.data.impl.DrilledAggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.SortedAggregationRowArray;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.ITargetSort;
import org.eclipse.birt.data.engine.olap.driver.CubeResultSet;
import org.eclipse.birt.data.engine.olap.driver.IResultSet;
import org.eclipse.birt.data.engine.olap.impl.query.CubeOperationsExecutor;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinitionIOUtil;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.impl.query.IncrementExecutionHint;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryValidator;
import org.eclipse.birt.data.engine.olap.query.view.DrillOnDimensionHierarchy;
import org.eclipse.birt.data.engine.olap.query.view.DrillOperationExecutor;
import org.eclipse.birt.data.engine.olap.query.view.MirrorOperationExecutor;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.olap.util.sort.DimensionSortEvalHelper;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryExecutor {
    private CubeQueryExecutorHelper cubeQueryExecutorHelper;

    public IResultSet execute(BirtCubeView view, StopSign stopSign, ICube cube, IBindingValueFetcher fetcher) throws IOException, BirtException {
        CubeQueryExecutor executor = view.getCubeQueryExecutor();
        AggregationDefinition[] aggrDefns = this.prepareCube(executor.getCubeQueryDefinition(), view.getAggregationRegisterTable().getCalculatedMembersFromQuery());
        if (aggrDefns == null || aggrDefns.length == 0) {
            return null;
        }
        DrilledAggregationDefinition[] drillAggrDefns = this.preparedDrillAggregation(executor.getCubeQueryDefinition(), aggrDefns);
        int size = aggrDefns.length + drillAggrDefns.length;
        AggregationDefinition[] finalAggregation = new AggregationDefinition[size];
        if (drillAggrDefns.length > 0) {
            System.arraycopy(aggrDefns, 0, finalAggregation, 0, aggrDefns.length);
            System.arraycopy(drillAggrDefns, 0, finalAggregation, aggrDefns.length, drillAggrDefns.length);
        } else {
            finalAggregation = aggrDefns;
        }
        String cubeName = executor.getCubeQueryDefinition().getName();
        if (cubeName == null || cubeName.trim().length() == 0) {
            throw new DataException("data.olap.query.noCubeBinding");
        }
        CubeQueryValidator.validateCubeQueryDefinition(view, cube);
        this.cubeQueryExecutorHelper = new CubeQueryExecutorHelper(cube, executor.getComputedMeasureHelper(), fetcher);
        this.cubeQueryExecutorHelper.setMemoryCacheSize(CacheUtil.computeMemoryBufferSize(view.getAppContext()));
        this.cubeQueryExecutorHelper.setMaxDataObjectRows(CacheUtil.getMaxRows(view.getAppContext()));
        this.cubeQueryExecutorHelper.addJSFilter(executor.getDimensionFilterEvalHelpers());
        this.cubeQueryExecutorHelper.addSimpleLevelFilter(executor.getdimensionSimpleFilter());
        this.cubeQueryExecutorHelper.addAggrMeasureFilter(executor.getMeasureFilterEvalHelpers());
        this.cubeQueryExecutorHelper.addMeasureFilter(executor.getFacttableBasedFilterHelpers());
        this.populateAggregationSort(executor, this.cubeQueryExecutorHelper, 2);
        this.populateAggregationSort(executor, this.cubeQueryExecutorHelper, 1);
        this.populateAggregationSort(executor, this.cubeQueryExecutorHelper, 3);
        IAggregationResultSet[] rs = null;
        this.cubeQueryExecutorHelper.setBreakHierarchy(executor.getCubeQueryDefinition().getFilterOption() == 0);
        switch (executor.getContext().getMode()) {
            case 1: {
                rs = this.populateRs(view, finalAggregation, this.cubeQueryExecutorHelper, stopSign, true);
                rs = this.processOperationOnQuery(view, stopSign, rs, aggrDefns);
                break;
            }
            case 3: {
                rs = this.populateRs(view, finalAggregation, this.cubeQueryExecutorHelper, stopSign, false);
                rs = this.processOperationOnQuery(view, stopSign, rs, aggrDefns);
                break;
            }
            case 2: {
                if (executor.getCubeQueryDefinition().getQueryResultsID() != null) {
                    rs = AggregationResultSetSaveUtil.load(executor.getCubeQueryDefinition().getQueryResultsID(), executor.getContext().getDocReader(), new VersionManager(executor.getContext()).getVersion(), this.cubeQueryExecutorHelper.getMemoryCacheSize());
                    this.initLoadedAggregationResultSets(rs, finalAggregation);
                    rs = this.processOperationOnQuery(view, stopSign, rs, aggrDefns);
                    break;
                }
                rs = this.cubeQueryExecutorHelper.execute(finalAggregation, stopSign);
                MirrorOperationExecutor moe = new MirrorOperationExecutor();
                rs = moe.execute(rs, view, this.cubeQueryExecutorHelper);
                rs = this.processOperationOnQuery(view, stopSign, rs, aggrDefns);
                break;
            }
            default: {
                String id = executor.getCubeQueryDefinition().getQueryResultsID();
                IncrementExecutionHint ieh = null;
                if (CubeQueryDefinitionIOUtil.existStream(executor.getContext().getDocReader(), id)) {
                    ICubeQueryDefinition savedQuery = CubeQueryDefinitionIOUtil.load(id, executor.getContext().getDocReader());
                    ieh = org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinitionUtil.getIncrementExecutionHint(savedQuery, executor.getCubeQueryDefinition());
                }
                if (!CubeQueryDefinitionIOUtil.existStream(executor.getContext().getDocReader(), id) || ieh == null || !ieh.isNoIncrement() && executor.getCubeQueryDefinition().getCubeOperations().length > 0) {
                    rs = this.cubeQueryExecutorHelper.execute(finalAggregation, stopSign);
                    MirrorOperationExecutor moe = new MirrorOperationExecutor();
                    rs = moe.execute(rs, view, this.cubeQueryExecutorHelper);
                } else {
                    rs = AggregationResultSetSaveUtil.load(id, executor.getContext().getDocReader(), new VersionManager(executor.getContext()).getVersion(), this.cubeQueryExecutorHelper.getMemoryCacheSize());
                    this.initLoadedAggregationResultSets(rs, finalAggregation);
                    this.incrementExecute(rs, ieh);
                }
                if (executor.getContext().getDocWriter() != null) {
                    if (id == null) {
                        id = executor.getSession().getQueryResultIDUtil().nextID();
                    }
                    CubeQueryDefinitionIOUtil.save(id, executor.getContext().getDocWriter(), executor.getCubeQueryDefinition());
                    AggregationResultSetSaveUtil.save(id, rs, executor.getContext().getDocWriter());
                    executor.setQueryResultsId(id);
                }
                rs = this.processOperationOnQuery(view, stopSign, rs, aggrDefns);
            }
        }
        return new CubeResultSet(rs, view, this.cubeQueryExecutorHelper);
    }

    private DrilledAggregationDefinition[] preparedDrillAggregation(ICubeQueryDefinition cubeQueryDefinition, AggregationDefinition[] aggrDefns) {
        IEdgeDefinition columnEdge = cubeQueryDefinition.getEdge(2);
        IEdgeDefinition rowEdge = cubeQueryDefinition.getEdge(1);
        List<DrillOnDimensionHierarchy> columnDrill = CubeQueryDefinitionUtil.flatternDrillFilter(columnEdge);
        List<DrillOnDimensionHierarchy> rowDrill = CubeQueryDefinitionUtil.flatternDrillFilter(rowEdge);
        ArrayList<DrillOnDimensionHierarchy> combinedDrill = new ArrayList<DrillOnDimensionHierarchy>();
        combinedDrill.addAll(rowDrill);
        combinedDrill.addAll(columnDrill);
        if (combinedDrill.isEmpty()) {
            return new DrilledAggregationDefinition[0];
        }
        ArrayList<DrilledAggregation> aggregation = new ArrayList<DrilledAggregation>();
        int i = 0;
        while (i < aggrDefns.length) {
            DimLevel[] levels;
            if (aggrDefns[i].getAggregationFunctions() != null && (levels = aggrDefns[i].getLevels()) != null) {
                ArrayList<List<DimLevel>> groupByDimension = new ArrayList<List<DimLevel>>();
                String dimensionName = null;
                ArrayList<DimLevel> list = null;
                int j = 0;
                while (j < levels.length - 1) {
                    if (dimensionName != null && dimensionName.equals(levels[j].getDimensionName())) {
                        if (this.isDrilledLevel(levels[j], combinedDrill)) {
                            list.add(levels[j]);
                        }
                    } else {
                        list = new ArrayList<DimLevel>();
                        if (this.isDrilledLevel(levels[j], combinedDrill)) {
                            list.add(levels[j]);
                        }
                        dimensionName = levels[j].getDimensionName();
                        groupByDimension.add(list);
                    }
                    ++j;
                }
                if (!groupByDimension.isEmpty()) {
                    ArrayList<DimLevel[]> tagetLevels = new ArrayList<DimLevel[]>();
                    tagetLevels.add(levels);
                    this.buildAggregationDimLevel(tagetLevels, groupByDimension, 0);
                    int k = 1;
                    while (k < tagetLevels.size()) {
                        boolean exist = false;
                        int t = 0;
                        while (t < aggregation.size()) {
                            if (((DrilledAggregation)aggregation.get(t)).matchTargetlevels((DimLevel[])tagetLevels.get(k))) {
                                ((DrilledAggregation)aggregation.get(t)).addOriginalAggregation(aggrDefns[i]);
                                exist = true;
                                break;
                            }
                            ++t;
                        }
                        if (!exist) {
                            DrilledAggregation aggr = new DrilledAggregation((DimLevel[])tagetLevels.get(k), cubeQueryDefinition);
                            aggr.addOriginalAggregation(aggrDefns[i]);
                            aggregation.add(aggr);
                        }
                        ++k;
                    }
                }
            }
            ++i;
        }
        DrilledAggregationDefinition[] a = new DrilledAggregationDefinition[aggregation.size()];
        int i2 = 0;
        while (i2 < aggregation.size()) {
            a[i2] = new DrilledAggregationDefinition((DrilledAggregation)aggregation.get(i2), ((DrilledAggregation)aggregation.get(i2)).getSortType(), ((DrilledAggregation)aggregation.get(i2)).getAggregationFunctionDefinition());
            ++i2;
        }
        return a;
    }

    private void buildAggregationDimLevel(List<DimLevel[]> tagetLevels, List<List<DimLevel>> groupByDimension, int dimIndex) {
        List<DimLevel> l = groupByDimension.get(dimIndex);
        ArrayList<DimLevel[]> temp = new ArrayList<DimLevel[]>();
        int t = 0;
        while (t < l.size()) {
            DimLevel dimLevel = l.get(t);
            int i = 0;
            while (i < tagetLevels.size()) {
                temp.add(this.getDrilledDimLevel(dimLevel, tagetLevels.get(i)));
                ++i;
            }
            ++t;
        }
        tagetLevels.addAll(temp);
        if (++dimIndex < groupByDimension.size()) {
            this.buildAggregationDimLevel(tagetLevels, groupByDimension, dimIndex);
        }
    }

    private DimLevel[] getDrilledDimLevel(DimLevel dimLevel, DimLevel[] levels) {
        boolean find = false;
        ArrayList<DimLevel> d = new ArrayList<DimLevel>();
        int i = 0;
        while (i < levels.length) {
            if (!dimLevel.getDimensionName().equals(levels[i].getDimensionName())) {
                d.add(levels[i]);
            } else {
                if (dimLevel.equals(levels[i])) {
                    find = true;
                    d.add(levels[i]);
                }
                if (!find) {
                    d.add(levels[i]);
                }
            }
            ++i;
        }
        DimLevel[] dim = new DimLevel[d.size()];
        int i2 = 0;
        while (i2 < dim.length) {
            dim[i2] = (DimLevel)d.get(i2);
            ++i2;
        }
        return dim;
    }

    private boolean isDrilledLevel(DimLevel levels, List<DrillOnDimensionHierarchy> combinedDrill) {
        int i = 0;
        while (i < combinedDrill.size()) {
            DrillOnDimensionHierarchy dim = combinedDrill.get(i);
            List<IEdgeDrillFilter> filters = dim.getDrillFilterByLevel(levels);
            if (filters != null && !filters.isEmpty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IAggregationResultSet[] processOperationOnQuery(BirtCubeView view, StopSign stopSign, IAggregationResultSet[] rs, AggregationDefinition[] aggrDefns) throws DataException, IOException, BirtException {
        DrillOperationExecutor drillOp = new DrillOperationExecutor();
        IAggregationResultSet[] baseRs = new IAggregationResultSet[aggrDefns.length];
        System.arraycopy(rs, 0, baseRs, 0, aggrDefns.length);
        IAggregationResultSet[] drillRs = new IAggregationResultSet[rs.length - aggrDefns.length];
        System.arraycopy(rs, aggrDefns.length, drillRs, 0, drillRs.length);
        rs = drillOp.execute(baseRs, drillRs, view.getCubeQueryDefinition());
        CubeOperationsExecutor coe = new CubeOperationsExecutor(view.getCubeQueryDefinition(), view.getPreparedCubeOperations(), view.getCubeQueryExecutor().getScope(), view.getCubeQueryExecutor().getSession().getEngineContext().getScriptContext());
        rs = coe.execute(rs, stopSign);
        return rs;
    }

    private void initLoadedAggregationResultSets(IAggregationResultSet[] arss, AggregationDefinition[] ads) {
        assert (ads.length <= arss.length);
        int i = 0;
        while (i < ads.length) {
            CachedAggregationResultSet cars = (CachedAggregationResultSet)arss[i];
            cars.setAggregationDefinition(ads[i]);
            ++i;
        }
    }

    private IAggregationResultSet sortAggregationResultSet(IAggregationResultSet rs) throws IOException {
        SortedAggregationRowArray sarr = new SortedAggregationRowArray(rs);
        rs.close();
        return new AggregationResultSet(rs.getAggregationDefinition(), rs.getAllLevels(), sarr.getSortedRows(), rs.getKeyNames(), rs.getAttributeNames());
    }

    private void incrementExecute(IAggregationResultSet[] baseResultSets, IncrementExecutionHint ieh) throws DataException, IOException {
        assert (baseResultSets != null && ieh != null);
        this.applyIncrementSorts(baseResultSets);
    }

    private void applyIncrementSorts(IAggregationResultSet[] baseResultSets) throws DataException, IOException {
        int i = 0;
        while (i < baseResultSets.length) {
            if (baseResultSets[i].getAggregationCount() == 0) {
                baseResultSets[i] = this.sortAggregationResultSet(baseResultSets[i]);
            }
            ++i;
        }
        this.cubeQueryExecutorHelper.applyAggrSort(baseResultSets);
    }

    private IAggregationResultSet[] populateRs(BirtCubeView view, AggregationDefinition[] aggrDefns, CubeQueryExecutorHelper cubeQueryExcutorHelper2, StopSign stopSign, boolean saveToRD) throws IOException, BirtException {
        IAggregationResultSet[] rs;
        String id = null;
        CubeQueryExecutor executor = view.getCubeQueryExecutor();
        if (executor.getCubeQueryDefinition().getQueryResultsID() == null) {
            rs = this.cubeQueryExecutorHelper.execute(aggrDefns, executor.getSession().getStopSign());
            MirrorOperationExecutor moe = new MirrorOperationExecutor();
            rs = moe.execute(rs, view, this.cubeQueryExecutorHelper);
            if (executor.getCubeQueryDefinition().cacheQueryResults()) {
                id = executor.getSession().getQueryResultIDUtil().nextID();
                File tmpDir = new File(executor.getSession().getTempDir());
                if (!FileSecurity.fileExist(tmpDir) || !FileSecurity.fileIsDirectory(tmpDir)) {
                    FileSecurity.fileMakeDirs(tmpDir);
                }
                ArchiveWriter writer = new ArchiveWriter((IArchiveFile)new ArchiveFile(String.valueOf(executor.getSession().getTempDir()) + "Cache", "rw+"));
                AggregationResultSetSaveUtil.save(id, rs, (IDocArchiveWriter)writer);
                writer.finish();
            }
            if (saveToRD) {
                if (id != null) {
                    CubeQueryDefinitionIOUtil.save(id, executor.getContext().getDocWriter(), executor.getCubeQueryDefinition());
                    AggregationResultSetSaveUtil.save(id, rs, executor.getContext().getDocWriter());
                } else {
                    id = executor.getSession().getQueryResultIDUtil().nextID();
                    CubeQueryDefinitionIOUtil.save(id, executor.getContext().getDocWriter(), executor.getCubeQueryDefinition());
                    AggregationResultSetSaveUtil.save(id, rs, executor.getContext().getDocWriter());
                }
            }
        } else {
            id = executor.getCubeQueryDefinition().getQueryResultsID();
            rs = AggregationResultSetSaveUtil.load(id, (IDocArchiveReader)new FileArchiveReader(String.valueOf(executor.getSession().getTempDir()) + "Cache"), VersionManager.getLatestVersion(), this.cubeQueryExecutorHelper.getMemoryCacheSize());
            this.initLoadedAggregationResultSets(rs, aggrDefns);
        }
        executor.setQueryResultsId(id);
        return rs;
    }

    public IResultSet executeSubQuery(IResultSet parentResultSet, BirtCubeView view, int startingColumnLevelIndex, int startingRowLevelIndex) throws IOException {
        return new CubeResultSet(parentResultSet, view, this.cubeQueryExecutorHelper, startingColumnLevelIndex, startingRowLevelIndex);
    }

    private void populateAggregationSort(CubeQueryExecutor executor, CubeQueryExecutorHelper cubeQueryExcutorHelper, int type) throws DataException {
        List columnSort;
        switch (type) {
            case 2: {
                columnSort = executor.getColumnEdgeSort();
                break;
            }
            case 1: {
                columnSort = executor.getRowEdgeSort();
                break;
            }
            case 3: {
                columnSort = executor.getPageEdgeSort();
                break;
            }
            default: {
                return;
            }
        }
        int i = 0;
        while (i < columnSort.size()) {
            block23: {
                ITargetSort targetSort;
                block22: {
                    DimLevel[] aggrOnLevels;
                    String bindingName;
                    ICubeSortDefinition cubeSort;
                    block25: {
                        List aggrOns;
                        block24: {
                            IBinding referBinding;
                            String expr;
                            ICubeQueryDefinition queryDefn;
                            block21: {
                                cubeSort = (ICubeSortDefinition)columnSort.get(i);
                                queryDefn = executor.getCubeQueryDefinition();
                                expr = cubeSort.getExpression().getText();
                                targetSort = null;
                                if ((cubeSort.getAxisQualifierLevels().length != 0 || !OlapExpressionUtil.isComplexDimensionExpr(expr) && !OlapExpressionUtil.isReferenceToAttribute(cubeSort.getExpression(), queryDefn.getBindings())) && OlapExpressionUtil.isDirectRerenrence(cubeSort.getExpression(), executor.getCubeQueryDefinition().getBindings())) break block21;
                                Scriptable scope = executor.getSession().getSharedScope();
                                targetSort = new DimensionSortEvalHelper(executor.getOuterResults(), scope, queryDefn, cubeSort, executor.getSession().getEngineContext().getScriptContext());
                                break block22;
                            }
                            bindingName = OlapExpressionUtil.getBindingName(expr);
                            if (bindingName == null) break block23;
                            List bindings = queryDefn.getBindings();
                            aggrOns = null;
                            IBinding binding = null;
                            int j = 0;
                            while (j < bindings.size()) {
                                binding = (IBinding)bindings.get(j);
                                if (binding.getBindingName().equals(bindingName)) {
                                    aggrOns = binding.getAggregatOns();
                                    break;
                                }
                                ++j;
                            }
                            aggrOnLevels = null;
                            if (aggrOns != null && aggrOns.size() != 0) break block24;
                            if (binding == null) break block23;
                            String measureName = OlapExpressionCompiler.getReferencedScriptObject(binding.getExpression(), "measure");
                            if (measureName == null && (referBinding = OlapExpressionUtil.getDirectMeasureBinding(binding, bindings)) != null) {
                                measureName = OlapExpressionUtil.getMeasure(referBinding.getExpression());
                                bindingName = referBinding.getBindingName();
                                aggrOns = referBinding.getAggregatOns();
                            }
                            if (aggrOns != null && aggrOns.size() > 0) {
                                aggrOnLevels = new DimLevel[aggrOns.size()];
                                int j2 = 0;
                                while (j2 < aggrOnLevels.length) {
                                    aggrOnLevels[j2] = OlapExpressionUtil.getTargetDimLevel(aggrOns.get(j2).toString());
                                    ++j2;
                                }
                            } else if (measureName != null) {
                                List measureAggrOns = CubeQueryDefinitionUtil.populateMeasureAggrOns(queryDefn);
                                aggrOnLevels = new DimLevel[measureAggrOns.size()];
                                int k = 0;
                                while (k < measureAggrOns.size()) {
                                    aggrOnLevels[k] = (DimLevel)measureAggrOns.get(k);
                                    ++k;
                                }
                            }
                            break block25;
                        }
                        aggrOnLevels = new DimLevel[aggrOns.size()];
                        int j = 0;
                        while (j < aggrOnLevels.length) {
                            aggrOnLevels[j] = OlapExpressionUtil.getTargetDimLevel(aggrOns.get(j).toString());
                            ++j;
                        }
                    }
                    DimLevel[] axisLevels = new DimLevel[cubeSort.getAxisQualifierLevels().length];
                    int k = 0;
                    while (k < axisLevels.length) {
                        axisLevels[k] = new DimLevel(cubeSort.getAxisQualifierLevels()[k]);
                        ++k;
                    }
                    targetSort = new AggrSortDefinition(aggrOnLevels, bindingName, axisLevels, cubeSort.getAxisQualifierValues(), new DimLevel(cubeSort.getTargetLevel()), cubeSort.getSortDirection());
                }
                switch (type) {
                    case 2: {
                        cubeQueryExcutorHelper.addColumnSort(targetSort);
                        break;
                    }
                    case 1: {
                        cubeQueryExcutorHelper.addRowSort(targetSort);
                        break;
                    }
                    case 3: {
                        cubeQueryExcutorHelper.addPageSort(targetSort);
                    }
                }
            }
            ++i;
        }
    }

    private AggregationDefinition[] prepareCube(ICubeQueryDefinition query, CalculatedMember[] calculatedMember) throws DataException {
        int i;
        int index;
        int[] sortType;
        DimLevel[] levelsForFilter;
        IEdgeDefinition columnEdgeDefn = query.getEdge(2);
        ILevelDefinition[] levelsOnColumn = CubeQueryDefinitionUtil.getLevelsOnEdge(columnEdgeDefn);
        IEdgeDefinition rowEdgeDefn = query.getEdge(1);
        ILevelDefinition[] levelsOnRow = CubeQueryDefinitionUtil.getLevelsOnEdge(rowEdgeDefn);
        IEdgeDefinition pageEdgeDefn = query.getEdge(3);
        ILevelDefinition[] levelsOnPage = CubeQueryDefinitionUtil.getLevelsOnEdge(pageEdgeDefn);
        ArrayList<AggregationDefinition> aggregations = new ArrayList<AggregationDefinition>();
        if (columnEdgeDefn != null) {
            levelsForFilter = new DimLevel[levelsOnColumn.length + levelsOnPage.length];
            sortType = new int[levelsOnColumn.length + levelsOnPage.length];
            index = 0;
            while (index < levelsOnPage.length) {
                levelsForFilter[index] = new DimLevel(levelsOnPage[index]);
                sortType[index] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[index], query);
                ++index;
            }
            i = 0;
            while (i < levelsOnColumn.length) {
                levelsForFilter[index] = new DimLevel(levelsOnColumn[i]);
                sortType[index] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[i], query);
                ++index;
                ++i;
            }
            aggregations.add(new AggregationDefinition(levelsForFilter, sortType, null));
        }
        if (rowEdgeDefn != null) {
            levelsForFilter = new DimLevel[levelsOnRow.length + levelsOnPage.length];
            sortType = new int[levelsOnRow.length + levelsOnPage.length];
            index = 0;
            while (index < levelsOnPage.length) {
                levelsForFilter[index] = new DimLevel(levelsOnPage[index]);
                sortType[index] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[index], query);
                ++index;
            }
            i = 0;
            while (i < levelsOnRow.length) {
                levelsForFilter[index] = new DimLevel(levelsOnRow[i]);
                sortType[index] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[i], query);
                ++index;
                ++i;
            }
            aggregations.add(new AggregationDefinition(levelsForFilter, sortType, null));
        }
        if (pageEdgeDefn != null) {
            levelsForFilter = new DimLevel[levelsOnPage.length];
            sortType = new int[levelsOnPage.length];
            int i2 = 0;
            while (i2 < levelsOnPage.length) {
                levelsForFilter[i2] = new DimLevel(levelsOnPage[i2]);
                sortType[i2] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[i2], query);
                ++i2;
            }
            aggregations.add(new AggregationDefinition(levelsForFilter, sortType, null));
        }
        AggregationDefinition[] fromCalculatedMembers = CubeQueryDefinitionUtil.createAggregationDefinitons(calculatedMember, query, null, null);
        aggregations.addAll(Arrays.asList(fromCalculatedMembers));
        return aggregations.toArray(new AggregationDefinition[0]);
    }
}

