/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import java.util.HashMap;
import org.eclipse.birt.report.engine.api.IMetadataFilter;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;

public class MetadataFilter
implements IMetadataFilter {
    static final String TYPE_EXTENDED = "EXTENDED";
    static final String TYPE_LIST = "LIST";
    static final String TYPE_TABLE = "TABLE";
    static final String TYPE_TEMPLATE = "TEMPLATE";
    static final String TYPE_TEXT = "TEXT";
    static final String TYPE_LABEL = "LABEL";
    static final String TYPE_DATA = "DATA";
    private HashMap dataItemCache = new HashMap();
    private HashMap rowHeaderFooterCache = new HashMap();

    public HashMap needMetaData(ReportElementHandle elementHandle) {
        HashMap<String, Object> resultMap = null;
        if (elementHandle instanceof ExtendedItemHandle) {
            resultMap = new HashMap<String, Object>();
            resultMap.put("iid", Boolean.TRUE);
            resultMap.put("bookmark", Boolean.TRUE);
            String elementType = elementHandle.getStringProperty("extensionName");
            if (elementType == null) {
                elementType = TYPE_EXTENDED;
            }
            resultMap.put("element_type", elementType);
            resultMap.put("iid_list", Boolean.TRUE);
        } else if (elementHandle instanceof ListHandle) {
            resultMap = new HashMap();
            resultMap.put("iid", Boolean.TRUE);
            resultMap.put("bookmark", Boolean.TRUE);
            resultMap.put("element_type", TYPE_LIST);
            resultMap.put("iid_list", Boolean.TRUE);
        } else if (elementHandle instanceof TableHandle) {
            resultMap = new HashMap();
            resultMap.put("iid", Boolean.TRUE);
            resultMap.put("bookmark", Boolean.TRUE);
            resultMap.put("element_type", TYPE_TABLE);
            resultMap.put("iid_list", Boolean.TRUE);
        }
        if (elementHandle instanceof ColumnHandle) {
            resultMap = new HashMap();
            resultMap.put("iid", Boolean.TRUE);
        }
        if (elementHandle instanceof RowHandle) {
            DesignElementHandle rowParentHnadle = elementHandle.getContainer();
            if (rowParentHnadle instanceof TableHandle) {
                int slotID = ((TableHandle)rowParentHnadle).findContentSlot((DesignElementHandle)elementHandle);
                if (slotID == 0) {
                    this.rowHeaderFooterCache.put(elementHandle, Boolean.TRUE);
                    resultMap = new HashMap();
                    resultMap.put("type", "wrth");
                    resultMap.put("row-type", "header");
                    resultMap.put("group-id", Boolean.TRUE);
                } else if (3 == slotID) {
                    this.rowHeaderFooterCache.put(elementHandle, Boolean.TRUE);
                    resultMap = new HashMap();
                    resultMap.put("type", "wrtf");
                    resultMap.put("row-type", "footer");
                    resultMap.put("group-id", Boolean.TRUE);
                } else if (2 == slotID) {
                    this.rowHeaderFooterCache.put(elementHandle, Boolean.FALSE);
                    resultMap = new HashMap();
                    resultMap.put("group-id", Boolean.TRUE);
                }
            } else if (rowParentHnadle instanceof TableGroupHandle) {
                TableGroupHandle groupHandle = (TableGroupHandle)rowParentHnadle;
                int groupLevel = -1;
                TableHandle tableHandle = (TableHandle)groupHandle.getContainer();
                SlotHandle groupSlot = tableHandle.getGroups();
                int i = 0;
                while (i < groupSlot.getCount()) {
                    if (groupHandle == groupSlot.get(i)) {
                        groupLevel = i;
                    }
                    ++i;
                }
                int slotID = groupHandle.findContentSlot((DesignElementHandle)elementHandle);
                if (slotID == 0) {
                    this.rowHeaderFooterCache.put(elementHandle, Boolean.TRUE);
                    resultMap = new HashMap();
                    if (groupLevel != -1) {
                        resultMap.put("type", "wrgh" + groupLevel);
                    }
                    resultMap.put("row-type", "group-header");
                    resultMap.put("group-id", Boolean.TRUE);
                } else if (1 == slotID) {
                    this.rowHeaderFooterCache.put(elementHandle, Boolean.TRUE);
                    resultMap = new HashMap();
                    if (groupLevel != -1) {
                        resultMap.put("type", "wrgf" + groupLevel);
                    }
                    resultMap.put("row-type", "group-footer");
                    resultMap.put("group-id", Boolean.TRUE);
                }
            }
        } else if (elementHandle instanceof TemplateReportItemHandle) {
            resultMap = new HashMap();
            resultMap.put("iid", Boolean.TRUE);
            resultMap.put("bookmark", Boolean.TRUE);
            resultMap.put("element_type", TYPE_TEMPLATE);
            resultMap.put("iid_list", Boolean.TRUE);
        } else if (elementHandle instanceof TextItemHandle || elementHandle instanceof TextDataHandle) {
            if (this.isTopLevelElement(elementHandle) || this.isInHeaderFooter(elementHandle)) {
                resultMap = new HashMap();
                resultMap.put("iid", Boolean.TRUE);
                resultMap.put("bookmark", Boolean.TRUE);
                resultMap.put("element_type", TYPE_TEXT);
                resultMap.put("iid_list", Boolean.TRUE);
            }
        } else if (elementHandle instanceof LabelHandle) {
            resultMap = new HashMap();
            resultMap.put("iid", Boolean.TRUE);
            resultMap.put("bookmark", Boolean.TRUE);
            resultMap.put("element_type", TYPE_LABEL);
            resultMap.put("iid_list", Boolean.TRUE);
        } else if (elementHandle instanceof DataItemHandle) {
            Boolean chacheResult = (Boolean)this.dataItemCache.get(elementHandle);
            if (chacheResult == null) {
                if (!this.isTopLevelElement(elementHandle)) {
                    if (elementHandle.getStringProperty("dataSet") != null) {
                        this.dataItemCache.put(elementHandle, Boolean.FALSE);
                        return null;
                    }
                    if (((ReportItemHandle)elementHandle).getDataBindingReference() != null) {
                        this.dataItemCache.put(elementHandle, Boolean.FALSE);
                        return null;
                    }
                    if (!this.isInHeaderFooter(elementHandle)) {
                        this.dataItemCache.put(elementHandle, Boolean.FALSE);
                        return null;
                    }
                }
                this.dataItemCache.put(elementHandle, Boolean.TRUE);
            } else if (!chacheResult.booleanValue()) {
                return null;
            }
            resultMap = new HashMap();
            resultMap.put("iid", Boolean.TRUE);
            resultMap.put("bookmark", Boolean.TRUE);
            resultMap.put("element_type", TYPE_DATA);
            resultMap.put("iid_list", Boolean.TRUE);
        }
        return resultMap;
    }

    private boolean isTopLevelElement(ReportElementHandle elementHandle) {
        DesignElementHandle containerHandle = elementHandle.getContainer();
        return containerHandle instanceof ReportDesignHandle;
    }

    private boolean isInHeaderFooter(ReportElementHandle elementHandle) {
        DesignElementHandle containerHandle = elementHandle.getContainer();
        while (containerHandle != null) {
            if (containerHandle instanceof RowHandle) {
                int slotID;
                Boolean rowResult = (Boolean)this.rowHeaderFooterCache.get(containerHandle);
                if (rowResult != null) {
                    return rowResult;
                }
                RowHandle rowHandle = (RowHandle)containerHandle;
                DesignElementHandle rowParentHnadle = rowHandle.getContainer();
                if (rowParentHnadle instanceof TableHandle) {
                    slotID = ((TableHandle)rowParentHnadle).findContentSlot((DesignElementHandle)rowHandle);
                    if (slotID == 0 || 3 == slotID) {
                        this.rowHeaderFooterCache.put(containerHandle, Boolean.TRUE);
                        return true;
                    }
                } else if (rowParentHnadle instanceof TableGroupHandle && ((slotID = ((TableGroupHandle)rowParentHnadle).findContentSlot((DesignElementHandle)rowHandle)) == 0 || 1 == slotID) && rowParentHnadle.getContainer() instanceof TableHandle) {
                    this.rowHeaderFooterCache.put(containerHandle, Boolean.TRUE);
                    return true;
                }
                this.rowHeaderFooterCache.put(containerHandle, Boolean.FALSE);
            }
            if (containerHandle instanceof ReportDesignHandle) {
                return false;
            }
            if (containerHandle.getStringProperty("dataSet") != null) {
                return false;
            }
            if (containerHandle instanceof ReportItemHandle && ((ReportItemHandle)containerHandle).getDataBindingReference() != null) {
                return false;
            }
            containerHandle = containerHandle.getContainer();
        }
        return false;
    }
}

