WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool sys_session_pkg.log

create or replace package sys_session_pkg as

  -- Author  : BOBO,Alan Lee
  -- Created : 2009-06-17 10:01:47
  -- Purpose :

  --SSO½ Alan Lee 2010-06-17

  -- ״̬
  s_screen_unregistered constant varchar2(20) := 'screen_unregistered'; -- ҳδע
  s_screen_unauthorized constant varchar2(20) := 'screen_unauthorized'; -- ҳδȨ
  s_session_expired     constant varchar2(20) := 'session_expired'; --sessionʧЧ

  function create_session(p_user_name in varchar2,
                          p_password  in varchar2,
                          p_ip        in varchar2) return varchar2;

  --SSO½ʱ
  function create_sso_session(p_user_name          in varchar2,
                              p_encrypted_password in varchar2,
                              p_ip                 in varchar2)
    return varchar2;

  procedure check_session(p_encoded_session_id varchar2,
                          p_valid              out varchar2,
                          p_session_id         out number,
                          p_code               out varchar2,
                          p_url                varchar2 default null,
                          p_app_id             varchar2 default null,
                          p_port               varchar2 default null);
                          
    --sessionʧЧ  
  procedure expire_session(p_session_id number);
  
  procedure check_bm_session(p_encoded_session_id varchar2,
                             p_valid              OUT varchar2,
                             p_session_id         OUT number,
                             p_message            out varchar2,
                             p_bm_name            varchar2,
                             p_bm_option          varchar);
  procedure check_expire_session;

  function get_session_id(p_encoded_session_id varchar2) return number;

  procedure delete_disabled_session_data;

  --session¼
  procedure relive_session(p_session_id in number,
                           p_password   in varchar2,
                           p_ip         in varchar2);
end sys_session_pkg;
/
create or replace package body sys_session_pkg as

  function create_session(p_user_name in varchar2,
                          p_password  in varchar2,
                          p_ip        in varchar2) return varchar2 is
    v_encrypted_password  sys_user.encrypted_user_password%type;
    v_validation          varchar2(1) := 'N';
    v_user_id             number;
    v_session_id          number;
    v_encryted_session_id varchar2(2000);
  begin

    v_encrypted_password := sys_crypt.md5(p_password);

    select 'Y', a.user_id
      into v_validation, v_user_id
      from sys_user a
     where a.user_name = p_user_name
       and a.encrypted_user_password = v_encrypted_password;

    if v_validation = 'Y' then

      select sys_session_s.nextval into v_session_id from dual;

      v_encryted_session_id := sys_crypt.des_encrypt(to_char(v_session_id));

      insert into sys_session
        (session_id,
         encrypted_session_id,
         user_id,
         role_id,
         company_id,
         user_language,
         app_ip_address,
         client_ip_address,
         login_time,
         logout_time,
         last_active_time,
         note,
         last_update_date,
         last_updated_by,
         creation_date,
         created_by)
      values
        (v_session_id,
         v_encryted_session_id,
         v_user_id,
         null,
         null,
         userenv('lang'),
         null,
         p_ip,
         sysdate,
         null,
         sysdate,
         null,
         sysdate,
         v_user_id,
         sysdate,
         v_user_id);

      commit;
      return v_encryted_session_id;
    end if;

  exception
    when no_data_found then
      return '-1';
  end create_session;

  --SSO½ʱ
  function create_sso_session(p_user_name          in varchar2,
                              p_encrypted_password in varchar2,
                              p_ip                 in varchar2)
    return varchar2 is
    v_encrypted_password  sys_user.encrypted_user_password%type;
    v_validation          varchar2(1) := 'N';
    v_user_id             number;
    v_session_id          number;
    v_encryted_session_id varchar2(2000);
  begin

    v_encrypted_password := p_encrypted_password;

    select 'Y', a.user_id
      into v_validation, v_user_id
      from sys_user a
     where a.user_name = p_user_name
       and a.encrypted_user_password = v_encrypted_password;

    if v_validation = 'Y' then

      select sys_session_s.nextval into v_session_id from dual;

      v_encryted_session_id := sys_crypt.des_encrypt(to_char(v_session_id));

      insert into sys_session
        (session_id,
         encrypted_session_id,
         user_id,
         role_id,
         company_id,
         user_language,
         app_ip_address,
         client_ip_address,
         login_time,
         logout_time,
         last_active_time,
         note,
         last_update_date,
         last_updated_by,
         creation_date,
         created_by)
      values
        (v_session_id,
         v_encryted_session_id,
         v_user_id,
         null,
         null,
         userenv('lang'),
         null,
         p_ip,
         sysdate,
         null,
         sysdate,
         null,
         sysdate,
         v_user_id,
         sysdate,
         v_user_id);

      commit;
      return v_encryted_session_id;
    end if;

  exception
    when no_data_found then
      return '-1';
  end create_sso_session;

  -- make a session expire
  procedure expire_session(p_session_id number) is
    cursor cur_lock is
      select 1
        from sys_user_logins a, sys_session b
       where a.session_id = p_session_id
         and b.session_id = p_session_id
         for update nowait;
  begin
    open cur_lock;

    -- update sys_user_logins last_active_time
    --ֻһεĵ¼
    update sys_user_logins a
       set a.last_active_time = sysdate
     where a.login_id = (select max(login_id)
                           from sys_user_logins l
                          where l.session_id = p_session_id);

    -- delete active session
    delete from sys_session a where a.session_id = p_session_id;

    close cur_lock;
  exception
    when others then
      if cur_lock%isopen then
        close cur_lock;
      end if;
  end;

  -- get session active time in minutes. should get from system parameter in a production environment.
  function get_session_active_time return number is
  begin
    return nvl(sys_parameter_pkg.value('SESSION_TIME_OUT'), 30);
  end;

  procedure check_singl_expire_session(p_encoded_session_id varchar2) is
    v_expire_time date;
    v_user_id     number;
  begin

    select a.user_id
      into v_user_id
      from sys_session a
     where a.encrypted_session_id = p_encoded_session_id;

    v_expire_time := sysdate - get_session_active_time() / 60 / 24;
    for cur_sys_session in (select a.session_id
                              from sys_session a
                             where a.last_active_time < v_expire_time
                               and a.user_id = v_user_id) loop
      expire_session(cur_sys_session.session_id);
      commit;
    end loop;
  exception
    when no_data_found then
      null;
  end;

  -- check if a session is valid
  -- return: 'Y' if valid, 'N' if not valid
  procedure check_session(p_encoded_session_id varchar2,
                          p_valid              out varchar2,
                          p_session_id         out number,
                          p_code               out varchar2,
                          p_url                varchar2 default null,
                          p_app_id             varchar2 default null,
                          p_port               varchar2 default null) is
    ln_count  number;
    v_service sys_service%rowtype;
  begin

    --Modify by bobo 2010.05.31
    --check_expire_session;
    check_singl_expire_session(p_encoded_session_id);
    p_code := null;
     begin
        select a.session_id, 'Y'
          into p_session_id, p_valid
          from sys_session a
         where a.encrypted_session_id = p_encoded_session_id;
         exception
            when no_data_found then
              p_session_id:=-1;
              p_valid:='Y';
         end;
    begin
      select *
        into v_service
        from sys_service ss
       where ss.service_name = p_url;
    exception
      when no_data_found then
        p_valid      := 'N';
        p_session_id := -1;
        p_code       := s_screen_unregistered; --' ҳûע!';
        return;
    end;
    if (v_service.is_login_required = 0) then
      p_valid      := 'Y';

    else
      begin

        if (v_service.is_access_checked = 1 and
           v_service.is_system_access = 0) then

        select count(1)
            into ln_count
            from sys_role_function sf, sys_session ss
           where sf.role_id = ss.role_id
             and ss.encrypted_session_id = p_encoded_session_id
             and (exists
                  (select 1
                     from sys_function_service sfs
                    where sf.function_id = sfs.function_id
                      and sfs.service_id =
                          (select service_id
                             from sys_service
                            where service_name = p_url)) or exists
                  (select 1
                     from sys_function nsf
                    where nsf.function_id = sf.function_id
                      and nsf.service_id =
                          (select service_id
                             from sys_service
                            where service_name = p_url)));
          if (ln_count = 0) then
            p_valid      := 'N';
            p_session_id := -1;
            p_code       := s_screen_unauthorized; --'ûȨ޷ʸurl';
            return;
          end if;
        end if;

      exception
        when no_data_found then
          p_valid      := 'N';
          p_session_id := -1;
          p_code       := s_session_expired; --'δ¼';
          return;
      end;

    end if;

    update sys_session a
       set a.last_active_time = sysdate,
           a.app_ip_address   = p_app_id,
           a.note             = p_port
     where a.encrypted_session_id = p_encoded_session_id;

    --ֻһεĵ¼
    update sys_user_logins a
       set a.last_active_time = sysdate,
           a.app_ip_address   = p_app_id,
           a.machine_serial   = p_port
     where a.login_id =
           (select max(l.login_id)
              from sys_user_logins l
             where l.encrypted_session_id = p_encoded_session_id);

  end check_session;

  -- session expire check job
  procedure check_expire_session is
    v_expire_time date;
  begin

    v_expire_time := sysdate - get_session_active_time() / 60 / 24;
    for cur_sys_session in (select a.session_id
                              from sys_session a
                             where a.last_active_time < v_expire_time) loop
      expire_session(cur_sys_session.session_id);
      commit;
    end loop;

  end check_expire_session;

  function get_session_id(p_encoded_session_id varchar2) return number is
    v_session_id number;
  begin
    select a.session_id
      into v_session_id
      from sys_session a
     where a.encrypted_session_id = p_encoded_session_id;
    return v_session_id;
  exception
    when no_data_found then
      return - 1;
  end get_session_id;

  procedure delete_disabled_session_data is
    v_sql varchar2(500);
  begin

    v_sql := 'delete from #TABLE_NAME where #SESSION_ID not in (select s.session_id from sys_session s)';

    for v_table in (select h.table_name, h.session_field
                      from sys_session_table_histories h) loop
      select replace(v_sql, '#TABLE_NAME', v_table.table_name)
        into v_sql
        from dual;

      select replace(v_sql, '#SESSION_ID', v_table.session_field)
        into v_sql
        from dual;

      execute immediate v_sql;
      commit;
    end loop;

  end delete_disabled_session_data;

  procedure relive_session(p_session_id in number,
                           p_password   in varchar2,
                           p_ip         in varchar2) is
    r_sys_user_logins    sys_user_logins%rowtype;
    r_sys_user           sys_user%rowtype;
    v_encrypted_password sys_user.encrypted_user_password%type;
    v_exists             number;
    e_password_error exception;
  begin
    begin
      select 1
        into v_exists
        from dual
       where exists
       (select 1 from sys_session where session_id = p_session_id);
      return;
    exception
      when no_data_found then
        null;
    end;

    select *
      into r_sys_user_logins
      from sys_user_logins
     where session_id = p_session_id
       and login_id = (select max(login_id)
                         from sys_user_logins
                        where session_id = p_session_id);
    select *
      into r_sys_user
      from sys_user
     where user_id = r_sys_user_logins.user_id;

    v_encrypted_password := sys_crypt.md5(p_password);

    if v_encrypted_password <> r_sys_user.encrypted_user_password then
      raise e_password_error;
    end if;

    insert into sys_session
      (session_id,
       encrypted_session_id,
       user_id,
       role_id,
       company_id,
       user_language,
       app_ip_address,
       client_ip_address,
       login_time,
       logout_time,
       last_active_time,
       note,
       last_update_date,
       last_updated_by,
       creation_date,
       created_by)
      (select a.session_id,
              a.encrypted_session_id,
              a.user_id,
              a.role_id,
              a.company_id,
              userenv('lang'),
              a.app_ip_address,
              p_ip,
              a.login_time,
              a.logout_time,
              sysdate,
              a.description,
              sysdate,
              a.user_id,
              sysdate,
              a.user_id
         from sys_user_logins a
        where a.session_id = p_session_id
          and login_id = (select max(login_id)
                            from sys_user_logins
                           where session_id = p_session_id));

  exception
    when e_password_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PASSWORD_FAILURE',
                                                      p_created_by              => 1,
                                                      p_package_name            => 'sys_session_pkg',
                                                      p_procedure_function_name => 'relive_session');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => 1,
                                                     p_package_name            => 'sys_session_pkg',
                                                     p_procedure_function_name => 'relive_session');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

  end;
  procedure check_bm_session(p_encoded_session_id varchar2,
                             p_valid              OUT varchar2,
                             p_session_id         OUT number,
                             p_message            out varchar2,
                             p_bm_name            varchar2,
                             p_bm_option          varchar) is
    v_count     number;
    v_sql       varchar2(2000);
    v_bm_option varchar2(20);
  begin

    p_valid   := 'Y';
    p_message := 'Ȩ޲';
    begin
      select ss.session_id
        into p_session_id
        from sys_session ss
       where ss.encrypted_session_id = p_encoded_session_id;
    exception
      when no_data_found then
        p_session_id := -1;
    end;
    select decode(p_bm_option,
                  'batch_update',
                  '''Y''',
                  p_bm_option || '_option')
      into v_bm_option
      from dual;
    v_sql := '
    select count(1)
      from sys_role_function      srf,
           sys_role               sr,
           sys_function_bm_access bf,
           sys_session            ss
     where srf.role_id = sr.role_id
       and srf.function_id = bf.function_id
       and bf.bm_name =''' || p_bm_name || '''
       and sr.role_id = ss.role_id
       and ss.encrypted_session_id =''' || p_encoded_session_id ||
             ''' and ' || v_bm_option || '=''Y''';
    execute immediate v_sql
      into v_count;
    if v_count = 0 then
      p_valid := 'N';

      p_message := 'bm_unauthorized';
    else
      p_valid := 'Y';

      p_message := '';
    end if;
  end;
end sys_session_pkg;
/
spool off

exit