WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool fnd_company_levels_pkg.log

create or replace package fnd_company_levels_pkg is

  -- Author  : BOBO
  -- Created : 2009-6-12 15:34:17
  -- Purpose : ˾

  function get_company_level_id return number;
                                      
  procedure insert_fnd_company_levels(p_company_level_code varchar2,
                                      p_description        varchar2,
                                      p_enabled_flag       varchar2,
                                      p_language_code      varchar2,
                                      p_user_id            number);

  procedure update_fnd_company_levels(p_company_level_code varchar2,
                                      p_description        varchar2,
                                      p_enabled_flag       varchar2,
                                      p_language_code      varchar2,
                                      p_user_id            number);                                      

end fnd_company_levels_pkg;
/
create or replace package body fnd_company_levels_pkg is

  function get_company_level_id return number is
    v_company_level_id fnd_company_levels.company_level_id%type;
  begin
    select fnd_company_levels_s.nextval into v_company_level_id from dual;
    return v_company_level_id;
  end get_company_level_id;
  
    procedure insert_fnd_company_levels(p_company_level_code varchar2,
                                      p_description        varchar2,
                                      p_enabled_flag       varchar2,
                                      p_language_code      varchar2,
                                      p_user_id            number) is
    v_description_id   fnd_company_levels.description_id%type;
    v_company_level_id fnd_company_levels.company_level_id%type;
  begin
    v_company_level_id := get_company_level_id;
    v_description_id   := fnd_description_pkg.get_fnd_description_id;
    insert into fnd_company_levels
      (company_level_id,
       company_level_code,
       description_id,
       enabled_flag,
       created_by,
       creation_date,
       last_updated_by,
       last_update_date)
    values
      (v_company_level_id,
       p_company_level_code,
       v_description_id,
       p_enabled_flag,
       p_user_id,
       sysdate,
       p_user_id,
       sysdate);

    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                               p_ref_table        => 'FND_COMPANY_LEVELS',
                                               p_ref_field        => 'DESCRIPTION_ID',
                                               p_description_text => p_description,
                                               p_function_name    => 'FND2040',
                                               p_created_by       => p_user_id,
                                               p_last_updated_by  => p_user_id,
                                               p_language_code    => p_language_code);

  exception
    when dup_val_on_index then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'FND2040_COMPANY_LEVELS_CODE_DUPLICATE',
                                                      p_created_by              => p_user_id,
                                                      p_package_name            => 'fnd_company_levels_pkg',
                                                      p_procedure_function_name => 'insert_fnd_company_levels');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_user_id,
                                                     p_package_name            => 'fnd_company_levels_pkg',
                                                     p_procedure_function_name => 'insert_fnd_company_levels');

      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end insert_fnd_company_levels;
  
  procedure update_fnd_company_levels(p_company_level_code varchar2,
                                      p_description        varchar2,
                                      p_enabled_flag       varchar2,
                                      p_language_code      varchar2,
                                      p_user_id            number) is
    v_description_id fnd_company_levels.description_id%type;
  begin
    select description_id
      into v_description_id
      from fnd_company_levels l
     where l.company_level_code = p_company_level_code;
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                               p_ref_table        => 'FND_COMPANY_LEVELS',
                                               p_ref_field        => 'DESCRIPTION_ID',
                                               p_description_text => p_description,
                                               p_function_name    => 'FND2040',
                                               p_created_by       => p_user_id,
                                               p_last_updated_by  => p_user_id,
                                               p_language_code    => p_language_code);

    update fnd_company_levels l
       set l.enabled_flag     = p_enabled_flag,
           l.last_updated_by  = p_user_id,
           l.last_update_date = sysdate
     where l.company_level_code = p_company_level_code;

  exception
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_user_id,
                                                     p_package_name            => 'fnd_company_levels_pkg',
                                                     p_procedure_function_name => 'update_fnd_company_levels');

      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end update_fnd_company_levels;

end fnd_company_levels_pkg;
/
spool off

exit
