WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool FND_COUNTRY_PKG.log
create or replace package fnd_country_pkg is

  -- Author  : xiaoguojun
  -- Created : 2009-4-13 17:04:54
  -- Purpose : 

  procedure insert_country(p_country_code  varchar2,
                           p_description   varchar2,
                           p_created_by    number,
                           p_language_code varchar2 default userenv('LANG'));
  procedure update_country(p_country_code  varchar2,
                           p_description   varchar2,
                           p_created_by    number,
                           p_language_code varchar2 default userenv('LANG'));
  procedure delete_country(p_country_code varchar2);

end fnd_country_pkg;
/
create or replace package body fnd_country_pkg is

  procedure insert_country(p_country_code  varchar2,
                           p_description   varchar2,
                           p_created_by    number,
                           p_language_code varchar2 default userenv('LANG')) is
    v_description_id number;
  begin
    v_description_id := fnd_description_pkg.get_fnd_description_id;
    insert into fnd_country_code
      (country_code,
       description_id,
       created_by,
       creation_date,
       last_updated_by,
       last_update_date)
    values
      (upper(p_country_code),
       v_description_id,
       p_created_by,
       sysdate,
       p_created_by,
       sysdate);
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                               p_ref_table        => 'FND_COUNTRY_CODE',
                                               p_ref_field        => 'DESCRIPTION_ID',
                                               p_description_text => p_description,
                                               p_created_by       => p_created_by,
                                               p_last_updated_by  => p_created_by,
                                               p_language_code    => p_language_code);
  exception
    when dup_val_on_index then
      --insert  Ψһ
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'FND_COUNTRY_UNIQUE_ERROR', --
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'FND_COUNTRY_PKG',
                                                      p_procedure_function_name => 'INSERT_COUNTRY');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_created_by,
                                                     p_package_name            => 'FND_COUNTRY_PKG',
                                                     p_procedure_function_name => 'INSERT_COUNTRY');
    
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    
  end insert_country;

  procedure delete_country(p_country_code varchar2) is
  begin
    delete fnd_descriptions b
     where b.ref_table = 'FND_COUNTRY_CODE'
       and b.ref_field = 'DESCRIPTION_ID'
       and exists (select 1
              from fnd_country_code a
             where a.description_id = b.description_id
               and a.country_code = p_country_code);
  
    delete fnd_country_code where country_code = p_country_code;
  
  end delete_country;

  procedure update_country(p_country_code  varchar2,
                           p_description   varchar2,
                           p_created_by    number,
                           p_language_code varchar2 default userenv('LANG')) is
    v_description_id number;
  begin
    begin
      select t.description_id
        into v_description_id
        from fnd_country_code t
       where t.country_code = p_country_code;
    exception
      when others then
        null;
    end;
    if v_description_id is null then
      v_description_id := fnd_description_pkg.get_fnd_description_id;
    end if;
    update fnd_country_code
       set description_id   = v_description_id,
           last_updated_by  = p_created_by,
           last_update_date = sysdate
     where country_code = p_country_code;
  
    if sql%notfound then
      insert_country(p_country_code  => p_country_code,
                     p_description   => p_description,
                     p_created_by    => p_created_by,
                     p_language_code => p_language_code);
    else
      fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                                 p_ref_table        => 'FND_COUNTRY_CODE',
                                                 p_ref_field        => 'DESCRIPTION_ID',
                                                 p_description_text => p_description,
                                                 p_created_by       => p_created_by,
                                                 p_last_updated_by  => p_created_by,
                                                 p_language_code    => p_language_code);
    end if;
  
  end update_country;

end fnd_country_pkg;
/
spool off

exit
