WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool fnd_description_pkg.log

create or replace package fnd_description_pkg is

  -- Author  : Bobo
  -- Created : 2009-3-30 15:27:57
  -- Purpose : 

  function get_fnd_description_id return number;

  --½
  procedure insert_fnd_descriptions(p_description_id   number,
                                    p_ref_table        varchar2,
                                    p_ref_field        varchar2,
                                    p_description_text varchar2,
                                    p_created_by       number,
                                    p_last_updated_by  number,
                                    p_language_code    varchar2,
                                    p_function_name    varchar2 default null);

  -- ¶Ա
  procedure update_fnd_descriptions(p_description_text varchar2,
                                    p_description_id   number,
                                    p_last_updated_by  number,
                                    p_language_code    varchar2,
                                    p_function_name    varchar2 default null);

  --ɾ
  procedure delete_fnd_descriptions(p_description_id number,
                                    p_language       varchar2 default null);

  --ݴdescription_idжǷݣ£½
  procedure reset_fnd_descriptions(p_description_id   number,
                                   p_ref_table        varchar2,
                                   p_ref_field        varchar2,
                                   p_description_text varchar2,
                                   p_created_by       number,
                                   p_last_updated_by  number,
                                   p_language_code    varchar2,
                                   p_function_name    varchar2 default null);

end fnd_description_pkg;
/
create or replace package body fnd_description_pkg is
  e_too_large_for_column exception;
  pragma exception_init(e_too_large_for_column,
                        -12899);

  function get_fnd_description_id return number is
    v_desc_id number;
  begin
    select fnd_descriptions_s.nextval into v_desc_id from dual;
    return v_desc_id;
  
  end get_fnd_description_id;

  procedure insert_fnd_descriptions(p_description_id   number,
                                    p_ref_table        varchar2,
                                    p_ref_field        varchar2,
                                    p_description_text varchar2,
                                    p_created_by       number,
                                    p_last_updated_by  number,
                                    p_language_code    varchar2,
                                    p_function_name    varchar2 default null) is
  begin
    insert into fnd_descriptions
      (description_id,
       language,
       ref_table,
       ref_field,
       description_text,
       function_name,
       created_by,
       creation_date,
       last_updated_by,
       last_update_date)
    values
      (p_description_id,
       p_language_code,
       p_ref_table,
       p_ref_field,
       p_description_text,
       p_function_name,
       p_created_by,
       sysdate,
       p_last_updated_by,
       sysdate);
  
  exception
    when e_too_large_for_column then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_TOO_LARGE_FOR_COLUMNL',
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'fnd_description_pkg',
                                                      p_procedure_function_name => 'insert_fnd_descriptions');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end insert_fnd_descriptions;

  -- ¶Ա
  procedure update_fnd_descriptions(p_description_text varchar2,
                                    p_description_id   number,
                                    p_last_updated_by  number,
                                    p_language_code    varchar2,
                                    p_function_name    varchar2 default null) is
  begin
    update fnd_descriptions f
       set description_text   = p_description_text,
           function_name      = p_function_name,
           f.last_updated_by  = p_last_updated_by,
           f.last_update_date = sysdate
     where description_id = p_description_id
       and language = p_language_code;
  
  exception
    when e_too_large_for_column then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_TOO_LARGE_FOR_COLUMNL',
                                                      p_created_by              => p_last_updated_by,
                                                      p_package_name            => 'fnd_description_pkg',
                                                      p_procedure_function_name => 'update_fnd_descriptions');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    
  end update_fnd_descriptions;

  procedure delete_fnd_descriptions(p_description_id number,
                                    p_language       varchar2 default null) is
  begin
    delete from fnd_descriptions f
     where f.description_id = p_description_id
       and f.language = nvl(p_language,
                            f.language);
  end delete_fnd_descriptions;

  --ݴdescription_idжǷݣ£½
  procedure reset_fnd_descriptions(p_description_id   number,
                                   p_ref_table        varchar2,
                                   p_ref_field        varchar2,
                                   p_description_text varchar2,
                                   p_created_by       number,
                                   p_last_updated_by  number,
                                   p_language_code    varchar2,
                                   p_function_name    varchar2 default null) is
  
    v_exists number;
  begin
    begin
      select 1
        into v_exists
        from fnd_descriptions
       where description_id = p_description_id
         and language = p_language_code;
    
      update_fnd_descriptions(p_description_text => p_description_text,
                              p_function_name    => p_function_name,
                              p_description_id   => p_description_id,
                              p_language_code    => p_language_code,
                              p_last_updated_by  => p_last_updated_by);
    
    exception
      when no_data_found then
      
        for cur_fnd in (select *
                          from fnd_language_code l
                         where installed_flag = 'Y'
                           and not exists
                         (select 1
                                  from fnd_descriptions d
                                 where l.language_code = d.language
                                   and d.description_id = p_description_id)) loop
        
          fnd_description_pkg.insert_fnd_descriptions(p_description_id   => p_description_id,
                                                      p_ref_table        => p_ref_table,
                                                      p_ref_field        => p_ref_field,
                                                      p_description_text => p_description_text,
                                                      p_function_name    => p_function_name,
                                                      p_created_by       => p_created_by,
                                                      p_language_code    => cur_fnd.language_code,
                                                      p_last_updated_by  => p_last_updated_by);
        end loop;
      
    end;
  
  exception
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_last_updated_by,
                                                     p_package_name            => 'fnd_description_pkg',
                                                     p_procedure_function_name => 'reset_fnd_descriptions');
    
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end reset_fnd_descriptions;

end fnd_description_pkg;
/
spool off

exit
