WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool fnd_language_pkg.log

create or replace package fnd_language_pkg is

  -- Author  : xiaoguojun
  -- Created : 2009-4-13 15:08:27
  -- Purpose :

  --modify by zhanglei 2009-6-24
  --locale_code
  
  --modify by zhanglei 2009-6/30
  -- load_language
  
  procedure insert_language(p_sys_language_code varchar2,
                            p_installed_flag    varchar2,
                            p_description       varchar2,
                            p_created_by        number,
                            p_language_code     varchar2 default userenv('LANG'),
                            p_locale_code       varchar2 default null);

  procedure update_language(p_sys_language_code varchar2,
                            p_installed_flag    varchar2,
                            p_description       varchar2,
                            p_created_by        number,
                            p_language_code     varchar2 default userenv('LANG'),
                            p_locale_code       varchar2 default null);

  procedure delete_language(p_sys_language_code varchar2);
  
  procedure load_language(p_sys_language_code varchar2,
                          p_installed_flag    varchar2,
                          p_description       varchar2,
                          p_created_by        number,
                          p_language_code     varchar2,
                          p_locale_code       varchar2 default null);
end fnd_language_pkg;
/
create or replace package body fnd_language_pkg is

  procedure insert_language(p_sys_language_code varchar2,
                            p_installed_flag    varchar2,
                            p_description       varchar2,
                            p_created_by        number,
                            p_language_code     varchar2 default userenv('LANG'),
                            p_locale_code       varchar2 default null) is
    v_description_id number;
  begin
    v_description_id := fnd_description_pkg.get_fnd_description_id;
    insert into fnd_language_code
      (language_code,
       installed_flag,
       description_id,
       locale_code,
       created_by,
       creation_date,
       last_updated_by,
       last_update_date)
    values
      (upper(p_sys_language_code),
       p_installed_flag,
       v_description_id,
       p_locale_code,
       p_created_by,
       sysdate,
       p_created_by,
       sysdate);
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                               p_ref_table        => 'FND_LANGUAGE_CODE',
                                               p_ref_field        => 'DESCRIPTION_ID',
                                               p_description_text => p_description,
                                               p_created_by       => p_created_by,
                                               p_last_updated_by  => p_created_by,
                                               p_language_code    => p_language_code);
  exception
    when dup_val_on_index then
      --insert  Ψһ
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'FND_LANGUAGE_CODE_UNIQUE_ERROR', --
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'FND_LANGUAGE_PKG',
                                                      p_procedure_function_name => 'INSERT_LANGUAGE');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_created_by,
                                                     p_package_name            => 'FND_LANGUAGE_PKG',
                                                     p_procedure_function_name => 'INSERT_LANGUAGE');

      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

  end insert_language;

  procedure delete_language(p_sys_language_code varchar2) is
  begin
    delete fnd_descriptions b
     where b.ref_table = 'FND_LANGUAGE_CODE'
       and b.ref_field = 'DESCRIPTION_ID'
       and exists
     (select 1
              from fnd_language_code a
             where a.description_id = b.description_id
               and a.language_code = p_sys_language_code);

    delete fnd_language_code where language_code = p_sys_language_code;

  end;

  procedure update_language(p_sys_language_code varchar2,
                            p_installed_flag    varchar2,
                            p_description       varchar2,
                            p_created_by        number,
                            p_language_code     varchar2 default userenv('LANG'),
                            p_locale_code       varchar2 default null) is
    v_description_id number;

  begin
    begin
      select t.description_id
        into v_description_id
        from fnd_language_code t
       where t.language_code = upper(p_sys_language_code);
    exception
      when others then
        null;
    end;
    if v_description_id is null then
      v_description_id := fnd_description_pkg.get_fnd_description_id;
    end if;
    update fnd_language_code
       set installed_flag   = p_installed_flag,
           last_updated_by  = p_created_by,
           last_update_date = sysdate,
           description_id   = v_description_id,
           locale_code      = p_locale_code
     where language_code = upper(p_sys_language_code);

    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                               p_ref_table        => 'FND_LANGUAGE_CODE',
                                               p_ref_field        => 'DESCRIPTION_ID',
                                               p_description_text => p_description,
                                               p_created_by       => p_created_by,
                                               p_last_updated_by  => p_created_by,
                                               p_language_code    => p_language_code);

  end update_language;
  
  procedure load_language(p_sys_language_code varchar2,
                          p_installed_flag    varchar2,
                          p_description       varchar2,
                          p_created_by        number,
                          p_language_code     varchar2,
                          p_locale_code       varchar2 default null) is
    v_exists         number;
    v_description_id number;
  begin
    
    begin
      select 1
        into v_exists
        from dual
       where exists (select 1
                       from fnd_language_code
                      where language_code = upper(p_sys_language_code));
      select description_id
        into v_description_id
        from fnd_language_code
       where language_code = upper(p_sys_language_code);
      
      begin
        select 1
          into v_exists
          from dual
         where exists (select 1
                         from fnd_descriptions
                        where description_id = v_description_id
                          and language = p_language_code);
      exception when no_data_found then
        fnd_description_pkg.insert_fnd_descriptions(p_description_id   => v_description_id,
                                                 p_ref_table        => 'FND_LANGUAGE_CODE',
                                                 p_ref_field        => 'DESCRIPTION_ID',
                                                 p_description_text => p_description,
                                                 p_created_by       => p_created_by,
                                                 p_last_updated_by  => p_created_by,
                                                 p_language_code    => p_language_code);    
    
      end;  
       
    exception when no_data_found then
      v_description_id := fnd_description_pkg.get_fnd_description_id;
      insert into fnd_language_code
        (language_code,
         installed_flag,
         description_id,
         locale_code,
         created_by,
         creation_date,
         last_updated_by,
         last_update_date)
      values
        (upper(p_sys_language_code),
         p_installed_flag,
         v_description_id,
         p_locale_code,
         p_created_by,
         sysdate,
         p_created_by,
         sysdate); 
      
      fnd_description_pkg.insert_fnd_descriptions(p_description_id   => v_description_id,
                                                 p_ref_table        => 'FND_LANGUAGE_CODE',
                                                 p_ref_field        => 'DESCRIPTION_ID',
                                                 p_description_text => p_description,
                                                 p_created_by       => p_created_by,
                                                 p_last_updated_by  => p_created_by,
                                                 p_language_code    => p_language_code);    
    
                       
    end;
    
  end;
  
end fnd_language_pkg;
/
spool off

exit