WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool FND_REGION_PKG.log

create or replace package fnd_region_pkg is

  -- Author  : xiaoguojun
  -- Created : 2009-4-14 10:30:00
  -- Purpose : 

  procedure insert_region(p_region_code   varchar2,
                          p_description   varchar2,
                          p_country_code  varchar2,
                          p_created_by    number,
                          p_language_code varchar2 default userenv('LANG'));
  procedure update_region(p_region_code   varchar2,
                          p_description   varchar2,
                          p_country_code  varchar2,
                          p_created_by    number,
                          p_language_code varchar2 default userenv('LANG'));
  procedure delete_region(p_region_code in varchar2);

end fnd_region_pkg;
/
create or replace package body fnd_region_pkg is

  procedure insert_region(p_region_code   varchar2,
                          p_description   varchar2,
                          p_country_code  varchar2,
                          p_created_by    number,
                          p_language_code varchar2 default userenv('LANG')) is
    v_description_id number;
  begin
    v_description_id := fnd_description_pkg.get_fnd_description_id;
    insert into fnd_region_code
      (country_code,
       region_code,
       description_id,
       created_by,
       creation_date,
       last_updated_by,
       last_update_date)
    values
      (upper(p_country_code),
       upper(p_region_code),
       v_description_id,
       p_created_by,
       sysdate,
       p_created_by,
       sysdate);
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                               p_ref_table        => 'FND_REGION_CODE',
                                               p_ref_field        => 'DESCRIPTION_ID',
                                               p_description_text => p_description,
                                               p_created_by       => p_created_by,
                                               p_last_updated_by  => p_created_by,
                                               p_language_code    => p_language_code);
  exception
    when dup_val_on_index then
      --insert  Ψһ
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'FND_REGION_UNIQUE_ERROR', --
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'FND_REGION_PKG',
                                                      p_procedure_function_name => 'INSERT_REGION');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_created_by,
                                                     p_package_name            => 'FND_REGION_PKG',
                                                     p_procedure_function_name => 'INSERT_REGION');
    
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    
  end insert_region;

  procedure delete_region(p_region_code in varchar2) is
  begin
    delete fnd_descriptions b
     where b.ref_table = 'FND_REGION_CODE'
       and b.ref_field = 'DESCRIPTION_ID'
       and exists (select 1
              from fnd_region_code a
             where a.description_id = b.description_id
               and a.region_code = upper(p_region_code));
  
    delete fnd_region_code where region_code = upper(p_region_code);
  end delete_region;

  procedure update_region(p_region_code   varchar2,
                          p_description   varchar2,
                          p_country_code  varchar2,
                          p_created_by    number,
                          p_language_code varchar2 default userenv('LANG')) is
    v_description_id number;
  begin
  
    select t.description_id
      into v_description_id
      from fnd_region_code t
     where t.country_code = upper(p_country_code)
       and t.region_code = upper(p_region_code);
  
    update fnd_region_code
       set description_id   = v_description_id,
           last_updated_by  = p_created_by,
           last_update_date = sysdate
     where country_code = upper(p_country_code)
       and region_code = upper(p_region_code);
  
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                               p_ref_table        => 'FND_REGION_CODE',
                                               p_ref_field        => 'DESCRIPTION_ID',
                                               p_description_text => p_description,
                                               p_created_by       => p_created_by,
                                               p_last_updated_by  => p_created_by,
                                               p_language_code    => p_language_code);
  
  exception
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_created_by,
                                                     p_package_name            => 'FND_REGION_PKG',
                                                     p_procedure_function_name => 'UPDATE_REGION');
    
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    
  end update_region;

end fnd_region_pkg;
/
spool off

exit
