WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool gld_currency_pkg.log

create or replace package gld_currency_pkg is

  -- Author  : xiaoguojun
  -- Created : 2009-4-15 16:13:45
  -- Purpose :

  procedure insert_gld_currency(p_currency_code         varchar2,
                                p_currency_name         varchar2,
                                p_enabled_flag          varchar2,
                                p_country_code          varchar2,
                                p_precision             number,
                                p_transaction_precision number,
                                p_currency_symbol       varchar2,
                                p_created_by            number,
                                p_language_code         varchar2 default userenv('LANG'));
  procedure update_gld_currency(p_currency_code         varchar2,
                                p_currency_name         varchar2,
                                p_enabled_flag          varchar2,
                                p_country_code          varchar2,
                                p_precision             number,
                                p_transaction_precision number,
                                p_currency_symbol       varchar2,
                                p_created_by            number,
                                p_language_code         varchar2 default userenv('LANG'));
  procedure update_gld_currency(p_currency_code         varchar2,
                                p_enabled_flag          varchar2,
                                p_precision             number,
                                p_transaction_precision number,
                                p_currency_symbol       varchar2,
                                p_created_by            number);
  procedure delete_gld_currency(p_currency_code varchar2);
  
  
  --ֵ
  procedure add_gld_currency_load(p_currency_code         varchar2,
                                  p_currency_name         varchar2,
                                  p_enabled_flag          varchar2,
                                  p_country_code          varchar2,
                                  p_precision             number,
                                  p_transaction_precision number,
                                  p_currency_symbol       varchar2,
                                  p_created_by            number,
                                  p_language_code         varchar2);
end gld_currency_pkg;
/
create or replace package body gld_currency_pkg is
  e_integer_error exception;

  procedure ingeter_check(p_number number) is
    v_exists number;
  begin
    select 1
      into v_exists
      from dual
     where regexp_like(p_number,
                       '^[0-9]*$');
  exception
    when no_data_found then
      raise e_integer_error;
  end ingeter_check;

  procedure insert_gld_currency(p_currency_code         varchar2,
                                p_currency_name         varchar2,
                                p_enabled_flag          varchar2,
                                p_country_code          varchar2,
                                p_precision             number,
                                p_transaction_precision number,
                                p_currency_symbol       varchar2,
                                p_created_by            number,
                                p_language_code         varchar2 default userenv('LANG')) is
    v_currency_name_id number;
  begin
    ingeter_check(nvl(p_transaction_precision,
                      -1));
    ingeter_check(nvl(p_precision,
                      -1));

    v_currency_name_id := fnd_description_pkg.get_fnd_description_id;
    insert into gld_currency
      (currency_code,
       enabled_flag,
       currency_name_id,
       country_code,
       precision,
       transaction_precision,
       currency_symbol,
       creation_date,
       created_by,
       last_update_date,
       last_updated_by)
    values
      (upper(p_currency_code),
       p_enabled_flag,
       v_currency_name_id,
       upper(p_country_code),
       p_precision,
       p_transaction_precision,
       p_currency_symbol,
       sysdate,
       p_created_by,
       sysdate,
       p_created_by);
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_currency_name_id,
                                               p_ref_table        => 'GLD_CURRENCY',
                                               p_ref_field        => 'CURRENCY_NAME_ID',
                                               p_description_text => p_currency_name,
                                               p_created_by       => p_created_by,
                                               p_last_updated_by  => p_created_by,
                                               p_language_code    => p_language_code);
  exception
    when e_integer_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'FND1070_INTEGER_ERROR', --
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'GLD_CURRENCY_PKG',
                                                      p_procedure_function_name => 'INSERT_GLD_CURRENCY');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when dup_val_on_index then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'FND1070_CURRENCY_UNIQUE_ERROR', --
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'GLD_CURRENCY_PKG',
                                                      p_procedure_function_name => 'INSERT_GLD_CURRENCY');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_created_by,
                                                     p_package_name            => 'GLD_CURRENCY_PKG',
                                                     p_procedure_function_name => 'INSERT_GLD_CURRENCY');

      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

  end insert_gld_currency;

  procedure update_gld_currency(p_currency_code         varchar2,
                                p_currency_name         varchar2,
                                p_enabled_flag          varchar2,
                                p_country_code          varchar2,
                                p_precision             number,
                                p_transaction_precision number,
                                p_currency_symbol       varchar2,
                                p_created_by            number,
                                p_language_code         varchar2 default userenv('LANG')) is
    v_currency_name_id number;
  begin

    select t.currency_name_id
      into v_currency_name_id
      from gld_currency t
     where t.currency_code = upper(p_currency_code)
       and t.country_code = upper(p_country_code);

    update gld_currency t
       set t.enabled_flag        = p_enabled_flag,
           precision             = p_precision,
           transaction_precision = p_transaction_precision,
           currency_symbol       = p_currency_symbol,
           last_update_date      = sysdate,
           last_updated_by       = p_created_by
     where t.currency_code = upper(p_currency_code)
       and t.country_code = upper(p_country_code);

    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_currency_name_id,
                                               p_ref_table        => 'GLD_CURRENCY',
                                               p_ref_field        => 'CURRENCY_NAME_ID',
                                               p_description_text => p_currency_name,
                                               p_created_by       => p_created_by,
                                               p_last_updated_by  => p_created_by,
                                               p_language_code    => p_language_code);

  exception
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_created_by,
                                                     p_package_name            => 'GLD_CURRENCY_PKG',
                                                     p_procedure_function_name => 'UPDATE_GLD_CURRENCY');

      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

  end update_gld_currency;

  procedure update_gld_currency(p_currency_code         varchar2,
                                p_enabled_flag          varchar2,
                                p_precision             number,
                                p_transaction_precision number,
                                p_currency_symbol       varchar2,
                                p_created_by            number) is
    v_precision             gld_currency.precision%type;
    v_transaction_precision gld_currency.transaction_precision%type;

    e_precision_error exception;
  begin
    ingeter_check(nvl(p_transaction_precision,
                      -1));
    ingeter_check(nvl(p_precision,
                      -1));

    select precision,
           transaction_precision
      into v_precision,
           v_transaction_precision
      from gld_currency t
     where t.currency_code = upper(p_currency_code);
  /**  ȸС
    if p_precision < v_precision or
       p_transaction_precision < v_transaction_precision then
      raise e_precision_error;
    end if;
    **/

    update gld_currency t
       set t.enabled_flag        = p_enabled_flag,
           last_update_date      = sysdate,
           last_updated_by       = p_created_by,
           precision             = p_precision,
           currency_symbol       = p_currency_symbol,
           transaction_precision = p_transaction_precision
     where t.currency_code = upper(p_currency_code);

  exception
    when e_integer_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'FND1070_INTEGER_ERROR', --
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'GLD_CURRENCY_PKG',
                                                      p_procedure_function_name => 'UPDATE_GLD_CURRENCY');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_precision_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'FND1070_CURRENCY_PRECISION', --
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'GLD_CURRENCY_PKG',
                                                      p_procedure_function_name => 'UPDATE_GLD_CURRENCY');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_created_by,
                                                     p_package_name            => 'GLD_CURRENCY_PKG',
                                                     p_procedure_function_name => 'UPDATE_GLD_CURRENCY');

      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end update_gld_currency;

  procedure delete_gld_currency(p_currency_code varchar2) is
  begin
    delete fnd_descriptions b
     where b.ref_table = 'GLD_CURRENCY'
       and b.ref_field = 'CURRENCY_NAME_ID'
       and exists (select 1
              from gld_currency a
             where a.currency_name_id = b.description_id
               and a.currency_code = p_currency_code);

    delete gld_currency t where t.currency_code = p_currency_code;

  end delete_gld_currency;
  
  procedure add_gld_currency_load(p_currency_code         varchar2,
                                  p_currency_name         varchar2,
                                  p_enabled_flag          varchar2,
                                  p_country_code          varchar2,
                                  p_precision             number,
                                  p_transaction_precision number,
                                  p_currency_symbol       varchar2,
                                  p_created_by            number,
                                  p_language_code         varchar2)  is
    v_currency_name_id  number;
    v_language_desc     number;
  begin
    begin
      select currency_name_id
        into v_currency_name_id
        from gld_currency
       where currency_code = p_currency_code;
    
    exception when no_data_found then   
      v_currency_name_id := fnd_description_pkg.get_fnd_description_id;
      insert into gld_currency
        (currency_code,
         enabled_flag,
         currency_name_id,
         country_code,
         precision,
         transaction_precision,
         currency_symbol,
         creation_date,
         created_by,
         last_update_date,
         last_updated_by)
      values
        (upper(p_currency_code),
         p_enabled_flag,
         v_currency_name_id,
         upper(p_country_code),
         p_precision,
         p_transaction_precision,
         p_currency_symbol,
         sysdate,
         p_created_by,
         sysdate,
         p_created_by);
    end;
    
    begin
      select 1
        into v_language_desc
        from fnd_descriptions a
       where a.description_id = v_currency_name_id
         and a.language = p_language_code;
    exception when no_data_found then
      fnd_description_pkg.insert_fnd_descriptions(p_description_id   => v_currency_name_id,
                                                 p_ref_table        => 'GLD_CURRENCY',
                                                 p_ref_field        => 'CURRENCY_NAME_ID',
                                                 p_description_text => p_currency_name,
                                                 p_created_by       => p_created_by,
                                                 p_last_updated_by  => p_created_by,
                                                 p_language_code    => p_language_code);
    end;                                                 
  end;
  
end gld_currency_pkg;
/
spool off

exit
