WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool sys_analytics_pkg.log


create or replace package sys_analytics_pkg is

    -- Author  : JESSEN
    -- Created : 2011/9/29 12:36:12
    -- Purpose :
    function getRatioOfDay(p_day date, p_type varchar2) return number;
    function getMedianDurationOfDay(p_day date, p_type varchar2) return number;
    function getAvgDurationOfDay(p_day date, p_type varchar2) return number;
    function getMaxDurationOfDay(p_day date, p_type varchar2) return number;
    function getMinDurationOfDay(p_day date, p_type varchar2) return number;
    /*    function getMedianDurationOfHour(p_hourStr   varchar2,
                                 p_type      varchar2,
                                 p_startDate date default null,
                                 p_endDate   date default null)
    return number;*/
    function getMedianDurationOfHour(p_day     date,
                                     p_hourStr varchar2,
                                     p_type    varchar2) return number;
    function getMaxDurationOfHour(p_day     date,
                                  p_hourStr varchar2,
                                  p_type    varchar2) return number;
    function getMinDurationOfHour(p_day     date,
                                  p_hourStr varchar2,
                                  p_type    varchar2) return number;
    function getAvgDurationOfHour(p_day     date,
                                  p_hourStr varchar2,
                                  p_type    varchar2) return number;
    procedure gatherDataForDay(p_day date);
    procedure deleteDataOfDay(p_day date);

    procedure getDataOfHour(p_day    date,
                            p_hour   varchar2,
                            p_type   varchar2,
                            p_med    out number,
                            p_max    out number,
                            p_min    out number,
                            p_avg    out number,
                            p_visits out number);
end sys_analytics_pkg;
/
create or replace package body sys_analytics_pkg as
    --ĳ(screen,svc,query)ķ,һеĳɹ
    function getRatioOfDay(p_day date, p_type varchar2) return number is
        v_all     number;
        v_success number;
    begin
        select count(1)
          into v_all
          from sys_runtime_request_record r
         where trunc(r.enter_time) = p_day
           and substr(r.url, length(r.url) - length(p_type) + 1) = p_type;
        if v_all = 0 then
            return 0; --ûд͵ķ򷵻0
        else
            select count(1)
              into v_success
              from sys_runtime_request_record r
             where trunc(r.enter_time) = p_day
               and substr(r.url, length(r.url) - length(p_type) + 1) =
                   p_type
               and r.is_success = '1';
            return v_success / v_all;
        end if;
    end getRatioOfDay;

    --ĳ(screen,svc,query)ķ,һеƽʱ(λ)
    function getMedianDurationOfDay(p_day date, p_type varchar2) return number is
        v_duration number;
    begin
        select nvl(median(rr.duration), 0)
          into v_duration
          from sys_runtime_request_record rr
         where substr(rr.url, length(rr.url) - length(p_type) + 1) = p_type
           and trunc(rr.enter_time) = p_day;

        return v_duration;
    end getMedianDurationOfDay;

    --ĳ(screen,svc,query)ķ,һеƽʱ(ƽֵ)
    function getAvgDurationOfDay(p_day date, p_type varchar2) return number is
        v_duration number;
    begin
        select nvl(avg(rr.duration), 0)
          into v_duration
          from sys_runtime_request_record rr
         where substr(rr.url, length(rr.url) - length(p_type) + 1) = p_type
           and trunc(rr.enter_time) = p_day;

        return v_duration;
    end getAvgDurationOfDay;

    --ĳ(screen,svc,query)ķ,һеʱ
    function getMaxDurationOfDay(p_day date, p_type varchar2) return number is
        v_duration number;
    begin
        select nvl(max(rr.duration), 0)
          into v_duration
          from sys_runtime_request_record rr
         where substr(rr.url, length(rr.url) - length(p_type) + 1) = p_type
           and trunc(rr.enter_time) = p_day;

        return v_duration;
    end getMaxDurationOfDay;

    --ĳ(screen,svc,query)ķ,һеСʱ
    --p_daytruncֵ֮
    function getMinDurationOfDay(p_day date, p_type varchar2) return number is
        v_duration number;
    begin
        select nvl(min(rr.duration), 0)
          into v_duration
          from sys_runtime_request_record rr
         where substr(rr.url, length(rr.url) - length(p_type) + 1) = p_type
           and trunc(rr.enter_time) = p_day;

        return v_duration;
    end getMinDurationOfDay;

    --ĳ(screen,svc,query)ķ,ĳСʱеƽʱ(λ)
    function getMedianDurationOfHour(p_hourStr   varchar2,
                                     p_type      varchar2,
                                     p_startDate date default null,
                                     p_endDate   date default null)
        return number is
        v_duration number;
    begin
        select nvl(median(rr.duration), 0)
          into v_duration
          from sys_runtime_request_record rr
         where substr(rr.url, length(rr.url) - length(p_type) + 1) = p_type
           and to_char(rr.enter_time, 'HH24') = p_hourStr
           and (p_startDate is null or rr.enter_time >= trunc(p_startDate))
           and (p_endDate is null or rr.enter_time < trunc(p_endDate + 1));
        return v_duration;
    end getMedianDurationOfHour;

    function getMedianDurationOfHour(p_day     date,
                                     p_hourStr varchar2,
                                     p_type    varchar2) return number is
        v_duration number;
    begin
        select nvl(median(rr.duration), 0)
          into v_duration
          from sys_runtime_request_record rr
         where substr(rr.url, length(rr.url) - length(p_type) + 1) = p_type
           and to_char(rr.enter_time, 'HH24') = p_hourStr
           and trunc(rr.enter_time) = p_day;
        return v_duration;
    end getMedianDurationOfHour;

    function getMaxDurationOfHour(p_day     date,
                                  p_hourStr varchar2,
                                  p_type    varchar2) return number is
        v_duration number;
    begin
        select nvl(max(rr.duration), 0)
          into v_duration
          from sys_runtime_request_record rr
         where substr(rr.url, length(rr.url) - length(p_type) + 1) = p_type
           and to_char(rr.enter_time, 'HH24') = p_hourStr
           and trunc(rr.enter_time) = p_day;
        return v_duration;
    end getMaxDurationOfHour;

    function getMinDurationOfHour(p_day     date,
                                  p_hourStr varchar2,
                                  p_type    varchar2) return number is
        v_duration number;
    begin
        select nvl(min(rr.duration), 0)
          into v_duration
          from sys_runtime_request_record rr
         where substr(rr.url, length(rr.url) - length(p_type) + 1) = p_type
           and to_char(rr.enter_time, 'HH24') = p_hourStr
           and trunc(rr.enter_time) = p_day;
        return v_duration;
    end getMinDurationOfHour;

    function getAvgDurationOfHour(p_day     date,
                                  p_hourStr varchar2,
                                  p_type    varchar2) return number is
        v_duration number;
    begin
        select nvl(Avg(rr.duration), 0)
          into v_duration
          from sys_runtime_request_record rr
         where substr(rr.url, length(rr.url) - length(p_type) + 1) = p_type
           and to_char(rr.enter_time, 'HH24') = p_hourStr
           and trunc(rr.enter_time) = p_day;
        return v_duration;
    end getAvgDurationOfHour;

    procedure getDataOfDay(p_day    date,
                           p_type   varchar2,
                           p_med    out number,
                           p_max    out number,
                           p_min    out number,
                           p_avg    out number,
                           p_visits out number,
                           p_ratio  out number) is
        v_success number;
    begin
        select nvl(median(rr.duration), 0),
               nvl(max(rr.duration), 0),
               nvl(min(rr.duration), 0),
               nvl(avg(rr.duration), 0),
               count(1)
          into p_med, p_max, p_min, p_avg, p_visits

          from sys_runtime_request_record rr
         where substr(rr.url, length(rr.url) - length(p_type) + 1) = p_type
           and trunc(rr.enter_time) = p_day;
        if p_visits = 0 then
            p_ratio := 0;
        else
            select count(1)
              into v_success
              from sys_runtime_request_record r
             where trunc(r.enter_time) = p_day
               and substr(r.url, length(r.url) - length(p_type) + 1) =
                   p_type
               and r.is_success = '1';
            p_ratio := v_success / p_visits;
        end if;
    end;

    procedure getDataOfHour(p_day    date,
                            p_hour   varchar2,
                            p_type   varchar2,
                            p_med    out number,
                            p_max    out number,
                            p_min    out number,
                            p_avg    out number,
                            p_visits out number) is
    begin
        select nvl(median(rr.duration), 0),
               nvl(max(rr.duration), 0),
               nvl(min(rr.duration), 0),
               nvl(avg(rr.duration), 0),
               count(1)
          into p_med, p_max, p_min, p_avg, p_visits

          from sys_runtime_request_record rr
         where substr(rr.url, length(rr.url) - length(p_type) + 1) = p_type
           and to_char(rr.enter_time, 'HH24') = p_hour
           and trunc(rr.enter_time) = p_day;
    end;

    --sys_runtime_request_recordͳһ쵱еĳЩֵ,ŵһű
    --p_dayΪtruncֵ֮
    procedure gatherDataForDay(p_day date) is
        type arrays is varray(100) of number;
        arr      arrays;
        v_visits number;
        v_hour   varchar2(10);
    begin
        arr := ARRAYS();
        arr.extend(100);
        --------ͳƷ,ƽʱetc.
        select count(1)
          into v_visits
          from sys_runtime_request_record r
         where trunc(r.enter_time) = p_day;

        getDataOfDay(p_day,
                     'screen',
                     arr(1),
                     arr(4),
                     arr(7),
                     arr(10),
                     arr(13),
                     arr(16));
        getDataOfDay(p_day,
                     'svc',
                     arr(2),
                     arr(5),
                     arr(8),
                     arr(11),
                     arr(14),
                     arr(17));
        getDataOfDay(p_day,
                     'query',
                     arr(3),
                     arr(6),
                     arr(9),
                     arr(12),
                     arr(15),
                     arr(18));

        insert into sys_runtime_req_summary
            (id,
             day,
             visits,
             med_dur_screen,
             med_dur_svc,
             med_dur_query,
             max_dur_screen,
             max_dur_svc,
             max_dur_query,
             min_dur_screen,
             min_dur_svc,
             min_dur_query,
             avg_dur_screen,
             avg_dur_svc,
             avg_dur_query,
             ratio_screen,
             ratio_svc,
             ratio_query)
        values
            (sys_runtime_req_summary_s.nextval,
             p_day,
             v_visits,
             arr(1),
             arr(2),
             arr(3),
             arr(4),
             arr(5),
             arr(6),
             arr(7),
             arr(8),
             arr(9),
             arr(10),
             arr(11),
             arr(12),
             arr(16),
             arr(17),
             arr(18));

        -------------Сʱͳ.

        for h in 0 .. 23 loop
            select to_char(h, 'fm09') into v_hour from dual;
            select count(1)
              into v_visits
              from sys_runtime_request_record r
             where trunc(r.enter_time) = p_day
               and to_char(r.enter_time, 'hh24') = v_hour;
            --dbms_output.put_line(v_visits);

            getDataOfHour(p_day,
                          v_hour,
                          'screen',
                          arr(1),
                          arr(4),
                          arr(7),
                          arr(10),
                          arr(13));
            getDataOfHour(p_day,
                          v_hour,
                          'svc',
                          arr(2),
                          arr(5),
                          arr(8),
                          arr(11),
                          arr(14));
            getDataOfHour(p_day,
                          v_hour,
                          'query',
                          arr(3),
                          arr(6),
                          arr(9),
                          arr(12),
                          arr(15));

            insert into sys_runtime_req_summary_hour
                (id,
                 day,
                 hour,
                 visits,
                 med_dur_screen,
                 med_dur_svc,
                 med_dur_query,
                 max_dur_screen,
                 max_dur_svc,
                 max_dur_query,
                 min_dur_screen,
                 min_dur_svc,
                 min_dur_query,
                 avg_dur_screen,
                 avg_dur_svc,
                 avg_dur_query)
            values
                (sys_runtime_req_summary_hour_s.nextval,
                 p_day,
                 v_hour,
                 v_visits,
                 arr(1),
                 arr(2),
                 arr(3),
                 arr(4),
                 arr(5),
                 arr(6),
                 arr(7),
                 arr(8),
                 arr(9),
                 arr(10),
                 arr(11),
                 arr(12));
        end loop;
        --------------ͳù
        insert into sys_runtime_req_top_use
            (select sys_runtime_req_top_use_s.nextval id, p_day day, t.*
               from (select r.url, count(*) visits
                       from SYS_RUNTIME_REQUEST_RECORD r
                      where trunc(r.enter_time) = p_day
                      group by r.url
                      order by count(*) desc) t
              where rownum <= 50);
        ------------------ͳʱ
        insert into sys_runtime_req_top_timeuse
            (select sys_runtime_req_top_timeuse_s.nextval id,
                    p_day                                 day,
                    t.*
               from (select r.url,
                            nvl(median(r.duration), 0) med_duration,
                            nvl(max(r.duration), 0) max_duration,
                            nvl(min(r.duration), 0) min_duration,
                            nvl(avg(r.duration), 0) avg_duration
                       from sys_runtime_request_record r
                      where trunc(r.enter_time) = p_day
                      group by r.url
                      order by median(r.duration) desc) t
              where rownum <= 50);

        ----ͳƺʱϸ

        for rec in (select *
                      from sys_runtime_req_top_timeuse s
                     where s.day = p_day) loop
            insert into sys_runtime_req_url_detail
                (select sys_runtime_req_url_detail_s.nextval id,
                        rec.day                              day,
                        rec.id                               urlid,
                        t.*
                   from (select nvl(d.name,'UNKNOWN') operation,
                                median(d.duration) med_duration,
                                max(d.duration) max_duration,
                                min(d.duration) min_duration,
                                avg(d.duration) avg_duration
                           from sys_runtime_request_detail d
                          where d.request_id in
                                (select distinct dd.request_id
                                   from sys_runtime_request_record dd
                                  where dd.url = rec.url
                                    and rec.day = trunc(dd.enter_time))
                          group by d.name
                          order by median(d.duration) desc) t);

        end loop;
    exception
        when others then
            null;    
    end gatherDataForDay;

    --ɾѾͳƺõ
    procedure deleteDataOfDay(p_day date) is
        v_day date;
    begin
        select trunc(p_day) into v_day from dual;
        delete from sys_runtime_req_summary s where s.day = v_day;
        delete from sys_runtime_req_summary_hour s where s.day = v_day;
        delete from sys_runtime_req_top_use s where s.day = v_day;
        delete from sys_runtime_req_top_timeuse s where s.day = v_day;
        delete from sys_runtime_req_url_detail s where s.day = v_day;
    end deleteDataOfDay;

end sys_analytics_pkg;
/

spool off
exit