WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool sys_code_pkg.log

create or replace package sys_code_pkg as

  function get_sys_code_id return number;
  function get_sys_code_value_id return number;

  procedure insert_sys_code(p_code             varchar2,
                            p_code_name        varchar2,
                            p_code_prompt      varchar2,
                            p_code_name_prompt varchar2,
                            p_language_code    varchar2,
                            p_function_code    varchar2 default null,
                            p_sys_flag         varchar2 default 'Y',
                            p_enabled_flag     varchar2 default 'Y',
                            p_created_by       number default 1,
                            p_last_updated_by  number default 1);

  procedure update_sys_code(p_code             varchar2,
                            p_code_name        varchar2,
                            p_code_prompt      varchar2,
                            p_code_name_prompt varchar2,
                            p_language_code    varchar2,
                            p_function_code    varchar2 default null,
                            p_sys_flag         varchar2 default 'Y',
                            p_enabled_flag     varchar2 default 'Y',
                            p_last_updated_by  number default 1);

  procedure insert_sys_code_value(p_code            varchar2,
                                  p_code_value      varchar2,
                                  p_code_value_name varchar2,
                                  p_language_code   varchar2,
                                  p_function_code   varchar2 default null,
                                  p_enabled_flag    varchar2 default 'Y',
                                  p_created_by      number default 1,
                                  p_last_updated_by number default 1);

  procedure update_sys_code_value(p_code            varchar2,
                                  p_code_value      varchar2,
                                  p_code_value_name varchar2,
                                  p_language_code   varchar2,
                                  p_function_code   varchar2 default null,
                                  p_enabled_flag    varchar2 default 'Y',
                                  p_last_updated_by number default 1);

  procedure delete_sys_code(p_code varchar2);

end sys_code_pkg;
/
create or replace package body sys_code_pkg as

  function get_sys_code_id return number is
    v_code_id sys_codes.code_id%type;
  begin
    select sys_codes_s.nextval into v_code_id from dual;
    return v_code_id;
  end get_sys_code_id;

  function get_sys_code_value_id return number is
    v_code_value_id sys_code_values.code_value_id%type;
  begin
    select sys_code_values_s.nextval into v_code_value_id from dual;
    return v_code_value_id;
  end get_sys_code_value_id;

  procedure insert_sys_code(p_code             varchar2,
                            p_code_name        varchar2,
                            p_code_prompt      varchar2,
                            p_code_name_prompt varchar2,
                            p_language_code    varchar2,
                            p_function_code    varchar2 default null,
                            p_sys_flag         varchar2 default 'Y',
                            p_enabled_flag     varchar2 default 'Y',
                            p_created_by       number default 1,
                            p_last_updated_by  number default 1) as
    v_code_id             sys_codes.code_id%type;
    v_code_name_id        sys_codes.code_name_id%type;
    v_code_prompt_id      sys_codes.code_prompt_id%type;
    v_code_name_prompt_id sys_codes.code_name_prompt_id%type;
  begin
  
    v_code_id             := get_sys_code_id;
    v_code_name_id        := fnd_description_pkg.get_fnd_description_id;
    v_code_prompt_id      := fnd_description_pkg.get_fnd_description_id;
    v_code_name_prompt_id := fnd_description_pkg.get_fnd_description_id;
  
    insert into sys_codes
      (code_id,
       code,
       sys_flag,
       enabled_flag,
       creation_date,
       created_by,
       last_update_date,
       last_updated_by,
       code_name_id,
       code_prompt_id,
       code_name_prompt_id)
    values
      (v_code_id,
       upper(p_code),
       p_sys_flag,
       p_enabled_flag,
       sysdate,
       p_created_by,
       sysdate,
       p_last_updated_by,
       v_code_name_id,
       v_code_prompt_id,
       v_code_name_prompt_id);
  
    -- insert code name
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_code_name_id,
                                               p_ref_table        => 'SYS_CODES',
                                               p_ref_field        => 'CODE_NAME_ID',
                                               p_description_text => p_code_name,
                                               p_function_name    => p_function_code,
                                               p_language_code    => p_language_code,
                                               p_created_by       => p_created_by,
                                               p_last_updated_by  => p_last_updated_by);
  
    -- insert code prompt
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_code_prompt_id,
                                               p_ref_table        => 'SYS_CODES',
                                               p_ref_field        => 'CODE_PROMPT_ID',
                                               p_description_text => p_code_prompt,
                                               p_function_name    => p_function_code,
                                               p_language_code    => p_language_code,
                                               p_created_by       => p_created_by,
                                               p_last_updated_by  => p_last_updated_by);
  
    -- insert code name prompt
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_code_name_prompt_id,
                                               p_ref_table        => 'SYS_CODES',
                                               p_ref_field        => 'CODE_NAME_PROMPT_ID',
                                               p_description_text => p_code_name_prompt,
                                               p_function_name    => p_function_code,
                                               p_language_code    => p_language_code,
                                               p_created_by       => p_created_by,
                                               p_last_updated_by  => p_last_updated_by);
  
  exception
    when dup_val_on_index then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYSCODE_UNIQUE_ERROR', --syscodeظ
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'sys_code_pkg',
                                                      p_procedure_function_name => 'insert_sys_code');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_last_updated_by,
                                                     p_package_name            => 'sys_code_pkg',
                                                     p_procedure_function_name => 'insert_sys_code');
    
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    
  end insert_sys_code;

  procedure update_sys_code(p_code             varchar2,
                            p_code_name        varchar2,
                            p_code_prompt      varchar2,
                            p_code_name_prompt varchar2,
                            p_language_code    varchar2,
                            p_function_code    varchar2 default null,
                            p_sys_flag         varchar2 default 'Y',
                            p_enabled_flag     varchar2 default 'Y',
                            p_last_updated_by  number default 1) is
    v_code_name_id        sys_codes.code_name_id%type;
    v_code_prompt_id      sys_codes.code_prompt_id%type;
    v_code_name_prompt_id sys_codes.code_name_prompt_id%type;
  begin
    select code_name_id,
           code_prompt_id,
           code_name_prompt_id
      into v_code_name_id,
           v_code_prompt_id,
           v_code_name_prompt_id
      from sys_codes s
     where s.code = upper(p_code);
  
    update sys_codes s
       set s.sys_flag         = p_sys_flag,
           s.enabled_flag     = p_enabled_flag,
           s.last_update_date = sysdate,
           s.last_updated_by  = p_last_updated_by
     where s.code = upper(p_code);
  
    -- update code name
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_code_name_id,
                                               p_ref_table        => 'SYS_CODES',
                                               p_ref_field        => 'CODE_NAME_ID',
                                               p_description_text => p_code_name,
                                               p_function_name    => p_function_code,
                                               p_language_code    => p_language_code,
                                               p_created_by       => p_last_updated_by,
                                               p_last_updated_by  => p_last_updated_by);
  
    -- update code prompt
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_code_prompt_id,
                                               p_ref_table        => 'SYS_CODES',
                                               p_ref_field        => 'CODE_PROMPT_ID',
                                               p_description_text => p_code_prompt,
                                               p_function_name    => p_function_code,
                                               p_language_code    => p_language_code,
                                               p_created_by       => p_last_updated_by,
                                               p_last_updated_by  => p_last_updated_by);
  
    -- update code name prompt
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_code_name_prompt_id,
                                               p_ref_table        => 'SYS_CODES',
                                               p_ref_field        => 'CODE_NAME_PROMPT_ID',
                                               p_description_text => p_code_name_prompt,
                                               p_function_name    => p_function_code,
                                               p_language_code    => p_language_code,
                                               p_created_by       => p_last_updated_by,
                                               p_last_updated_by  => p_last_updated_by);
  exception
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_last_updated_by,
                                                     p_package_name            => 'sys_code_pkg',
                                                     p_procedure_function_name => 'update_sys_code');
    
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end update_sys_code;

  procedure insert_sys_code_value(p_code            varchar2,
                                  p_code_value      varchar2,
                                  p_code_value_name varchar2,
                                  p_language_code   varchar2,
                                  p_function_code   varchar2 default null,
                                  p_enabled_flag    varchar2 default 'Y',
                                  p_created_by      number default 1,
                                  p_last_updated_by number default 1) as
  
    v_code_value_id      sys_code_values.code_value_id%type;
    v_code_id            sys_codes.code_id%type;
    v_code_value_name_id sys_code_values.code_value_name_id%type;
  
  begin
  
    select code_id
      into v_code_id
      from sys_codes
     where code = upper(p_code);
    v_code_value_name_id := fnd_description_pkg.get_fnd_description_id;
    v_code_value_id      := get_sys_code_value_id;
  
    insert into sys_code_values
      (code_value_id,
       code_id,
       code_value,
       enabled_flag,
       creation_date,
       created_by,
       last_update_date,
       last_updated_by,
       code_value_name_id)
    values
      (v_code_value_id,
       v_code_id,
       upper(p_code_value),
       p_enabled_flag,
       sysdate,
       p_created_by,
       sysdate,
       p_last_updated_by,
       v_code_value_name_id);
  
    -- insert code value name
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_code_value_name_id,
                                               p_ref_table        => 'SYS_CODE_VALUES',
                                               p_ref_field        => 'CODE_VALUE_NAME_ID',
                                               p_description_text => p_code_value_name,
                                               p_function_name    => p_function_code,
                                               p_created_by       => p_created_by,
                                               p_last_updated_by  => p_last_updated_by,
                                               p_language_code    => p_language_code);
  exception
    when dup_val_on_index then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYSCODE_VALUE_UNIQUE_ERROR', --syscode_valueظ
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'sys_code_pkg',
                                                      p_procedure_function_name => 'insert_sys_code_value');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_last_updated_by,
                                                     p_package_name            => 'sys_code_pkg',
                                                     p_procedure_function_name => 'insert_sys_code_value');
    
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end insert_sys_code_value;

  procedure update_sys_code_value(p_code            varchar2,
                                  p_code_value      varchar2,
                                  p_code_value_name varchar2,
                                  p_language_code   varchar2,
                                  p_function_code   varchar2 default null,
                                  p_enabled_flag    varchar2 default 'Y',
                                  p_last_updated_by number default 1) is
    v_code_id            sys_codes.code_id%type;
    v_code_value_name_id sys_code_values.code_value_name_id%type;
    v_code_value_id      sys_code_values.code_value_id%type;
  begin
    select code_id into v_code_id from sys_codes where code = p_code;
  
    select a.code_value_id,
           a.code_value_name_id
      into v_code_value_id,
           v_code_value_name_id
      from sys_code_values a
     where a.code_value = upper(p_code_value)
       and a.code_id = v_code_id;
  
    update sys_code_values s
       set s.enabled_flag     = p_enabled_flag,
           s.last_update_date = sysdate,
           s.last_updated_by  = p_last_updated_by
     where s.code_value_id = v_code_value_id;
  
    -- update code value name
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_code_value_name_id,
                                               p_ref_table        => 'SYS_CODE_VALUES',
                                               p_ref_field        => 'CODE_VALUE_NAME_ID',
                                               p_description_text => p_code_value_name,
                                               p_function_name    => p_function_code,
                                               p_created_by       => p_last_updated_by,
                                               p_last_updated_by  => p_last_updated_by,
                                               p_language_code    => p_language_code);
  exception
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_last_updated_by,
                                                     p_package_name            => 'sys_code_pkg',
                                                     p_procedure_function_name => 'update_sys_code_value');
    
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    
  end update_sys_code_value;

  procedure delete_sys_code(p_code varchar2) as
    v_code_name_id        sys_codes.code_name_id%type;
    v_code_prompt_id      sys_codes.code_prompt_id%type;
    v_code_name_prompt_id sys_codes.code_name_prompt_id%type;
    v_code_id             sys_codes.code_id%type;
  begin
    select code_name_id,
           code_prompt_id,
           code_name_prompt_id,
           s.code_id
      into v_code_name_id,
           v_code_prompt_id,
           v_code_name_prompt_id,
           v_code_id
      from sys_codes s
     where s.code = upper(p_code);
  
    for cur_value_name_id in (select a.code_value_name_id
                                from sys_code_values a
                               where a.code_id = v_code_id) loop
    
      fnd_description_pkg.delete_fnd_descriptions(p_description_id => cur_value_name_id.code_value_name_id);
    end loop;
  
    fnd_description_pkg.delete_fnd_descriptions(p_description_id => v_code_name_id);
    fnd_description_pkg.delete_fnd_descriptions(p_description_id => v_code_prompt_id);
    fnd_description_pkg.delete_fnd_descriptions(p_description_id => v_code_name_prompt_id);
  
    delete sys_code_values b
     where exists (select 1
              from sys_codes
             where code_id = b.code_id
               and code = p_code);
    delete sys_codes where code = upper(p_code);
  exception
    when no_data_found then
      null;
    
  end delete_sys_code;

end sys_code_pkg;
/
spool off

exit
