WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_CRYPT.log

prompt
prompt Creating package SYS_CRYPT
prompt ============================
prompt
create or replace package SYS_CRYPT is

  -- Author  : VINCENT
  -- Created : 2002-6-27 15:05:31
  -- Purpose : 
  
  -- Public type declarations
  function des_encrypt(input_data in varchar2) return varchar2;
  function des_decrypt(input_data in varchar2) return varchar2;
  function md5 (input_data in varchar2) return varchar2;
  function string_to_hex(input_string in varchar2) return varchar2;
  function hex_to_string(input_string in varchar2) return varchar2;
  function hex_to_raw(inhex varchar2) return varchar2;
end SYS_CRYPT;
/
create or replace package body SYS_CRYPT is

  function get_key return varchar2 is
    v_str_1               varchar2(8);
    v_str_2               varchar2(8);
    v_str_3               varchar2(8);
    v_str_4               varchar2(8);
    v_str_5               varchar2(8);
    v_str_6               varchar2(8);
    v_str_7               varchar2(100);
    v_str_8               varchar2(100);
    v_raw_1               varchar2(100);
    v_raw_2               varchar2(100);
    
  begin
    v_str_1 := chr(49)||chr(57)||chr(55)||chr(48)||chr(54)||chr(66)||chr(55)||chr(51);
    v_str_2 := chr(49)||chr(52)||chr(55)||chr(70)||chr(48)||chr(48)||chr(54)||chr(48);
    v_str_3 := chr(55)||chr(65)||chr(53)||chr(50)||chr(53)||chr(67)||chr(53)||chr(55);
    v_str_4 := chr(54)||chr(49)||chr(48)||chr(48)||chr(49)||chr(52)||chr(54)||chr(56);
    v_str_5 := chr(32)||chr(77)||chr(65)||chr(83)||chr(32)||chr(54)||chr(46)||chr(48);
    v_str_6 := chr(72)||chr(97)||chr(110)||chr(100)||chr(32)||chr(69)||chr(82)||chr(80);
    v_raw_1 := v_str_3||v_str_4||v_str_2||v_str_1;
    v_str_7 := v_str_6||v_str_5;
    select rawtohex(v_str_7)
    into v_raw_2
    from dual;
    v_str_8 := hex_to_string(utl_raw.bit_xor(v_raw_1,v_raw_2));
    return v_str_8;
  end;
  
  function des_encrypt(input_data IN VARCHAR2) return VARCHAR2 is
    crypt_key         VARCHAR2(16);
    encrypted_data    VARCHAR2(2000);
    hex_data        VARCHAR2(2000);
  begin
    crypt_key := get_key;
    hex_data := string_to_hex(input_data);
    sys.dbms_obfuscation_toolkit.desencrypt(input => hex_data
                                           ,key => crypt_key
                                           ,encrypted_data => encrypted_data);
    
    RETURN encrypted_data;
  END des_encrypt;

  
  
  function des_decrypt(input_data IN VARCHAR2) return VARCHAR2 is
    crypt_key       VARCHAR2(16);
    decrypted_string  VARCHAR2(2000);
    decrypted_hex     VARCHAR2(2000);
  begin
    crypt_key := get_key;
    sys.dbms_obfuscation_toolkit.desdecrypt(input => input_data
                                           ,key => crypt_key
                                           ,decrypted_data => decrypted_hex);
    decrypted_string := ltrim(rtrim(hex_to_string(decrypted_hex)));
    RETURN decrypted_string;
    END des_decrypt;
    
    function md5 (input_data in varchar2) return varchar2 is
    v_raw                   varchar2(2000);
    v_crypt_data        varchar2(500);
    begin  
      select rawtohex(input_data)
      into v_raw
      from dual;
      dbms_obfuscation_toolkit.MD5(input => v_raw,checksum => v_crypt_data);
      return v_crypt_data;
    end md5;
    
    FUNCTION string_to_hex(input_string IN VARCHAR2) RETURN VARCHAR2
    IS
      hex_string    VARCHAR2(2000);
      hex_len       NUMBER;
      str_len       NUMBER;
      remain        NUMBER;
      multiple      NUMBER;
      input_str      VARCHAR2(2000);
    BEGIN
      str_len := lengthb(input_string);
      input_str := input_string;
      IF str_len > 0 THEN
         SELECT rawtohex(input_str)
         INTO hex_string
         FROM dual;
         
      ELSE
          RETURN 'ERROR';
      END IF;
      hex_len := lengthb(hex_string);
      remain := MOD (hex_len,16);
      multiple := floor(hex_len / 16 )+ 1;
      IF remain != 0 THEN
          hex_string := rpad(hex_string,multiple * 16,'0');
      END IF;
    RETURN hex_string;
    END string_to_hex; 
    
    
    FUNCTION hex_to_string(input_string IN VARCHAR2) RETURN VARCHAR2
    IS
       string_str     VARCHAR2(2000);
       input_str      VARCHAR2(2000);
    BEGIN
       input_str := input_string;
       
       string_str :=hex_to_raw(input_str);
       RETURN string_str;
    END hex_to_string;
    
    
    function hex_to_raw(inhex varchar2) return varchar2 IS

        inhex_work varchar2(2000);
        hex1 varchar2(2000);
        hex2 varchar2(2000);
        decimal_number number;
        ascii_char varchar2(2000);
        return_string varchar2(2000);
    begin
        inhex_work := rtrim(ltrim(inhex));
        if length(inhex_work) is null then
                return NULL;
        end if;

        hex1 := substr(inhex_work,1,1);
        hex2 := substr(inhex_work,2,1);
        loop
                if instr(hex1,'A') = 1 Then
                        hex1 := '10';
                elsif instr(hex1, 'B') = 1 Then
                        hex1 := '11';
                elsif instr(hex1, 'C') = 1 Then
                        hex1 := '12';
                elsif instr(hex1, 'D') = 1 Then
                        hex1 := '13';
                elsif instr(hex1, 'E') = 1 Then
                        hex1 := '14';
                elsif instr(hex1, 'F') = 1 Then
                        hex1 := '15';
                end if;
                if instr(hex2, 'A') = 1 Then
                        hex2 := '10';
                elsif instr(hex2, 'B') = 1 Then
                        hex2 := '11';
                elsif instr(hex2, 'C') = 1 Then
                        hex2 := '12';
                elsif instr(hex2, 'D') = 1 Then
                        hex2 := '13';
                elsif instr(hex2, 'E') = 1 Then
                        hex2 := '14';
                elsif instr(hex2, 'F') = 1 Then
                        hex2 := '15';
                end if;

                decimal_number := to_number(hex1) * 16 + to_number(hex2);
                ascii_char := chr(decimal_number);
                return_string :=  concat(return_string, ascii_char);

                inhex_work := substr(inhex_work, 3);
                if inhex_work is null then
                        return return_string;
                        exit;
                end if;
                hex1 := substr(inhex_work,1,1);
                hex2 := substr(inhex_work,2,1);

        end loop;
    end;
    
  end SYS_CRYPT;
/

spool off

exit
