WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool sys_function_pkg.log

CREATE OR REPLACE PACKAGE "SYS_FUNCTION_PKG" is

  
  -- Author  : Bobo
  -- Created : 2009-3-30 15:22:07
  -- Purpose :

  function get_function_id return number;

  --web 
  procedure insert_sys_function(p_function_code      varchar2,
                                p_function_name      varchar2,
                                p_parent_function_id number,
                                p_icon_path          varchar2,
                                p_function_type      varchar2,
                                p_sequence           number,
                                p_command_line       varchar2,
                                p_created_by         number default 1,
                                p_last_updated_by    number default 1,
                                p_function_id        out number);
  --web 
  procedure update_sys_function(p_function_id     number,
                                p_module_code     varchar2,
                                p_type            varchar2,
                                p_command_line    varchar2,
                                p_parameters      varchar2,
                                p_small_image     varchar2,
                                p_large_image     varchar2,
                                p_config_section  varchar2,
                                p_description     varchar2,
                                p_function_code_1 varchar2 default null,
                                p_last_updated_by number default 1);

  --web 
  procedure delete_sys_function(p_function_id number);

  --functiion 
  procedure sys_function_load(p_function_code varchar2,
                              p_function_name varchar2,
                              p_parent_code   varchar2,
                              p_type          varchar2,
                              p_service_name  varchar2,
                              p_squence       varchar2,
                              p_icon_path     varchar2,
                              p_language_code varchar2);

  --빦ܶ
  procedure sys_function_desc_load(p_function_code varchar2,
                                   p_description   varchar2,
                                   p_language_code varchar2);


end sys_function_pkg;
/
CREATE OR REPLACE PACKAGE BODY "SYS_FUNCTION_PKG" is

  function get_function_id return number is
    v_function_id sys_function.function_id%type;
  begin
    select sys_function_s.nextval into v_function_id from dual;
    return v_function_id;
  end get_function_id;

  --web 
  procedure insert_sys_function(p_function_code      varchar2,
                                p_function_name      varchar2,
                                p_parent_function_id number,
                                p_icon_path          varchar2,
                                p_function_type      varchar2,
                                p_sequence           number,
                                p_command_line       varchar2,
                                p_created_by         number default 1,
                                p_last_updated_by    number default 1,
                                p_function_id        out number) is

    v_function_id      sys_function.function_id%type;
    v_function_name_id sys_function.description_id%type;
    --v_module_id      sys_function.module_id%type;
    e_module_code_error exception;
  begin
    --step 1 insert into sys_function

    /* begin
      select t.module_id
        into v_module_id
        from sys_module t
       where t.module_code = upper(p_module_code);
    exception
      when no_data_found then
        raise e_module_code_error;
    end;*/

    v_function_id      := get_function_id;
    p_function_id      := v_function_id;
    v_function_name_id := fnd_description_pkg.get_fnd_description_id;
    insert into sys_function
      (function_id,
       function_code,
       function_name_id,
       function_type,
       parent_function_id,
       --module_id,
       icon,
       sequence,
       service_id,
       creation_date,
       created_by,
       last_update_date,
       last_updated_by)
    values
      (v_function_id,
       upper(p_function_code),
       v_function_name_id,
       p_function_type,
       p_parent_function_id,
       p_icon_path,
       p_command_line,
       p_sequence,
       sysdate,
       p_created_by,
       sysdate,
       p_last_updated_by);

    --step 2 insert description
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_function_name_id,
                                               p_ref_table        => 'SYS_FUNCTION',
                                               p_ref_field        => 'DESCRIPTION_ID',
                                               p_description_text => p_function_name,
                                               p_function_name    => '',
                                               p_created_by       => p_created_by,
                                               p_last_updated_by  => p_last_updated_by,
                                               p_language_code    => userenv('lang'));

  exception
    when e_module_code_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_FUNCTION_MODULE_CODE_ERROR',
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'sys_function_pkg',
                                                      p_procedure_function_name => 'insert_sys_function');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when dup_val_on_index then
      --insert  Ψһ
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_FUNCTION_UNIQUE_ERROR',
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'sys_function_pkg',
                                                      p_procedure_function_name => 'insert_sys_function');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_last_updated_by,
                                                     p_package_name            => 'sys_function_pkg',
                                                     p_procedure_function_name => 'insert_sys_function');

      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

  end insert_sys_function;

  procedure update_sys_function(p_function_id     number,
                                p_module_code     varchar2,
                                p_type            varchar2,
                                p_command_line    varchar2,
                                p_parameters      varchar2,
                                p_small_image     varchar2,
                                p_large_image     varchar2,
                                p_config_section  varchar2,
                                p_description     varchar2,
                                p_function_code_1 varchar2 default null,
                                p_last_updated_by number default 1) is
    v_description_id sys_function.description_id%type;
    v_module_id      sys_function.module_id%type;

    e_module_code_error exception;
  begin
    select s.description_id
      into v_description_id
      from sys_function s
     where s.function_id = p_function_id;

    begin
      select t.module_id
        into v_module_id
        from sys_module t
       where t.module_code = upper(p_module_code);
    exception
      when no_data_found then
        raise e_module_code_error;
    end;

    --Ϣ
    update sys_function f
       set module_id        = v_module_id,
           function_type    = p_type,
           last_update_date = sysdate,
           last_updated_by  = p_last_updated_by
     where f.function_id = p_function_id;

    --
    if v_description_id is null then
      v_description_id := fnd_description_pkg.get_fnd_description_id;

      update sys_function f
         set description_id   = v_description_id,
             last_update_date = sysdate,
             last_updated_by  = p_last_updated_by
       where f.function_id = p_function_id;
    end if;

    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                               p_ref_table        => 'SYS_FUNCTION',
                                               p_ref_field        => 'DESCRIPTION_ID',
                                               p_description_text => p_description,
                                               p_function_name    => p_function_code_1,
                                               p_created_by       => p_last_updated_by,
                                               p_last_updated_by  => p_last_updated_by,
                                               p_language_code    => userenv('lang'));

  exception
    when e_module_code_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_FUNCTION_MODULE_CODE_ERROR',
                                                      p_created_by              => p_last_updated_by,
                                                      p_package_name            => 'sys_function_pkg',
                                                      p_procedure_function_name => 'update_sys_function');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_last_updated_by,
                                                     p_package_name            => 'sys_function_pkg',
                                                     p_procedure_function_name => 'update_sys_function');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end update_sys_function;

  --web 
  procedure delete_sys_function(p_function_id number) is
    v_description_id sys_function.description_id%type;
  begin
    select s.description_id
      into v_description_id
      from sys_function s
     where s.function_id = p_function_id;

    --ɾ
    fnd_description_pkg.delete_fnd_descriptions(p_description_id => v_description_id);

    --ɾ¼
    delete from sys_function where function_id = p_function_id;

    /*--ɾ¼
    delete from sys_function_group_item where function_id = p_function_id;*/
  exception
    when no_data_found then
      null;
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => -1,
                                                     p_package_name            => 'sys_function_pkg',
                                                     p_procedure_function_name => 'delete_sys_function');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

  end delete_sys_function;

  --functiion 
  procedure sys_function_load(p_function_code varchar2,
                              p_function_name varchar2,
                              p_parent_code   varchar2,
                              p_type          varchar2,
                              p_service_name  varchar2,
                              p_squence       varchar2,
                              p_icon_path     varchar2,
                              p_language_code varchar2) is

    v_function_id    sys_function.function_id%type;
    v_description_id sys_function.description_id%type;
    v_module_id      sys_function.module_id%type;
    v_parent_id      sys_function.parent_function_id%type;
    v_service_id     sys_function.service_id%type;
    e_module_code_error exception;
    e_function_code_error exception;
    e_service_code_error exception;
  begin

    begin
      select function_name_id, function_id
        into v_description_id, v_function_id
        from sys_function
       where function_code = upper(p_function_code);

      --
      if v_description_id is null then
        v_description_id := fnd_description_pkg.get_fnd_description_id;

        update sys_function f
           set function_name_id   = v_description_id,
               last_update_date = sysdate,
               last_updated_by  = 1
         where f.function_id = v_function_id;
      end if;

      fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                                 p_ref_table        => 'SYS_FUNCTION',
                                                 p_ref_field        => 'FUNCTION_NAME_ID',
                                                 p_description_text => p_function_name,
                                                 p_function_name    => '',
                                                 p_created_by       => 1,
                                                 p_last_updated_by  => 1,
                                                 p_language_code    => p_language_code);

    exception
      when no_data_found then
        --
        v_function_id    := get_function_id;
        v_description_id := fnd_description_pkg.get_fnd_description_id;

        if (p_parent_code = '' or p_parent_code is null) then
          v_parent_id := null;
        else
          begin
            select sf.function_id
              into v_parent_id from sys_function sf
             where sf.function_code = p_parent_code;
          exception
            when no_data_found then
              raise e_function_code_error;
          end;
        end if;
        if (p_service_name = '' or p_service_name is null) then
          v_service_id := null;
        else
          begin
            select ss.service_id
              into v_service_id
              from sys_service ss
             where ss.service_name = p_service_name;
          exception
            when no_data_found then
              null;
              --raise e_service_code_error; --Modify By Alan Lee 2011-07-21
          end;
        end if;
        insert into sys_function
          (function_id,
           function_code,
           function_name_id,
           function_type,
           parent_function_id,
           module_id,
           description_id,
           icon,
           sequence,
           creation_date,
           created_by,
           last_update_date,
           last_updated_by,
           service_id)
        values
          (v_function_id,
           upper(p_function_code),
           v_description_id,
           p_type,
           v_parent_id,
           null,
           null,
           p_icon_path,
           p_squence,
           sysdate,
           1,
           sysdate,
           1,
           v_service_id);

        --step 2 insert description

        fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                                   p_ref_table        => 'SYS_FUNCTION',
                                                   p_ref_field        => 'FUNCTION_NAME_ID',
                                                   p_description_text => p_function_name,
                                                   p_function_name    => '',
                                                   p_created_by       => 1,
                                                   p_last_updated_by  => 1,
                                                   p_language_code    => p_language_code);

    end;

  exception
    when e_module_code_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_FUNCTION_MODULE_CODE_ERROR',
                                                      p_created_by              => 1,
                                                      p_package_name            => 'sys_function_pkg',
                                                      p_procedure_function_name => 'insert_sys_function');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_function_code_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_FUNCTION_CODE_ERROR',
                                                      p_created_by              => 1,
                                                      p_package_name            => 'sys_function_pkg',
                                                      p_procedure_function_name => 'insert_sys_function');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_service_code_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_SERVICE_CODE_ERROR',
                                                      p_created_by              => 1,
                                                      p_package_name            => 'sys_function_pkg',
                                                      p_procedure_function_name => 'insert_sys_function');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => 1,
                                                     p_package_name            => 'sys_function_pkg',
                                                     p_procedure_function_name => 'insert_sys_function');

      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

  end sys_function_load;

  procedure sys_function_desc_load(p_function_code varchar2,
                                   p_description   varchar2,
                                   p_language_code varchar2) is
    v_function_id    number;
    v_description_id number;
  begin
    select function_id, function_name_id
      into v_function_id, v_description_id
      from sys_function
     where function_code = p_function_code;

    if v_description_id is null then
      v_description_id := fnd_description_pkg.get_fnd_description_id;
    end if;

    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                               p_ref_table        => 'SYS_FUNCTION',
                                               p_ref_field        => 'FUNCTION_NAME_ID',
                                               p_description_text => p_description,
                                               p_function_name    => '',
                                               p_created_by       => 1,
                                               p_last_updated_by  => 1,
                                               p_language_code    => p_language_code);

  exception
    when no_data_found then
      null;
  end;

end sys_function_pkg;
/


spool off

exit
