WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool sys_function_service_pkg.log

create or replace package sys_function_service_pkg is
  procedure load_service(p_main_service_name VARCHAR2,
                         p_service_name      VARCHAR2);
end sys_function_service_pkg;
/
create or replace package body sys_function_service_pkg is
  procedure load_service(p_main_service_name VARCHAR2,
                         p_service_name      VARCHAR2) is
    v_main_service_id  number;
    v_service_id       number;
    v_function_id      number;
    v_repeat           number;
    v_function_service sys_function_service%rowtype;
  
    e_non_main_service_id exception;
    e_non_service_id exception;
    e_non_function_id exception;
    e_more_function_id exception;
    e_repeat_insert exception;
  begin
    select count(*)
      into v_main_service_id
      from sys_service nss
     where nss.service_name = p_main_service_name;
    if (v_main_service_id = 0) then
      raise e_non_main_service_id;
    end if;
    select nss.service_id
      into v_main_service_id
      from sys_service nss
     where nss.service_name = p_main_service_name;
  
    select count(*)
      into v_function_id
      from sys_function nsf
     where nsf.service_id = v_main_service_id;
    if v_function_id = 0 then
      raise e_non_function_id;
    
    end if;
    if (v_function_id > 1) then
      raise e_more_function_id;
    end if;
  
    select nsf.function_id
      into v_function_id
      from sys_function nsf
     where nsf.service_id = v_main_service_id;
  
    select count(*)
      into v_service_id
      from sys_service nss
     where nss.service_name = p_service_name;
    if (v_service_id = 0) then
      raise e_non_service_id;
    end if;
    select nss.service_id
      into v_service_id
      from sys_service nss
     where nss.service_name = p_service_name;
  
    select count(*)
      into v_repeat
      from sys_function_service nsfs
     where nsfs.function_id = v_function_id
       and nsfs.service_id = v_service_id;
    if v_repeat != 0 then
      raise e_repeat_insert;
    end if;
    v_function_service.function_id      := v_function_id;
    v_function_service.service_id       := v_service_id;
    v_function_service.created_by       := 1;
    v_function_service.creation_date    := sysdate;
    v_function_service.last_updated_by  := 1;
    v_function_service.last_update_date := sysdate;
    insert into sys_function_service values v_function_service;
  
  exception
    when e_non_main_service_id then
      null;
    when e_non_function_id then
      null;
    when e_more_function_id then
      null;
    when e_non_service_id then
      null;
    when e_repeat_insert then
      null;
    when others then
      null;
  end;
end sys_function_service_pkg;
/
spool off

exit