WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool sys_login_pkg.log
create or replace package sys_login_pkg is

  -- Author  : xiaoguojun
  -- Created : 2009-3-30 09:33:59
  -- Purpose : ϵͳ¼

  --SSO½ Alan Lee 2010-06-17

  --***********************************************************/*
  --  쳣
  --        e_password_null      Ϊ
  --        e_password_failure   
  --        e_user_faulure       ûʧЧ
  --        e_user_null          û
  --        e_frozen_failure     ûѱ
  --        e_password_expired   뵽Ҫ趨
  --        e_first_login_change_password ״ε½޸
  --***********************************************************/*
  e_user_failure exception;
  e_user_null exception;
  e_password_null exception;
  e_password_failure exception;
  e_frozen_failure exception;
  e_password_expired exception;
  e_password_rule_check_invalid exception;
  e_language_null exception;
  e_role_null exception;
  e_first_login_change_password exception;
  /********************** û¼
         ֶ֧Ե¼
         ͨ¼ҳͨXMLԴãʵֶԵ¼档
         û¼ĺϷУ
         ûĺϷ
         ûʱЧ
         û״̬
         ĺϷ
         ¼
         ¼ʱ
         ޸ĵҪУ
         ¼־
         ¼¼û־Ϣ
         ¼Ự
         ¼¼롢ûɫ֯¼ʱ䡢ǳʱ䡢Ự
         ¼¼IPͻIP
         ¼ϸ
         ¼¼ܡ͡ʼʱ䡢ʱ
         ȫֲ
         ݹȡϵͳSESSION

         ֵΪܵSESSION_ID
  ******************************/
  function md5(p_password in varchar2) return varchar2;

  procedure login(p_user_name           in varchar2,
                  p_password            in varchar2,
                  p_language            in varchar2,
                  p_ip                  in varchar2,
                  p_session_id          out number,
                  p_encryted_session_id out varchar2,
                  p_error_message       out varchar2);

  --************************************************************
  -- SSOû¼
  -- parameter :
  --             p_encrypted_sso_session_id SSO¼ܵSESSION_ID
  --             p_error_message ¼ʱ淵صϢ
  -- exception :
  --             e_password_null     Ϊ
  --             e_password_failure  
  --             e_user_null         û
  --             e_user_faulure      ûʧЧ
  --             e_language_null     Բ
  --             e_role_null exception δɫ
  --************************************************************
  procedure sso_login(p_encrypted_sso_session_id in varchar2,
                      p_session_id               out number,
                      p_encrypted_session_id     out varchar2,
                      p_error_message            out varchar2);
                   


  /********************* ɫѡ
          ѡҵɫ
          ûЧɫ֯ȨϢṩҵɫ֯бѡ
          ֻѡһɫ֯Ͻҵ
          ѡһɫ֯ϲܽҵ
          ȫֲ
          ɫ֯Ϊȫֲ
  ********************************/
  procedure role_select(p_encryted_session_id varchar2,
                        p_role_id             number,
                        p_company_id          number,
                        p_app_ip_address      varchar2,
                        p_client_ip_address   varchar2,
                        p_description         varchar2 default null);
                        
  --************************************************************
  -- ADû¼
  -- parameter :
  --            p_user_name            in varchar2, û
  --            p_role_code            in varchar2, ɫcode 
  --            p_ip                   in varchar2,ͻIP
  --            p_session_id           out number,session_id
  --            p_user_id              out number,user_id
  --            p_role_id              out number,role_id
  --            p_company_id           out number,  company_id                   
  --            p_encrypted_session_id out varchar2,ؼsession_id
  --************************************************************
  procedure ad_login(p_user_name                in varchar2,
                     p_ip                       in varchar2,
                     p_session_id               out number,
                     p_user_id                  out number,
                     p_role_id                  out number,
                     p_company_id               out number,
                     p_lang                     out varchar2,
                     p_old_encrypted_session_id in varchar2,
                     p_encrypted_session_id     out varchar2);
                        
  /********************* 
          ṩҵ
          ֧ҵԽ
          ûû¼ѡĽɫ֯Ϣṩ˵͹
          ˵չܲ˵ϸ
          ܲ˵Դ򿪶ӦӦó
          Ӧóҵִ
  *********************************/

  /*******************  ܲ˵
          ṩҵ
          ֧ҵԽ
          ûû¼ѡĽɫ֯Ϣṩ˵͹
          ˵չܲ˵ϸ
          ܲ˵Դ򿪶ӦӦó
          Ӧóҵִ
  *********************************/

  procedure logout(p_session_id number);

end sys_login_pkg;
/
create or replace package body sys_login_pkg is

  --************************************************************
  --MD5ת
  -- parameter :
  -- p_password  ԭ
  -- return    :
  -- md5
  --************************************************************

  function md5(p_password in varchar2) return varchar2 is
    retval varchar2(32);
  begin
    retval := utl_raw.cast_to_raw(dbms_obfuscation_toolkit.md5(input_string => p_password));
    return retval;
  end md5;
  --************************************************************
  -- УûЧ
  -- parameter :
  -- p_user_name ¼û
  -- exception :
  -- e_user_null     ûʧЧ
  --************************************************************
  procedure validate_user(p_sys_user sys_user%rowtype) is
  begin
    if trunc(p_sys_user.start_date) > trunc(sysdate) then
      raise e_user_failure;
    end if;
    if p_sys_user.end_date is not null and
       trunc(p_sys_user.end_date) < trunc(sysdate) then
      raise e_user_failure;
    end if;
  end validate_user;

  --УɫЧ
  procedure validate_role(p_sys_user sys_user%rowtype) is
    v_exists  number;
    v_sysdate date := trunc(sysdate);
    v_count   number;
  begin

    --жǷѾڹ˾
    select count(1) into v_count from fnd_companies a;

    if v_count > 0 then
      --Ѿڹ˾һҪ乫˾
      select 1
        into v_exists
        from dual
       where exists
       (select *
                from sys_user_role_groups g
               where g.user_id = p_sys_user.user_id
                 and g.start_date <= v_sysdate
                 and (g.end_date >= v_sysdate or g.end_date is null));
    end if;

  exception
    when no_data_found then
      raise e_role_null;
  end validate_role;

  --************************************************************
  -- УûǷ񱻶
  --************************************************************

  procedure validate_frozen_flag(p_sys_user sys_user%rowtype) is
  begin
    if p_sys_user.frozen_flag = 'Y' then
      raise e_frozen_failure;
    end if;
  end validate_frozen_flag;

  --************************************************************
  -- УЧ
  -- parameter :
  --             p_user_name ¼û
  --             p_password  
  -- exception :
  --             e_password_null     Ϊ
  --             e_password_failure  
  --************************************************************
  procedure validate_password(p_sys_user sys_user%rowtype,
                              p_password varchar2) is
  begin
    if p_password is null then
      raise e_password_null;
    end if;

    if p_sys_user.encrypted_user_password <> md5(p_password) then
      raise e_password_failure;
    end if;

    --У
    sys_user_pkg.password_rule_check(p_password);

  exception
    when sys_user_pkg.e_password_complex_control then
      raise e_password_rule_check_invalid;
    when sys_user_pkg.e_password_min_length then
      raise e_password_rule_check_invalid;

  end validate_password;

  --************************************************************
  -- УǷ
  -- parameter :
  --             p_user_name ¼û
  -- exception :
  --             e_password_expired     뵽
  --************************************************************
  procedure expired_password(p_sys_user sys_user%rowtype) is
    v_login_time                number;
    v_pwd_changed_date          date;
    v_validate_date             number;
    v_user_password_useful_life number;
  begin

    --жЧڣЧڣ򵯳޸Ľ棬ǿ޸룡
    v_user_password_useful_life := nvl(sys_parameter_pkg.value('USER_PASSWORD_USEFUL_LIFE'),
                                       0);
    if v_user_password_useful_life > 0 then
      --ЧжЧ
      select (to_date(to_char(p_sys_user.password_start_date, 'YYYYMMDD'),
                      'YYYYMMDD') + v_user_password_useful_life) -
             to_date(to_char(sysdate, 'YYYYMMDD'), 'YYYYMMDD')
        into v_validate_date
        from dual;
      if v_validate_date <= 0 then
        raise e_password_expired;
      end if;
    end if;

    if p_sys_user.password_lifespan_days is not null or
       p_sys_user.password_lifespan_access is not null then
      begin
        select max(trunc(supcl.creation_date))
          into v_pwd_changed_date
          from sys_user_pwd_changed_logs supcl
         where supcl.changed_user_id = p_sys_user.user_id;
      exception
        when others then
          v_pwd_changed_date := null;
      end;
      if v_pwd_changed_date is null then
        v_pwd_changed_date := trunc(p_sys_user.creation_date);
      end if;
    end if;
    --
    if p_sys_user.password_lifespan_days is not null then
      if p_sys_user.password_lifespan_days <
         (trunc(sysdate) - v_pwd_changed_date) then
        raise e_password_expired;
      end if;
    end if;
    --
    if p_sys_user.password_lifespan_access is not null then
      select count(sul.login_time)
        into v_login_time
        from sys_user_logins sul
       where sul.user_id = p_sys_user.user_id
         and trunc(sul.login_time) > v_pwd_changed_date;
      if p_sys_user.password_lifespan_access <= v_login_time then
        raise e_password_expired;
      end if;
    end if;

  end expired_password;

  --************************************************************
  -- У״ε½޸
  -- parameter :
  --             p_user_name ¼û
  -- exception :
  --             e_first_login_change_password     ״ε½޸
  --************************************************************
  procedure first_login_change_password(p_sys_user sys_user%rowtype) is
    v_pwd_changed_times           number;
    v_first_login_change_password varchar2(1);
  begin

    --жǷ״ε½޸룬û޸Ĺ룬򵯳޸Ľ棬ǿ޸룡
    v_first_login_change_password := nvl(sys_parameter_pkg.value('FIRST_LOGIN_CHANGE_PASSWORD'),
                                         'N');
    if v_first_login_change_password = 'Y' then
      --״ε½޸룬жЧ
      select count(1)
        into v_pwd_changed_times
        from sys_user_pwd_changed_logs supcl
       where supcl.changed_user_id = p_sys_user.user_id;
      if v_pwd_changed_times < 1 then
        raise e_first_login_change_password;
      end if;
    end if;

  end first_login_change_password;

  function get_user_login_id return number is
    result number;
  begin
    select sys_user_logins_s.nextval into result from dual;
    return result;
  end get_user_login_id;

  --************************************************************
  -- ¼־
  --************************************************************
  procedure create_login(p_sys_user_id         number,
                         p_role_id             number,
                         p_company_id          number,
                         p_session_id          number,
                         p_encryted_session_id varchar2,
                         p_client_ip_address   varchar2,
                         p_app_ip_address      varchar2,
                         p_description         varchar2) is
    v_user_login_id number;
  begin

    v_user_login_id := get_user_login_id;

    insert into sys_user_logins
      (login_id,
       user_id,
       role_id,
       company_id,
       session_id,
       encrypted_session_id,
       nls_language,
       machine_serial,
       client_ip_address,
       app_ip_address,
       login_time,
       logout_time,
       last_active_time,
       description,
       last_update_date,
       last_updated_by,
       creation_date,
       created_by)
    values
      (v_user_login_id,
       p_sys_user_id,
       p_role_id,
       p_company_id,
       p_session_id,
       p_encryted_session_id,
       userenv('lang'),
       'UNDIFINE',
       p_client_ip_address,
       p_app_ip_address,
       sysdate,
       null,
       sysdate,
       p_description,
       sysdate,
       p_sys_user_id,
       sysdate,
       p_sys_user_id);

  end create_login;

  --************************************************************
  -- ǳ־
  --************************************************************
  procedure logout(p_session_id number) is
  begin

    update sys_user_logins
       set logout_time = sysdate
     where session_id = p_session_id;

    delete from sys_session where session_id = p_session_id;

  end logout;

  --************************************************************
  -- ϸ־
  --************************************************************
  procedure create_login_details(p_sys_user_id   number,
                                 p_user_login_id number,
                                 p_function_id   number,
                                 p_action_code   varchar2,
                                 p_description   varchar2) is
    v_detail_line_id number;
  begin
    select sys_user_login_details_s.nextval
      into v_detail_line_id
      from dual;
    insert into sys_user_login_details
      (detail_line_id,
       login_id,
       function_id,
       action_code,
       in_time,
       out_time,
       description,
       last_update_date,
       last_updated_by,
       creation_date,
       created_by)
    values
      (v_detail_line_id,
       p_user_login_id,
       p_function_id,
       p_action_code,
       sysdate,
       null,
       p_description,
       sysdate,
       p_sys_user_id,
       sysdate,
       p_sys_user_id);

  end create_login_details;

  --************************************************************
  -- ϸǳ־
  --************************************************************
  procedure create_logout_details(p_detail_line_id number) is
  begin

    update sys_user_login_details
       set out_time = sysdate
     where detail_line_id = p_detail_line_id;

  end create_logout_details;

  --************************************************************
  -- ¼ɹ󣬸µ¼Ϣ
  -- parameter :
  --             p_user_name ¼û
  --************************************************************
  function post_login(p_user_name varchar2,
                      p_password  varchar2,
                      p_ip        varchar2) return varchar2 is
    v_encryted_session_id varchar2(100);
  begin
    --
    update sys_user
       set last_logon_date = sysdate, last_update_date = sysdate
     where user_name = p_user_name;

    --session
    v_encryted_session_id := sys_session_pkg.create_session(p_user_name => p_user_name,
                                                            p_password  => p_password,
                                                            p_ip        => p_ip);
    return v_encryted_session_id;
  end post_login;

  --************************************************************
  -- SSO¼ɹ󣬸µ¼Ϣ
  -- parameter :
  --             p_user_name ¼û
  --************************************************************
  function post_sso_login(p_user_name          varchar2,
                          p_encrypted_password varchar2,
                          p_ip                 varchar2) return varchar2 is
    v_encryted_session_id varchar2(100);
  begin
    --
    update sys_user
       set last_logon_date = sysdate, last_update_date = sysdate
     where user_name = p_user_name;

    --session
    v_encryted_session_id := sys_session_pkg.create_session(p_user_name          => p_user_name,
                                                                p_password => p_encrypted_password,
                                                                p_ip                 => p_ip);
    return v_encryted_session_id;
  end post_sso_login;

  --************************************************************
  -- û¼
  -- parameter :
  --             p_user_name ¼û
  --             p_password  
  --             p_language  ԣ'ZHS','US')
  --             p_error_message ¼ʱ淵صϢ
  -- exception :
  --             e_password_null     Ϊ
  --             e_password_failure  
  --             e_user_null         û
  --             e_user_faulure      ûʧЧ
  --             e_language_null     Բ
  --             e_role_null exception δɫ
  --************************************************************
  procedure login(p_user_name           in varchar2,
                  p_password            in varchar2,
                  p_language            in varchar2,
                  p_ip                  in varchar2,
                  p_session_id          out number,
                  p_encryted_session_id out varchar2,
                  p_error_message       out varchar2) is
    r_sys_user            sys_user%rowtype;
    v_encryted_session_id varchar2(100);
    v_language            varchar2(100);
    v_sql                 varchar2(20000);
  begin

    begin
      select *
        into r_sys_user
        from sys_user
       where user_name = upper(p_user_name);
    exception
      when no_data_found then
        raise e_user_null;
    end;
    begin
      select t.nls_language
        into v_language
        from sys_languages t, fnd_language_code f
       where t.language_code = f.language_code
         and t.language_code = p_language
         and f.installed_flag = 'Y';
    exception
      when no_data_found then
        raise e_language_null;
    end;

    v_sql := 'alter session set nls_language =' || chr(39) || v_language ||
             chr(39);
    execute immediate v_sql;

    --УûЧ
    validate_user(p_sys_user => r_sys_user);

    --УɫЧ
    validate_role(p_sys_user => r_sys_user);

    --УûǷ񱻶
    validate_frozen_flag(p_sys_user => r_sys_user);

    --УЧ
    validate_password(p_sys_user => r_sys_user, p_password => p_password);

    --УǷ
    expired_password(p_sys_user => r_sys_user);

    --У״ε½޸
    first_login_change_password(p_sys_user => r_sys_user);

    v_encryted_session_id := post_login(p_user_name => upper(p_user_name),
                                        p_password  => p_password,
                                        p_ip        => p_ip);

    p_encryted_session_id := v_encryted_session_id;
    if p_encryted_session_id is not null then
      p_session_id := sys_session_pkg.get_session_id(p_encryted_session_id);
    end if;
    p_error_message := ' ';
    --return v_encryted_session_id;
  exception
    when e_role_null then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_ROLE_NULL', --ԶĴϢ
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'LOGIN');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_language_null then
      --Զ쳣
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_LANGUAGE_NULL', --ԶĴϢ
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'LOGIN');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

    when e_password_failure then
      --Զ쳣
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PASSWORD_FAILURE', --ԶĴϢ
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'LOGIN');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

    when e_password_null then

      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PASSWORD_NULL', --ԶĴϢ
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'LOGIN');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

    when e_user_failure then

      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_FAILURE', --ԶĴϢ
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'LOGIN');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_user_null then

      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_NULL', --ԶĴϢ
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'LOGIN');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_frozen_failure then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_FROZEN_FAILURE', --ԶĴϢ
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'LOGIN');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

    when e_password_expired then
      p_session_id          := -1; --Ѿڣ޸
      p_encryted_session_id := 'ERROR';
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_PASSWORD_EXPIRED',
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'LOGIN');

      sys_raise_app_error_pkg.get_sys_raise_app_error(p_app_error_line_id => sys_raise_app_error_pkg.g_err_line_id,
                                                      p_message           => p_error_message);

    when e_first_login_change_password then
      p_session_id          := -1; --״ε½޸룬޸
      p_encryted_session_id := 'ERROR';
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_FIRST_LOGIN_CHANGE_PASSWORD',
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'LOGIN');

      sys_raise_app_error_pkg.get_sys_raise_app_error(p_app_error_line_id => sys_raise_app_error_pkg.g_err_line_id,
                                                      p_message           => p_error_message);

    when e_password_rule_check_invalid then
      p_session_id          := -1; --벻ϵͳ趨壬޸
      p_encryted_session_id := 'ERROR';
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_PASSWORD_RULE_CHECK_INVALID',
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'LOGIN');

      sys_raise_app_error_pkg.get_sys_raise_app_error(p_app_error_line_id => sys_raise_app_error_pkg.g_err_line_id,
                                                      p_message           => p_error_message);

    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(sqlerrm,
                                                     p_created_by => 0,
                                                     p_package_name => 'SYS_login_PKG',
                                                     p_procedure_function_name => 'login');

      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

  end login;

  --************************************************************
  -- SSOû¼
  -- parameter :
  --             p_encrypted_sso_session_id SSO¼ܵSESSION_ID
  --             p_error_message ¼ʱ淵صϢ
  -- exception :
  --             e_password_null     Ϊ
  --             e_password_failure  
  --             e_user_null         û
  --             e_user_faulure      ûʧЧ
  --             e_language_null     Բ
  --             e_role_null exception δɫ
  --************************************************************
  procedure sso_login(p_encrypted_sso_session_id in varchar2,
                      p_session_id               out number,
                      p_encrypted_session_id     out varchar2,
                      p_error_message            out varchar2) is
    r_sys_user                sys_user%rowtype;
    v_encrypted_session_id    varchar2(100);
    v_language                varchar2(100);
    v_sql                     varchar2(20000);
    v_user_id                 number;
    v_role_id                 number;
    v_company_id              number;
    v_user_language           varchar2(4);
    v_client_ip_address       varchar2(30);
    v_user_name               varchar2(100);
    v_encrypted_user_password varchar2(100);
  begin

    begin
      select a.user_id,
             a.role_id,
             a.company_id,
             a.user_language,
             a.client_ip_address
        into v_user_id,
             v_role_id,
             v_company_id,
             v_user_language,
             v_client_ip_address
        from sys_sso_login_session a
       where a.encrypted_sso_session_id = p_encrypted_sso_session_id;
    exception
      when no_data_found then
        null;
    end;

    begin
      select user_name, encrypted_user_password
        into v_user_name, v_encrypted_user_password
        from sys_user
       where user_id = upper(v_user_id);
    exception
      when no_data_found then
        null;
    end;

    begin
      select *
        into r_sys_user
        from sys_user
       where user_name = upper(v_user_name);
    exception
      when no_data_found then
        raise e_user_null;
    end;
    begin
      select t.nls_language
        into v_language
        from sys_languages t, fnd_language_code f
       where t.language_code = f.language_code
         and t.language_code = v_user_language
         and f.installed_flag = 'Y';
    exception
      when no_data_found then
        raise e_language_null;
    end;

    v_sql := 'alter session set nls_language =' || chr(39) || v_language ||
             chr(39);
    execute immediate v_sql;

    --УûЧ
    validate_user(p_sys_user => r_sys_user);

    --УɫЧ
    validate_role(p_sys_user => r_sys_user);

    --УûǷ񱻶
    validate_frozen_flag(p_sys_user => r_sys_user);

    --УЧ
    --Ȳ
    /*validate_password(p_sys_user => r_sys_user,
    p_password => p_password);*/

    --УǷ
    expired_password(p_sys_user => r_sys_user);

    --У״ε½޸
    first_login_change_password(p_sys_user => r_sys_user);

    v_encrypted_session_id := post_sso_login(p_user_name          => upper(v_user_name),
                                             p_encrypted_password => v_encrypted_user_password,
                                             p_ip                 => v_client_ip_address);

    p_encrypted_session_id := v_encrypted_session_id;
    if p_encrypted_session_id is not null then
      p_session_id := sys_session_pkg.get_session_id(p_encrypted_session_id);
    end if;

    --ɫѡ
    role_select(p_encryted_session_id => p_encrypted_session_id,
                p_role_id             => v_role_id,
                p_company_id          => v_company_id,
                p_app_ip_address      => null,
                p_client_ip_address   => v_client_ip_address,
                p_description         => null);

    --ɾSSO½SESSION¼
    sys_sso_login_session_pkg.delete_sso_login_session(p_encrypted_sso_session_id => p_encrypted_sso_session_id);

    p_error_message := ' ';

  exception
    when e_role_null then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_ROLE_NULL', --ԶĴϢ
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'SSO_LOGIN');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_language_null then
      --Զ쳣
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_LANGUAGE_NULL', --ԶĴϢ
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'SSO_LOGIN');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

    when e_password_failure then
      --Զ쳣
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PASSWORD_FAILURE', --ԶĴϢ
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'SSO_LOGIN');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

    when e_password_null then

      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PASSWORD_NULL', --ԶĴϢ
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'SSO_LOGIN');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

    when e_user_failure then

      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_FAILURE', --ԶĴϢ
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'SSO_LOGIN');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_user_null then

      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_NULL', --ԶĴϢ
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'SSO_LOGIN');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_frozen_failure then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_FROZEN_FAILURE', --ԶĴϢ
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'SSO_LOGIN');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

    when e_password_expired then
      p_session_id           := -1; --Ѿڣ޸
      p_encrypted_session_id := 'ERROR';
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_PASSWORD_EXPIRED',
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'SSO_LOGIN');

      sys_raise_app_error_pkg.get_sys_raise_app_error(p_app_error_line_id => sys_raise_app_error_pkg.g_err_line_id,
                                                      p_message           => p_error_message);

    when e_first_login_change_password then
      p_session_id          := -1; --״ε½޸룬޸
      p_encrypted_session_id := 'ERROR';
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_FIRST_LOGIN_CHANGE_PASSWORD',
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'LOGIN');

      sys_raise_app_error_pkg.get_sys_raise_app_error(p_app_error_line_id => sys_raise_app_error_pkg.g_err_line_id,
                                                      p_message           => p_error_message);

    when e_password_rule_check_invalid then
      p_session_id           := -1; --벻ϵͳ趨壬޸
      p_encrypted_session_id := 'ERROR';
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_PASSWORD_RULE_CHECK_INVALID',
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'SSO_LOGIN');

      sys_raise_app_error_pkg.get_sys_raise_app_error(p_app_error_line_id => sys_raise_app_error_pkg.g_err_line_id,
                                                      p_message           => p_error_message);

    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(sqlerrm,
                                                     p_created_by => 0,
                                                     p_package_name => 'SYS_LOGIN_PKG',
                                                     p_procedure_function_name => 'SSO_LOGIN');

      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

  end sso_login;

  --************************************************************
  -- ɫѡ
  --************************************************************
  procedure role_select(p_encryted_session_id varchar2,
                        p_role_id             number,
                        p_company_id          number,
                        p_app_ip_address      varchar2,
                        p_client_ip_address   varchar2,
                        p_description         varchar2 default null) is
    v_session_id  number;
    v_sys_user_id number;
    v_count       number;
  begin

    if p_role_id is null or p_company_id is null then
      if p_role_id is not null then
        --жǷѾڹ˾
        select count(1) into v_count from fnd_companies a;

        if v_count > 0 then
          --Ѿڹ˾һҪ乫˾
          raise e_role_null;
        end if;

      else
        raise e_role_null;
      end if;
    end if;

    v_session_id := sys_session_pkg.get_session_id(p_encryted_session_id);

    -- SESSION Ϣ
    update sys_session t
       set t.role_id           = p_role_id,
           t.company_id        = p_company_id,
           t.app_ip_address    = p_app_ip_address,
           t.client_ip_address = p_client_ip_address
     where t.session_id = v_session_id;

    --¼־
    select t.user_id
      into v_sys_user_id
      from sys_session t
     where t.session_id = v_session_id;

    create_login(p_sys_user_id         => v_sys_user_id,
                 p_role_id             => p_role_id,
                 p_company_id          => p_company_id,
                 p_session_id          => v_session_id,
                 p_encryted_session_id => p_encryted_session_id,
                 p_client_ip_address   => p_client_ip_address,
                 p_app_ip_address      => p_app_ip_address,
                 p_description         => p_description);

  exception
    when e_role_null then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_ROLE_NULL', --ԶĴϢ
                                                      p_created_by              => 0,
                                                      p_package_name            => 'SYS_LOGIN_PKG',
                                                      p_procedure_function_name => 'role_select');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(sqlerrm,
                                                     p_created_by => 0,
                                                     p_package_name => 'SYS_LOGIN_PKG',
                                                     p_procedure_function_name => 'role_select');

      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

  end role_select;
  --׼ʵ
  procedure ad_login_standard(p_user_name                in varchar2,
                              p_ip                       in varchar2,
                              p_session_id               out number,
                              p_user_id                  out number,
                              p_role_id                  out number,
                              p_company_id               out number,
                              p_lang                     out varchar2,
                              p_old_encrypted_session_id in varchar2,
                              p_encrypted_session_id     out varchar2) is
    l_max_last_active_time date;
  begin
    --ȡuser_id
    begin
      p_user_id    := -1;
      p_role_id    := -1;
      p_company_id := -1;
      select user_id
        into p_user_id
        from sys_user
       where user_name = p_user_name
         and trunc(start_date) <= trunc(sysdate)
         and (trunc(end_date) >= trunc(sysdate) or end_date is null);
    
      --
      update sys_user
         set last_logon_date = sysdate, last_update_date = sysdate
       where user_id = p_user_id;
      --check session      
      begin
        select last_active_time
          into l_max_last_active_time
          from (select last_active_time
                  from sys_user_logins
                 where encrypted_session_id = p_old_encrypted_session_id
                 order by last_active_time desc)
         where rownum = 1;
      
        select role_id, company_id, nls_language, session_id
          into p_role_id, p_company_id, p_lang, p_session_id
          from sys_user_logins
         where encrypted_session_id = p_old_encrypted_session_id
           and last_active_time = l_max_last_active_time;
        p_encrypted_session_id := p_old_encrypted_session_id;
      exception
        when no_data_found then
          select sys_session_s.nextval into p_session_id from dual;
          p_encrypted_session_id := sys_crypt.des_encrypt(to_char(p_session_id));
          p_lang                 := userenv('lang');
      end;
      --create session
    
      insert into sys_session
        (session_id,
         encrypted_session_id,
         user_id,
         role_id,
         company_id,
         user_language,
         app_ip_address,
         client_ip_address,
         login_time,
         logout_time,
         last_active_time,
         note,
         last_update_date,
         last_updated_by,
         creation_date,
         created_by)
      values
        (p_session_id,
         p_encrypted_session_id,
         p_user_id,
         p_role_id,
         p_company_id,
         p_lang,
         null,
         p_ip,
         sysdate,
         null,
         sysdate,
         null,
         sysdate,
         p_user_id,
         sysdate,
         p_user_id);
    end;
    commit;
  end ad_login_standard;
  --************************************************************
  -- ADû¼
  -- parameter :
  --            p_user_name            in varchar2, û
  --            p_role_code            in varchar2, ɫcode
  --            p_company_code         in varchar2,˾code
  --            p_session_id           out number,session_id
  --            p_user_id              out number,user_id
  --            p_role_id              out number,role_id
  --            p_company_id           out number,  company_id                   
  --            p_encrypted_session_id out varchar2,ؼsession_id
  --************************************************************
  procedure ad_login(p_user_name                in varchar2,
                     p_ip                       in varchar2,
                     p_session_id               out number,
                     p_user_id                  out number,
                     p_role_id                  out number,
                     p_company_id               out number,
                     p_lang                     out varchar2,
                     p_old_encrypted_session_id in varchar2,
                     p_encrypted_session_id     out varchar2) is
  begin
    --ñ׼ʵ
    ad_login_standard(p_user_name                => p_user_name,
                      p_ip                       => p_ip,
                      p_session_id               => p_session_id,
                      p_user_id                  => p_user_id,
                      p_role_id                  => p_role_id,
                      p_company_id               => p_company_id,
                      p_lang                     => p_lang,
                      p_old_encrypted_session_id => p_old_encrypted_session_id,
                      p_encrypted_session_id     => p_encrypted_session_id);
  end ad_login;
end sys_login_pkg;
/
spool off

exit