WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_NLS_LANGUAGE_PKG.log

create or replace package sys_nls_language_pkg is

	-- Author  : Alan Lee
	-- Created : 2009-06-30 09:33:59
	-- Purpose : Database Session NLS_LANGUAGE

	procedure set_nls_language(p_nls_language varchar2);

end sys_nls_language_pkg;
/
create or replace package body sys_nls_language_pkg is

   C_ZH_LANG varchar2(40) := 'SIMPLIFIED CHINESE';
	C_US_LANG varchar2(40) := 'AMERICAN';

	procedure set_nls_language(p_nls_language varchar2) is
		v_sql varchar2(20000);
		v_lang varchar2(40);
	begin
        if p_nls_language = 'us' then
			v_lang := C_US_LANG;
	    else
			v_lang := C_ZH_LANG;
		end if;
		v_sql := 'alter session set nls_language =' || chr(39) ||
						 v_lang || chr(39);
		execute immediate v_sql;

	exception
		when others then
			sys_raise_app_error_pkg.raise_sys_others_error(sqlerrm,
																										 p_created_by => 0,
																										 p_package_name => 'sys_nls_language_set_pkg',
																										 p_procedure_function_name => 'set_nls_language');

			raise_application_error(sys_raise_app_error_pkg.c_error_number,
															sys_raise_app_error_pkg.g_err_line_id);

	end set_nls_language;
	
end sys_nls_language_pkg;
/
spool off

exit