WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool sys_parameter_pkg.log

create or replace package sys_parameter_pkg is

  -- Author  : XiaoGuoJun
  -- Created : 2009-4-2 10:44:11
  -- Purpose :
  /**********
               ԶάϵͳĻϢ
               ϵͳĲֹظ
               ֲ֧Ķ֤
               ֤͹ַ֣֡SQL֤
               ûѡַ֣ûڶֵʱַ
               ûѡSQL֤ûͬʱ֤SQL䡣֤SQL䣬Ҫѡֶμֵ롢ֶ
               ɶϵͳЧڷΧ
               ɶûԲ鿴͸µȨ
               ɲ鿴
               ɸ
               ɶļ
               ȫ
               ɫ
               ֯
               û
               ˾һ
             ֵָ
               ָÿڲͬµֵ
               ֵʱҪв֤
               ΪSQL ʱֵʾĲ룬ָ˾ʱֵʾ˾
               ΪSQLʱֵʾֵָ˾ʱֵʾ˾
             ֵָ-û
               ָÿڵǰûµĲֵ
               ֵʱҪв֤
               ΪSQL ʱֵʾĲ룬ָ˾ʱֵʾ˾
               ΪSQLʱֵʾֵָ˾ʱֵʾ˾
  *****************/
  procedure insert_parameter(p_module_id            number,
                             p_parameter_code       varchar2,
                             p_validation_type      varchar2,
                             p_description          varchar2,
                             p_user_changeable_flag varchar2,
                             p_user_visible_flag    varchar2,
                             p_system_enabled_flag  varchar2,
                             p_role_enabled_flag    varchar2,
                             p_user_enabled_flag    varchar2,
                             p_sql_validation       varchar2,
                             p_start_date_active    date,
                             p_end_date_active      date,
                             p_parameter_name       varchar2,
                             p_encrypt_value_flag   varchar2,
                             p_app_enabled_flag     varchar2,
                             p_user_id              number,
                             p_company_enabled_flag varchar2);

  procedure update_parameter(p_module_id            number,
                             p_parameter_id         number,
                             p_validation_type      varchar2,
                             p_description          varchar2,
                             p_user_changeable_flag varchar2,
                             p_user_visible_flag    varchar2,
                             p_system_enabled_flag  varchar2,
                             p_role_enabled_flag    varchar2,
                             p_user_enabled_flag    varchar2,
                             p_sql_validation       varchar2,
                             p_start_date_active    date,
                             p_end_date_active      date,
                             p_parameter_name       varchar2,
                             p_encrypt_value_flag   varchar2,
                             p_app_enabled_flag     varchar2,
                             p_user_id              number,
                             p_company_enabled_flag varchar2);

  procedure update_parameter_values(p_parameter_id    number,
                                    p_module_id       number,
                                    p_level_id        number,
                                    p_level_value     number,
                                    p_parameter_value varchar2,
                                    p_value_code      varchar2,
                                    p_value_name      varchar2,
                                    p_user_id         number);
  procedure delete_parameters(p_parameter_code in varchar2);

  --ʱ
  procedure insert_parameters_load(p_module               in varchar2,
                                   p_parameter_code       in varchar2,
                                   p_validation_type      in varchar2,
                                   p_description          in varchar2,
                                   p_user_changeable_flag in varchar2 default 'N',
                                   p_user_visible_flag    in varchar2 default 'Y',
                                   p_system_enabled_flag  in varchar2 default 'Y',
                                   p_role_enabled_flag    in varchar2 default 'Y',
                                   p_user_enabled_flag    in varchar2 default 'Y',
                                   p_sql_validation       in varchar2 default null,
                                   p_start_date_active    in date default to_date('1000-01-01',
                                                                                  'YYYY-MM-DD'),
                                   p_end_date_active      in date default to_date('3000-01-01',
                                                                                  'YYYY-MM-DD'),
                                   p_parameter_name       in varchar2,
                                   p_language_code        in varchar2,
                                   p_function_code        in varchar2 default null,
                                   p_encrypt_value_flag   in varchar2 default 'N',
                                   p_company_enabled_flag varchar2 default 'N');

  procedure insert_parameter_values_load(p_parameter_code  in varchar2,
                                         p_level_id        in number,
                                         p_level_code      in varchar2,
                                         p_parameter_value in varchar2);

  /*
   if the parameters:p_user_id is null and p_user_id is null and p_company_id is null, then
  the function will get the system-level value of a parameter ,else
  the funtion will get with the priority value of a parameter
  */
  function value(p_parameter_code varchar2,
                 p_user_id        number default null,
                 p_role_id        number default null,
                 p_company_id     number default null) return varchar2;
end sys_parameter_pkg;
/
create or replace package body sys_parameter_pkg is

  e_end_date_error exception;
  e_parameters_level exception;
  e_sql_validation exception;

  --delete_parameters
  procedure delete_parameters(p_parameter_code in varchar2) is
    v_parameter_code sys_parameters.parameter_code%type;
  
  begin
  
    v_parameter_code := upper(p_parameter_code);
  
    delete fnd_descriptions b
     where b.ref_table = 'SYS_PARAMETERS'
       and b.ref_field = 'PARAMETER_NAME_ID'
       and exists (select 1
              from sys_parameters a
             where a.parameter_name_id = b.description_id
               and a.parameter_code = v_parameter_code);
  
    delete sys_parameter_values a
     where a.parameter_id in
           (select b.parameter_id
              from sys_parameters b
             where b.parameter_code = v_parameter_code);
  
    delete sys_parameters a where a.parameter_code = v_parameter_code;
  
  end;

  procedure sql_validation(p_sql_validation varchar2) is
    v_exists number;
    v_sql    sys_parameters.sql_validation%type;
  begin
    if p_sql_validation is null then
      return;
    end if;
  
    v_sql := upper(p_sql_validation);
    select instr(v_sql,
                 'VALUE_ID',
                 1)
      into v_exists
      from dual;
    if v_exists = 0 then
      raise e_sql_validation;
    end if;
  
    select instr(v_sql,
                 'VALUE_CODE',
                 1)
      into v_exists
      from dual;
    if v_exists = 0 then
      raise e_sql_validation;
    end if;
  
    select instr(v_sql,
                 'VALUE_NAME',
                 1)
      into v_exists
      from dual;
    if v_exists = 0 then
      raise e_sql_validation;
    end if;
  end sql_validation;

  procedure insert_parameter(p_module_id            number,
                             p_parameter_code       varchar2,
                             p_validation_type      varchar2,
                             p_description          varchar2,
                             p_user_changeable_flag varchar2,
                             p_user_visible_flag    varchar2,
                             p_system_enabled_flag  varchar2,
                             p_role_enabled_flag    varchar2,
                             p_user_enabled_flag    varchar2,
                             p_sql_validation       varchar2,
                             p_start_date_active    date,
                             p_end_date_active      date,
                             p_parameter_name       varchar2,
                             p_encrypt_value_flag   varchar2,
                             p_app_enabled_flag     varchar2,
                             p_user_id              number,
                             p_company_enabled_flag varchar2) is
    v_description_id number;
  begin
  
    if p_start_date_active > nvl(p_end_date_active,
                                 p_start_date_active) then
      raise e_end_date_error;
    end if;
  
    if nvl(p_system_enabled_flag,
           'N') = 'N' and
       nvl(p_role_enabled_flag,
           'N') = 'N' and
       nvl(p_user_enabled_flag,
           'N') = 'N' and
       nvl(p_company_enabled_flag,
           'N') = 'N' then
      raise e_parameters_level;
    end if;
    sql_validation(p_sql_validation);
    v_description_id := fnd_description_pkg.get_fnd_description_id;
  
    insert into sys_parameters
      (module_id,
       parameter_id,
       parameter_code,
       validation_type,
       description,
       user_changeable_flag,
       user_visible_flag,
       system_enabled_flag,
       role_enabled_flag,
       user_enabled_flag,
       sql_validation,
       start_date_active,
       end_date_active,
       parameter_name_id,
       encrypt_value_flag,
       app_enabled_flag,
       last_update_date,
       last_updated_by,
       creation_date,
       created_by,
       company_enabled_flag)
    values
      (p_module_id,
       sys_parameters_s.nextval,
       upper(p_parameter_code),
       p_validation_type,
       p_description,
       p_user_changeable_flag,
       p_user_visible_flag,
       p_system_enabled_flag,
       p_role_enabled_flag,
       p_user_enabled_flag,
       p_sql_validation,
       p_start_date_active,
       p_end_date_active,
       v_description_id,
       p_encrypt_value_flag,
       p_app_enabled_flag,
       sysdate,
       p_user_id,
       sysdate,
       p_user_id,
       p_company_enabled_flag);
  
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                               p_ref_table        => 'SYS_PARAMETERS',
                                               p_ref_field        => 'PARAMETER_NAME_ID',
                                               p_description_text => p_parameter_name,
                                               p_created_by       => p_user_id,
                                               p_last_updated_by  => p_user_id,
                                               p_language_code    => userenv('LANG'));
  exception
    when e_sql_validation then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_SQL_VALIDATION',
                                                      p_created_by              => p_user_id,
                                                      p_package_name            => 'SYS_PARAMETER_PKG',
                                                      p_procedure_function_name => 'insert_parameter');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_parameters_level then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_CHECK_PARAMETERS_LEVEL',
                                                      p_created_by              => p_user_id,
                                                      p_package_name            => 'SYS_PARAMETER_PKG',
                                                      p_procedure_function_name => 'insert_parameter');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_end_date_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_END_DATE_ERROR',
                                                      p_created_by              => p_user_id,
                                                      p_package_name            => 'SYS_PARAMETER_PKG',
                                                      p_procedure_function_name => 'insert_parameter');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when dup_val_on_index then
      --insert  Ψһ
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_UNIQUE_ERROR', --
                                                      p_created_by              => p_user_id,
                                                      p_package_name            => 'SYS_PARAMETER_PKG',
                                                      p_procedure_function_name => 'insert_parameter');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_user_id,
                                                     p_package_name            => 'SYS_PARAMETER_PKG',
                                                     p_procedure_function_name => 'insert_parameter');
    
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    
  end insert_parameter;

  procedure update_parameter(p_module_id            number,
                             p_parameter_id         number,
                             p_validation_type      varchar2,
                             p_description          varchar2,
                             p_user_changeable_flag varchar2,
                             p_user_visible_flag    varchar2,
                             p_system_enabled_flag  varchar2,
                             p_role_enabled_flag    varchar2,
                             p_user_enabled_flag    varchar2,
                             p_sql_validation       varchar2,
                             p_start_date_active    date,
                             p_end_date_active      date,
                             p_parameter_name       varchar2,
                             p_encrypt_value_flag   varchar2,
                             p_app_enabled_flag     varchar2,
                             p_user_id              number,
                             p_company_enabled_flag varchar2) is
    v_description_id number;
  
    e_user_visible_flag exception;
  begin
  
    if p_start_date_active > nvl(p_end_date_active,
                                 p_start_date_active) then
      raise e_end_date_error;
    end if;
  
    if p_user_changeable_flag = 'Y' and
       p_user_visible_flag = 'N' then
      raise e_user_visible_flag;
    end if;
  
    if nvl(p_system_enabled_flag,
           'N') = 'N' and
       nvl(p_role_enabled_flag,
           'N') = 'N' and
       nvl(p_user_enabled_flag,
           'N') = 'N' and
       nvl(p_company_enabled_flag,
           'N') = 'N' then
      raise e_parameters_level;
    end if;
  
    sql_validation(p_sql_validation);
  
    begin
      select t.parameter_name_id
        into v_description_id
        from sys_parameters t
       where t.parameter_id = p_parameter_id;
    exception
      when others then
        null;
    end;
    if v_description_id is null then
      v_description_id := fnd_description_pkg.get_fnd_description_id;
    end if;
    update sys_parameters
       set module_id            = p_module_id,
           validation_type      = p_validation_type,
           description          = p_description,
           user_changeable_flag = p_user_changeable_flag,
           user_visible_flag    = p_user_visible_flag,
           system_enabled_flag  = p_system_enabled_flag,
           role_enabled_flag    = p_role_enabled_flag,
           user_enabled_flag    = p_user_enabled_flag,
           sql_validation       = p_sql_validation,
           start_date_active    = p_start_date_active,
           end_date_active      = p_end_date_active,
           parameter_name_id    = v_description_id,
           encrypt_value_flag   = p_encrypt_value_flag,
           app_enabled_flag     = p_app_enabled_flag,
           last_update_date     = sysdate,
           last_updated_by      = p_user_id,
           company_enabled_flag = p_company_enabled_flag
     where parameter_id = p_parameter_id;
  
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                               p_ref_table        => 'SYS_PARAMETERS',
                                               p_ref_field        => 'PARAMETER_NAME_ID',
                                               p_description_text => p_parameter_name,
                                               p_created_by       => p_user_id,
                                               p_last_updated_by  => p_user_id,
                                               p_language_code    => userenv('LANG'));
  
  exception
    when e_sql_validation then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_SQL_VALIDATION',
                                                      p_created_by              => p_user_id,
                                                      p_package_name            => 'SYS_PARAMETER_PKG',
                                                      p_procedure_function_name => 'update_parameter');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_user_visible_flag then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_CHECK_USER_VISIBLE_FLAG',
                                                      p_created_by              => p_user_id,
                                                      p_package_name            => 'SYS_PARAMETER_PKG',
                                                      p_procedure_function_name => 'update_parameter');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_parameters_level then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_CHECK_PARAMETERS_LEVEL',
                                                      p_created_by              => p_user_id,
                                                      p_package_name            => 'SYS_PARAMETER_PKG',
                                                      p_procedure_function_name => 'update_parameter');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_end_date_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_END_DATE_ERROR',
                                                      p_created_by              => p_user_id,
                                                      p_package_name            => 'SYS_PARAMETER_PKG',
                                                      p_procedure_function_name => 'update_parameter');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_user_id,
                                                     p_package_name            => 'SYS_PARAMETER_PKG',
                                                     p_procedure_function_name => 'update_parameter');
    
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end update_parameter;

  procedure update_parameter_values(p_parameter_id    number,
                                    p_module_id       number,
                                    p_level_id        number,
                                    p_level_value     number,
                                    p_parameter_value varchar2,
                                    p_value_code      varchar2,
                                    p_value_name      varchar2,
                                    p_user_id         number) is
    v_parameter_value sys_parameter_values.parameter_value%type;
    v_level_value     sys_parameter_values.level_value%type;
    v_exists          number;
  begin
    begin
      select 1
        into v_exists
        from dual
       where exists (select 1
                from sys_parameters p
               where p.parameter_id = p_parameter_id
                 and p.encrypt_value_flag = 'Y');
      v_parameter_value := sys_crypt.des_encrypt(input_data => p_parameter_value);
    exception
      when no_data_found then
        v_parameter_value := p_parameter_value;
    end;
  
    if p_level_id = 101 then
      v_level_value := 1;
    else
      v_level_value := p_level_value;
    end if;
    update sys_parameter_values t
       set t.parameter_value  = v_parameter_value,
           t.value_code       = p_value_code,
           t.value_name       = p_value_name,
           t.last_update_date = sysdate,
           t.last_updated_by  = p_user_id
     where t.module_id = p_module_id
       and t.parameter_id = p_parameter_id
       and t.level_id = p_level_id
       and t.level_value = v_level_value;
  
    if sql%notfound then
      insert into sys_parameter_values
        (module_id,
         parameter_id,
         level_id,
         level_value,
         parameter_value,
         value_code,
         value_name,
         last_update_date,
         last_updated_by,
         creation_date,
         created_by)
      values
        (p_module_id,
         p_parameter_id,
         p_level_id,
         v_level_value,
         v_parameter_value,
         p_value_code,
         p_value_name,
         sysdate,
         p_user_id,
         sysdate,
         p_user_id);
    end if;
  
  exception
    when dup_val_on_index then
      --insert  Ψһ
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_VALUES_UNIQUE_ERROR', --
                                                      p_created_by              => p_user_id,
                                                      p_package_name            => 'SYS_PARAMETER_PKG',
                                                      p_procedure_function_name => 'update_parameter_values');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message      => dbms_utility.format_error_backtrace || ' ' ||
                                                                      
                                                                       sqlerrm,
                                                     p_created_by   => p_user_id,
                                                     p_package_name => 'SYS_PARAMETER_PKG',
                                                     
                                                     p_procedure_function_name => 'insert_parameter');
    
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    
  end;

  procedure insert_parameters_load(p_module               in varchar2,
                                   p_parameter_code       in varchar2,
                                   p_validation_type      in varchar2,
                                   p_description          in varchar2,
                                   p_user_changeable_flag in varchar2 default 'N',
                                   p_user_visible_flag    in varchar2 default 'Y',
                                   p_system_enabled_flag  in varchar2 default 'Y',
                                   p_role_enabled_flag    in varchar2 default 'Y',
                                   p_user_enabled_flag    in varchar2 default 'Y',
                                   p_sql_validation       in varchar2 default null,
                                   p_start_date_active    in date default to_date('1000-01-01',
                                                                                  'YYYY-MM-DD'),
                                   p_end_date_active      in date default to_date('3000-01-01',
                                                                                  'YYYY-MM-DD'),
                                   p_parameter_name       in varchar2,
                                   p_language_code        in varchar2,
                                   p_function_code        in varchar2 default null,
                                   p_encrypt_value_flag   in varchar2 default 'N',
                                   p_company_enabled_flag varchar2 default 'N') is
  
    v_module               varchar2(10);
    v_module_id            number;
    v_parameter_id         number;
    v_parameter_code       sys_parameters.parameter_code%type;
    v_validation_type      sys_parameters.validation_type%type;
    v_description          sys_parameters.description%type;
    v_user_changeable_flag sys_parameters.user_changeable_flag%type;
    v_user_visible_flag    sys_parameters.user_visible_flag%type;
    v_system_enabled_flag  sys_parameters.system_enabled_flag%type;
    v_role_enabled_flag    sys_parameters.role_enabled_flag%type;
    v_user_enabled_flag    sys_parameters.user_enabled_flag%type;
    v_sql_validation       sys_parameters.sql_validation%type;
    v_start_date_active    date;
    v_end_date_active      date;
    v_parameter_name       varchar2(2000);
    v_parameter_name_id    number;
    v_language_code        varchar2(30);
    v_function_code        varchar2(30);
    v_count                number;
    v_encrypt_value_flag   sys_parameters.encrypt_value_flag%type;
  begin
  
    --initialize
    v_module               := upper(p_module);
    v_parameter_code       := upper(p_parameter_code);
    v_validation_type      := upper(p_validation_type);
    v_description          := p_description;
    v_user_changeable_flag := upper(p_user_changeable_flag);
    v_user_visible_flag    := upper(p_user_visible_flag);
    v_system_enabled_flag  := upper(p_system_enabled_flag);
    v_role_enabled_flag    := upper(p_role_enabled_flag);
    v_user_enabled_flag    := upper(p_user_enabled_flag);
    v_sql_validation       := p_sql_validation;
    v_start_date_active    := p_start_date_active;
    v_end_date_active      := p_end_date_active;
    v_parameter_name       := p_parameter_name;
    v_language_code        := upper(p_language_code);
    v_function_code        := upper(p_function_code);
    v_encrypt_value_flag   := nvl(p_encrypt_value_flag,
                                  'N');
    --attain data
  
    select module_id
      into v_module_id
      from sys_module
     where module_code = v_module;
  
    select count(*)
      into v_count
      from sys_parameters
     where parameter_code = v_parameter_code;
  
    if v_count != 0 then
      select parameter_id,
             parameter_name_id
        into v_parameter_id,
             v_parameter_name_id
        from sys_parameters
       where parameter_code = v_parameter_code;
    
      update sys_parameters sp
         set sp.validation_type      = v_validation_type,
             sp.description          = v_description,
             sp.last_update_date     = sysdate,
             sp.last_updated_by      = 1,
             sp.user_changeable_flag = v_user_changeable_flag,
             sp.user_visible_flag    = v_user_visible_flag,
             sp.system_enabled_flag  = v_system_enabled_flag,
             sp.role_enabled_flag    = v_role_enabled_flag,
             sp.user_enabled_flag    = v_user_enabled_flag,
             sp.sql_validation       = v_sql_validation,
             sp.start_date_active    = v_start_date_active,
             sp.end_date_active      = v_end_date_active,
             sp.encrypt_value_flag   = v_encrypt_value_flag
       where sp.parameter_code = v_parameter_code;
    
      fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_parameter_name_id,
                                                 p_ref_table        => 'SYS_PARAMETERS',
                                                 p_ref_field        => 'PARAMETER_NAME_ID',
                                                 p_description_text => v_parameter_name,
                                                 p_function_name    => v_function_code,
                                                 p_created_by       => 1,
                                                 p_last_updated_by  => 1,
                                                 p_language_code    => v_language_code);
    
    else
      select sys_parameters_s.nextval into v_parameter_id from dual;
    
      v_parameter_name_id := fnd_description_pkg.get_fnd_description_id;
    
      insert into sys_parameters
        (module_id,
         parameter_id,
         parameter_code,
         validation_type,
         description,
         last_update_date,
         last_updated_by,
         creation_date,
         created_by,
         user_changeable_flag,
         user_visible_flag,
         system_enabled_flag,
         role_enabled_flag,
         user_enabled_flag,
         sql_validation,
         start_date_active,
         end_date_active,
         parameter_name_id,
         encrypt_value_flag,
         company_enabled_flag)
      values
        (v_module_id,
         v_parameter_id,
         v_parameter_code,
         v_validation_type,
         v_description,
         sysdate,
         1,
         sysdate,
         1,
         v_user_changeable_flag,
         v_user_visible_flag,
         v_system_enabled_flag,
         v_role_enabled_flag,
         v_user_enabled_flag,
         v_sql_validation,
         v_start_date_active,
         v_end_date_active,
         v_parameter_name_id,
         v_encrypt_value_flag,
         p_company_enabled_flag);
    
      fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_parameter_name_id,
                                                 p_ref_table        => 'SYS_PARAMETERS',
                                                 p_ref_field        => 'PARAMETER_NAME_ID',
                                                 p_description_text => v_parameter_name,
                                                 p_created_by       => 1,
                                                 p_last_updated_by  => 1,
                                                 p_language_code    => v_language_code);
    
    end if;
  
  end insert_parameters_load;

  procedure insert_parameter_values_load(p_parameter_code  in varchar2,
                                         p_level_id        in number,
                                         p_level_code      in varchar2,
                                         p_parameter_value in varchar2) is
  
    v_parameter_code  varchar2(100);
    v_module_id       number;
    v_parameter_id    number;
    v_level_id        number;
    v_level_code      varchar2(30);
    v_level_value     number;
    v_parameter_value varchar2(240);
    v_exists          varchar2(1);
  
  begin
  
    v_parameter_code  := upper(p_parameter_code);
    v_level_id        := p_level_id;
    v_level_code      := upper(p_level_code);
    v_parameter_value := upper(p_parameter_value);
  
    select a.parameter_id,
           a.module_id
      into v_parameter_id,
           v_module_id
      from sys_parameters a
     where a.parameter_code = v_parameter_code;
  
    if v_level_id = 101 then
      /*SYS LEVEL PARAMETER VALUE*/
      v_level_value := 1;
    elsif v_level_id = 102 then
      /*ROLE LEVEL PARAMETER VALUE*/
      select t.role_id
        into v_level_value
        from sys_role t
       where t.role_code = v_level_code;
    elsif v_level_id = 103 then
      /*USER LEVEL PARAMETER VALUE*/
      select t.user_id
        into v_level_value
        from sys_user t
       where t.user_name = v_level_code;
    elsif v_level_id = 104 then
      /*Company LEVEL PARAMETER VALUE*/
      select company_id
        into v_level_value
        from fnd_companies
       where company_code = v_level_code;
    end if;
  
    begin
      select 'Y'
        into v_exists
        from dual
       where exists (select 1
                from sys_parameter_values t
               where t.parameter_id = v_parameter_id
                 and t.level_id = p_level_id
                 and t.level_value = v_level_value);
    
      --parameter_valuepatchʱ Ḳԭϵͳ 2009.09.11
      /* if v_exists = 'Y' then
        update sys_parameter_values t
           set t.parameter_value  = p_parameter_value,
               t.last_update_date = sysdate,
               t.last_updated_by  = 1
         where t.parameter_id = v_parameter_id
           and t.level_id = p_level_id
           and t.level_value = v_level_value;
      end if;*/
    exception
      when no_data_found then
        insert into sys_parameter_values
          (module_id,
           parameter_id,
           level_id,
           level_value,
           parameter_value,
           last_update_date,
           last_updated_by,
           creation_date,
           created_by)
        values
          (v_module_id,
           v_parameter_id,
           v_level_id,
           v_level_value,
           v_parameter_value,
           sysdate,
           1,
           sysdate,
           1);
    end;
  end insert_parameter_values_load;

  --ȡϵͳֵ
  function value(p_parameter_code varchar2,
                 p_user_id        number default null,
                 p_role_id        number default null,
                 p_company_id     number default null) return varchar2 is
    cursor cur_values is
      select t1.parameter_value,
             t2.encrypt_value_flag
        from sys_parameter_values t1,
             sys_parameters       t2
       where t2.parameter_code = p_parameter_code
         and t2.start_date_active <= sysdate
         and nvl(t2.end_date_active,
                 sysdate) >= sysdate
         and (t1.level_id = 103 and t1.level_value = p_user_id)
         and t1.module_id = t2.module_id
         and t1.parameter_id = t2.parameter_id
         and t1.parameter_value is not null
         and t2.user_enabled_flag = 'Y'
      union all
      select t1.parameter_value,
             t2.encrypt_value_flag
        from sys_parameter_values t1,
             sys_parameters       t2
       where t2.parameter_code = p_parameter_code
         and t2.start_date_active <= sysdate
         and nvl(t2.end_date_active,
                 sysdate) >= sysdate
         and (t1.level_id = 102 and t1.level_value = p_role_id)
         and t1.module_id = t2.module_id
         and t1.parameter_id = t2.parameter_id
         and t1.parameter_value is not null
         and t2.role_enabled_flag = 'Y'
      union all
      select t1.parameter_value,
             t2.encrypt_value_flag
        from sys_parameter_values t1,
             sys_parameters       t2
       where t2.parameter_code = p_parameter_code
         and t2.start_date_active <= sysdate
         and nvl(t2.end_date_active,
                 sysdate) >= sysdate
         and (t1.level_id = 104 and t1.level_value = p_company_id)
         and t1.module_id = t2.module_id
         and t1.parameter_id = t2.parameter_id
         and t1.parameter_value is not null
         and nvl(t2.company_enabled_flag,
                 'N') = 'Y'
      union all
      select t1.parameter_value,
             t2.encrypt_value_flag
        from sys_parameter_values t1,
             sys_parameters       t2
       where t2.parameter_code = p_parameter_code
         and t2.start_date_active <= sysdate
         and nvl(t2.end_date_active,
                 sysdate) >= sysdate
         and (t1.level_id = 101 and t1.level_value = 1)
         and t1.module_id = t2.module_id
         and t1.parameter_id = t2.parameter_id
         and t1.parameter_value is not null
         and t2.system_enabled_flag = 'Y';
  
    v_parameter_value    sys_parameter_values.parameter_value%type;
    v_encrypt_value_flag sys_parameters.encrypt_value_flag%type;
  
    --v_parameter_code varchar2(2000);
  begin
    open cur_values;
    fetch cur_values
      into v_parameter_value, v_encrypt_value_flag;
    if (cur_values%notfound) then
      v_parameter_value := null;
    else
      if v_encrypt_value_flag = 'Y' then
        v_parameter_value := sys_crypt.des_decrypt(input_data => v_parameter_value);
      end if;
    end if;
    close cur_values;
  
    return v_parameter_value;
  end value;

end sys_parameter_pkg;
/
spool off

exit
