WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool sys_prompt_pkg.log

create or replace package sys_prompt_pkg is

  -- Author  : ADMINISTRATOR
  -- Created : 2009-4-8 17:08:22
  -- Purpose :

  procedure insert_prompt(p_prompt_code varchar2,
                          p_description varchar2,
                          p_created_by  number,
                          p_language    varchar2 default userenv('LANG'),
                          p_prompt_id   out number);

  procedure update_prompt(p_prompt_id   number,
                          p_prompt_code varchar2,
                          p_description varchar2,
                          p_created_by  number,
                          p_language    varchar2 default userenv('LANG'));

  procedure delete_prompt(p_prompt_code varchar2);

  procedure delete_prompt(p_prompt_code varchar2, p_language varchar2);

  procedure appoint_user_prompt(p_prompt_id   number,
                                p_user_id     number,
                                p_prompt_code varchar2,
                                p_language    varchar2,
                                p_description varchar2,
                                p_created_by  number);

  procedure appoint_role_prompt(p_prompt_id   number,
                                p_role_id     number,
                                p_prompt_code varchar2,
                                p_language    varchar2,
                                p_description varchar2,
                                p_created_by  number);

  procedure appoint_company_prompt(p_prompt_id   number,
                                   p_company_id  number,
                                   p_prompt_code varchar2,
                                   p_language    varchar2,
                                   p_description varchar2,
                                   p_created_by  number);

  --
  procedure sys_prompts_load(p_prompt_code varchar2,
                             p_language    varchar2,
                             p_description varchar2,
                             p_created_by  number default 1);

end sys_prompt_pkg;
/
create or replace package body sys_prompt_pkg is

  procedure insert_prompt(p_prompt_code varchar2,
                          p_description varchar2,
                          p_created_by  number,
                          p_language    varchar2 default userenv('LANG'),
                          p_prompt_id   out number) is
  begin
    select sys_prompts_s.nextval into p_prompt_id from dual;
    insert into sys_prompts
      (prompt_id,
       prompt_code,
       language,
       description,
       last_update_date,
       last_updated_by,
       creation_date,
       created_by)
    values
      (p_prompt_id,
       upper(p_prompt_code),
       p_language,
       p_description,
       sysdate,
       p_created_by,
       sysdate,
       p_created_by);
  exception
    when dup_val_on_index then
      --insert  Ψһ
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PROMPT_UNIQUE_ERROR', --
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'SYS_PROMPT_PKG',
                                                      p_procedure_function_name => 'insert_prompt');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_created_by,
                                                     p_package_name            => 'SYS_PROMPT_PKG',
                                                     p_procedure_function_name => 'insert_prompt');

      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end insert_prompt;

  procedure update_prompt(p_prompt_id   number,
                          p_prompt_code varchar2,
                          p_description varchar2,
                          p_created_by  number,
                          p_language    varchar2 default userenv('LANG')) is
  begin
    update sys_prompts t
       set t.description      = p_description,
           t.last_update_date = sysdate,
           t.last_updated_by  = p_created_by
     where t.prompt_id = p_prompt_id;
  end update_prompt;

  procedure delete_prompt(p_prompt_code varchar2) is
    v_prompt_id   sys_prompts.prompt_id%type;
    v_prompt_code sys_prompts.prompt_code%type;
  begin
    v_prompt_code := upper(p_prompt_code);
    for cur_promt in (select s.language
                        from sys_prompts s
                       where s.prompt_code = v_prompt_code) loop

      delete sys_user_prompts t
       where t.prompt_code = v_prompt_code
         and t.language = cur_promt.language;

      delete sys_role_prompts t
       where t.prompt_code = v_prompt_code
         and t.language = cur_promt.language;

      delete sys_company_prompts t
       where t.prompt_code = v_prompt_code
         and t.language = cur_promt.language;

      delete sys_prompts t
       where t.prompt_code = v_prompt_code
         and t.language = cur_promt.language;
    end loop;
  end delete_prompt;

  procedure delete_prompt(p_prompt_code varchar2, p_language varchar2) is
    v_prompt_id   sys_prompts.prompt_id%type;
    v_prompt_code sys_prompts.prompt_code%type;
  begin
    v_prompt_code := upper(p_prompt_code);
    for cur_promt in (select s.language
                        from sys_prompts s
                       where s.prompt_code = v_prompt_code
                         and s.language = p_language) loop

      delete sys_user_prompts t
       where t.prompt_code = v_prompt_code
         and t.language = cur_promt.language;

      delete sys_role_prompts t
       where t.prompt_code = v_prompt_code
         and t.language = cur_promt.language;

      delete sys_company_prompts t
       where t.prompt_code = v_prompt_code
         and t.language = cur_promt.language;

      delete sys_prompts t
       where t.prompt_code = v_prompt_code
         and t.language = cur_promt.language;
    end loop;
  end delete_prompt;

  procedure appoint_user_prompt(p_prompt_id   number,
                                p_user_id     number,
                                p_prompt_code varchar2,
                                p_language    varchar2,
                                p_description varchar2,
                                p_created_by  number) is
    v_language varchar2(30);
  begin
    if p_language is null then
      v_language := userenv('LANG');
    else
      v_language := p_language;
    end if;

    update sys_user_prompts t
       set description      = p_description,
           last_update_date = sysdate,
           last_updated_by  = p_created_by
     where t.prompt_id = p_prompt_id
       and t.user_id = p_user_id;
    if sql%notfound then
      insert into sys_user_prompts
        (prompt_id,
         user_id,
         prompt_code,
         language,
         description,
         last_update_date,
         last_updated_by,
         creation_date,
         created_by)
      values
        (p_prompt_id,
         p_user_id,
         upper(p_prompt_code),
         v_language,
         p_description,
         sysdate,
         p_created_by,
         sysdate,
         p_created_by);
    end if;
  exception
    when dup_val_on_index then
      --insert  Ψһ
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_PROMPT_UNIQUE_ERROR', --
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'SYS_PROMPT_PKG',
                                                      p_procedure_function_name => 'appoint_user_prompt');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_user_id,
                                                     p_package_name            => 'SYS_PROMPT_PKG',
                                                     p_procedure_function_name => 'appoint_user_prompt');

      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

  end appoint_user_prompt;

  procedure appoint_role_prompt(p_prompt_id   number,
                                p_role_id     number,
                                p_prompt_code varchar2,
                                p_language    varchar2,
                                p_description varchar2,
                                p_created_by  number) is
    v_language varchar2(30);
  begin
    if p_language is null then
      v_language := userenv('LANG');
    else
      v_language := p_language;
    end if;
    update sys_role_prompts t
       set description      = p_description,
           last_update_date = sysdate,
           last_updated_by  = p_created_by
     where t.prompt_id = p_prompt_id
       and t.role_id = p_role_id;
    if sql%notfound then
      insert into sys_role_prompts
        (prompt_id,
         role_id,
         prompt_code,
         language,
         description,
         last_update_date,
         last_updated_by,
         creation_date,
         created_by)
      values
        (p_prompt_id,
         p_role_id,
         upper(p_prompt_code),
         v_language,
         p_description,
         sysdate,
         p_created_by,
         sysdate,
         p_created_by);
    end if;
  exception
    when dup_val_on_index then
      --insert  Ψһ
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_ROLE_PROMPT_UNIQUE_ERROR', --
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'SYS_PROMPT_PKG',
                                                      p_procedure_function_name => 'appoint_user_prompt');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_created_by,
                                                     p_package_name            => 'SYS_PROMPT_PKG',
                                                     p_procedure_function_name => 'appoint_role_prompt');

      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

  end appoint_role_prompt;

  procedure appoint_company_prompt(p_prompt_id   number,
                                   p_company_id  number,
                                   p_prompt_code varchar2,
                                   p_language    varchar2,
                                   p_description varchar2,
                                   p_created_by  number) is
    v_language varchar2(30);
  begin
    if p_language is null then
      v_language := userenv('LANG');
    else
      v_language := p_language;
    end if;
    update sys_company_prompts t
       set description      = p_description,
           last_update_date = sysdate,
           last_updated_by  = p_created_by
     where t.prompt_id = p_prompt_id
       and t.company_id = p_company_id;
    if sql%notfound then
      insert into sys_company_prompts
        (prompt_id,
         company_id,
         prompt_code,
         language,
         description,
         last_update_date,
         last_updated_by,
         creation_date,
         created_by)
      values
        (p_prompt_id,
         p_company_id,
         upper(p_prompt_code),
         v_language,
         p_description,
         sysdate,
         p_created_by,
         sysdate,
         p_created_by);
    end if;
  exception
    when dup_val_on_index then
      --insert  Ψһ
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_COMPANY_PROMPT_UNIQUE_ERROR', --
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'SYS_PROMPT_PKG',
                                                      p_procedure_function_name => 'appoint_company_prompt');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_created_by,
                                                     p_package_name            => 'SYS_PROMPT_PKG',
                                                     p_procedure_function_name => 'appoint_company_prompt');

      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

  end appoint_company_prompt;

  --
  procedure sys_prompts_load(p_prompt_code varchar2,
                             p_language    varchar2,
                             p_description varchar2,
                             p_created_by  number default 1) is
    v_exists    number;
    v_prompt_id number;
  begin
    if p_prompt_code is null or p_language is null or p_description is null then
      return;
    end if;  
    begin
      select prompt_id
        into v_prompt_id
        from sys_prompts t
       where t.prompt_code = upper(p_prompt_code)
         and t.language = p_language;
    
      update_prompt(p_prompt_code => p_prompt_code,
                    p_description => p_description,
                    p_created_by  => p_created_by,
                    p_language    => p_language,
                    p_prompt_id   => v_prompt_id);
    exception when no_data_found then
      insert_prompt(p_prompt_code => p_prompt_code,
                    p_description => p_description,
                    p_created_by  => p_created_by,
                    p_language    => p_language,
                    p_prompt_id   => v_prompt_id);
    end;
    /*update sys_prompts t
       set t.description      = p_description,
           t.last_update_date = sysdate,
           t.last_updated_by  = p_created_by
     where t.prompt_code = upper(p_prompt_code)
       and t.language = p_language;

    if sql%notfound then
      insert_prompt(p_prompt_code => p_prompt_code,
                    p_description => p_description,
                    p_created_by  => p_created_by,
                    p_language    => p_language,
                    p_prompt_id   => v_prompt_id);
    end if;*/

  end sys_prompts_load;

end sys_prompt_pkg;
/
spool off

exit