WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool sys_raise_app_error_pkg.log

create or replace package sys_raise_app_error_pkg is

  -- Author  : Bobo
  -- Created : 2009-3-31 11:22:00
  -- Purpose : 

  g_err_line_id number;
  c_error_number constant integer := -20000;

  type msg_code_table_type is table of varchar2(255) index by binary_integer;
  type token_name_table_type is table of varchar2(100) index by binary_integer;
  type token_value_table_type is table of varchar2(1000) index by binary_integer;

  function get_app_error_line_id return number;

  --ȡϢ
  procedure get_sys_raise_app_error(p_app_error_line_id number,
                                    p_message           out varchar2);

  procedure raise_user_define_error(p_message_code            varchar2,
                                    p_created_by              number,
                                    p_package_name            varchar2,
                                    p_procedure_function_name varchar2,
                                    p_token_1                 varchar2 default null,
                                    p_token_value_1           varchar2 default null,
                                    p_token_2                 varchar2 default null,
                                    p_token_value_2           varchar2 default null,
                                    p_token_3                 varchar2 default null,
                                    p_token_value_3           varchar2 default null,
                                    p_token_4                 varchar2 default null,
                                    p_token_value_4           varchar2 default null,
                                    p_token_5                 varchar2 default null,
                                    p_token_value_5           varchar2 default null,
                                    p_token_6                 varchar2 default null,
                                    p_token_value_6           varchar2 default null,
                                    p_token_7                 varchar2 default null,
                                    p_token_value_7           varchar2 default null,
                                    p_token_8                 varchar2 default null,
                                    p_token_value_8           varchar2 default null,
                                    p_token_9                 varchar2 default null,
                                    p_token_value_9           varchar2 default null,
                                    p_token_10                varchar2 default null,
                                    p_token_value_10          varchar2 default null);

  procedure raise_sys_others_error(p_message                 varchar2,
                                   p_created_by              number,
                                   p_package_name            varchar2,
                                   p_procedure_function_name varchar2);

end sys_raise_app_error_pkg;
/
create or replace package body sys_raise_app_error_pkg is

  g_table_size        binary_integer := 0;
  g_msg_code_table    msg_code_table_type;
  g_token_name_table  token_name_table_type;
  g_token_value_table token_value_table_type;

  procedure set_token(p_message_code     in varchar2,
                      p_token_value_name in varchar2,
                      p_value            in varchar2) is
  begin
    g_msg_code_table(g_table_size) := p_message_code;
    g_token_name_table(g_table_size) := p_token_value_name;
    g_token_value_table(g_table_size) := p_value;
    g_table_size := g_table_size + 1;
  end set_token;

  procedure clear_token is
  begin
    g_table_size := 0;
    g_msg_code_table.delete;
    g_token_name_table.delete;
    g_token_value_table.delete;
  end clear_token;

  function get_msg(p_msg_code varchar2,
                   p_msg_text varchar2) return varchar2 is
    v_table_index binary_integer := 0;
    v_msg_text    varchar2(1000);
  begin
    v_msg_text := p_msg_text;
    while (v_table_index < g_table_size) loop
      if g_msg_code_table(v_table_index) = p_msg_code then
        v_msg_text := replace(v_msg_text,
                              g_token_name_table(v_table_index),
                              g_token_value_table(v_table_index));
      end if;
      v_table_index := v_table_index + 1;
    end loop;
    clear_token;
    return v_msg_text;
  end get_msg;

  --msg_codeȡϢ
  function get_message_text(p_message_code varchar2,
                            p_message_text out varchar2) return number is
    v_msg_text varchar2(2000);
  begin
    select t.message
      into v_msg_text
      from sys_messages t
     where t.language = userenv('lang')
       and t.message_code = p_message_code;
    p_message_text := v_msg_text;
    return 0;
  exception
    when no_data_found then
      return - 1;
  end get_message_text;

  --msg_codeȡϢ
  function get_message_text(p_message_code varchar2) return varchar2 is
    v_msg_text varchar2(2000);
  begin
    select t.message
      into v_msg_text
      from sys_messages t
     where t.language = userenv('lang')
       and t.message_code = p_message_code;
    return v_msg_text;
  exception
    when no_data_found then
      return null;
  end get_message_text;

  function create_sys_raise_app_errors(p_error_number            number,
                                       p_message_code            varchar2,
                                       p_message                 varchar2,
                                       p_created_by              number,
                                       p_package_name            varchar2,
                                       p_procedure_function_name varchar2 default null)
    return number is
    pragma autonomous_transaction;
  
    v_app_error_line_id number;
  begin
  
    v_app_error_line_id := get_app_error_line_id;
  
    insert into sys_raise_app_errors
      (app_error_line_id,
       error_number,
       message_code,
       message,
       message_date,
       created_by,
       package_name,
       procedure_function_name)
    values
      (v_app_error_line_id,
       p_error_number,
       p_message_code,
       p_message,
       sysdate,
       p_created_by,
       upper(p_package_name),
       upper(p_procedure_function_name));
    commit;
    return v_app_error_line_id;
  end create_sys_raise_app_errors;

  --ȡϢ
  procedure get_sys_raise_app_error(p_app_error_line_id number,
                                    p_message           out varchar2) is
  begin
    select s.message
      into p_message
      from sys_raise_app_errors s
     where app_error_line_id = p_app_error_line_id;
  
  exception
    when no_data_found then
      null;
  end get_sys_raise_app_error;

  function get_app_error_line_id return number is
    v_app_error_line_id number;
  begin
    select sys_raise_app_errors_s.nextval
      into v_app_error_line_id
      from dual;
    return v_app_error_line_id;
  end get_app_error_line_id;

  procedure raise_user_define_error(p_message_code            varchar2,
                                    p_created_by              number,
                                    p_package_name            varchar2,
                                    p_procedure_function_name varchar2,
                                    p_token_1                 varchar2 default null,
                                    p_token_value_1           varchar2 default null,
                                    p_token_2                 varchar2 default null,
                                    p_token_value_2           varchar2 default null,
                                    p_token_3                 varchar2 default null,
                                    p_token_value_3           varchar2 default null,
                                    p_token_4                 varchar2 default null,
                                    p_token_value_4           varchar2 default null,
                                    p_token_5                 varchar2 default null,
                                    p_token_value_5           varchar2 default null,
                                    p_token_6                 varchar2 default null,
                                    p_token_value_6           varchar2 default null,
                                    p_token_7                 varchar2 default null,
                                    p_token_value_7           varchar2 default null,
                                    p_token_8                 varchar2 default null,
                                    p_token_value_8           varchar2 default null,
                                    p_token_9                 varchar2 default null,
                                    p_token_value_9           varchar2 default null,
                                    p_token_10                varchar2 default null,
                                    p_token_value_10          varchar2 default null) is
    v_ret      number;
    v_errmsg   varchar2(2000);
    v_msg_text varchar2(2000);
  
    e_msg_code_not_found exception; --message_code δ
  begin
    g_err_line_id := null;
    v_ret         := get_message_text(p_message_code => p_message_code,
                                      p_message_text => v_msg_text);
    if v_ret <> 0 then
      raise e_msg_code_not_found;
    end if;
  
    if p_token_1 is not null then
      set_token(p_message_code     => p_message_code,
                p_token_value_name => p_token_1,
                p_value            => p_token_value_1);
    end if;
    if p_token_2 is not null then
      set_token(p_message_code     => p_message_code,
                p_token_value_name => p_token_2,
                p_value            => p_token_value_2);
    end if;
    if p_token_3 is not null then
      set_token(p_message_code     => p_message_code,
                p_token_value_name => p_token_3,
                p_value            => p_token_value_3);
    end if;
    if p_token_4 is not null then
      set_token(p_message_code     => p_message_code,
                p_token_value_name => p_token_4,
                p_value            => p_token_value_4);
    end if;
    if p_token_5 is not null then
      set_token(p_message_code     => p_message_code,
                p_token_value_name => p_token_5,
                p_value            => p_token_value_5);
    end if;
    if p_token_6 is not null then
      set_token(p_message_code     => p_message_code,
                p_token_value_name => p_token_6,
                p_value            => p_token_value_6);
    end if;
    if p_token_7 is not null then
      set_token(p_message_code     => p_message_code,
                p_token_value_name => p_token_7,
                p_value            => p_token_value_7);
    end if;
    if p_token_8 is not null then
      set_token(p_message_code     => p_message_code,
                p_token_value_name => p_token_8,
                p_value            => p_token_value_8);
    end if;
    if p_token_9 is not null then
      set_token(p_message_code     => p_message_code,
                p_token_value_name => p_token_9,
                p_value            => p_token_value_9);
    end if;
    if p_token_10 is not null then
      set_token(p_message_code     => p_message_code,
                p_token_value_name => p_token_10,
                p_value            => p_token_value_10);
    end if;
  
    v_errmsg := get_msg(p_message_code,
                        v_msg_text);
  
    g_err_line_id := create_sys_raise_app_errors(p_error_number            => c_error_number,
                                                 p_message_code            => p_message_code,
                                                 p_message                 => v_errmsg,
                                                 p_created_by              => p_created_by,
                                                 p_package_name            => p_package_name,
                                                 p_procedure_function_name => p_procedure_function_name);
  
  exception
    when e_msg_code_not_found then
      --ԶϢδҵĴ,ϵͳϢʾ
      v_msg_text := get_message_text(p_message_code => 'MESSAGE_CODE_NOT_FOUND');
    
      select replace(v_msg_text,
                     '#MESSAGE_CODE',
                     p_message_code)
        into v_errmsg
        from dual;
    
      g_err_line_id := create_sys_raise_app_errors(p_error_number            => c_error_number,
                                                   p_message_code            => 'MESSAGE_CODE_NOT_FOUND',
                                                   p_message                 => v_errmsg,
                                                   p_created_by              => p_created_by,
                                                   p_package_name            => p_package_name,
                                                   p_procedure_function_name => p_procedure_function_name);
  end raise_user_define_error;

  procedure raise_sys_others_error(p_message                 varchar2,
                                   p_created_by              number,
                                   p_package_name            varchar2,
                                   p_procedure_function_name varchar2) is
  
    v_error_code            varchar2(30);
    v_second_ora_occurrence number;
  
    e_value_error exception; --ַת󣬻ַȲ
    e_not_null exception; --ǿֶβnullֵ
    e_lock_table exception; --
    pragma exception_init(e_lock_table,
                          -54);
    e_too_many_rows exception;
    e_too_large_for_column exception; --볤ȳֶ󳤶
  begin
    --add by zhanglei 2009-7-9
    /*
      ӳʱ,ӳraiseĴ,ᱻraise_sys_others_errorǵ
      һж,sqlerrmд 'ORA-20000'  g_err_line_id Ϊյ,Ϊӳ׳쳣
    */
    if instr(sqlerrm,
             'ORA' || c_error_number,
             1,
             1) > 0 and g_err_line_id is not null then
      return;
    end if;
  
    g_err_line_id := null;
  
    begin
      --othersʱȡеĵڶoraŵʼλ
      select instr(p_message,
                   'ORA',
                   1,
                   2)
        into v_second_ora_occurrence
        from dual;
    
      --ȡڶoracode
      select substr(p_message,
                    v_second_ora_occurrence,
                    9)
        into v_error_code
        from dual;
    
      if v_error_code = 'ORA-00001' then
        --Ψһ
        raise dup_val_on_index;
      elsif v_error_code = 'ORA-01722' then
        --Ч
        raise invalid_number;
      elsif v_error_code = 'ORA-01403' then
        --δҵֵ
        raise no_data_found;
      elsif v_error_code in ('ORA-01422', 'ORA-01427') then
        --ض
        raise e_too_many_rows;
      elsif v_error_code = 'ORA-01476' then
        --ʹֳ0
        raise zero_divide;
      elsif v_error_code = 'ORA-06502' then
        --ַ->ת󣬻ַ߱Ȳ
        raise e_value_error;
      elsif v_error_code in ('ORA-01400', 'ORA-01407') then
        --ǿֶβ˿ֵ
        raise e_not_null;
      elsif v_error_code = 'ORA-00054' then
        raise e_lock_table;
      elsif v_error_code = 'ORA-12899' then
        raise e_too_large_for_column;
      end if;
    exception
      when no_data_found then
        null;
    end;
  
    g_err_line_id := create_sys_raise_app_errors(p_error_number            => c_error_number,
                                                 p_message_code            => 'SYS_RAISE_APP_OTHERS',
                                                 p_message                 => p_message,
                                                 p_created_by              => p_created_by,
                                                 p_package_name            => p_package_name,
                                                 p_procedure_function_name => p_procedure_function_name);
  
  exception
    when e_lock_table then
      g_err_line_id := create_sys_raise_app_errors(p_error_number            => c_error_number,
                                                   p_message_code            => 'SYS_LOCK_TABLE_ERROR',
                                                   p_message                 => p_message || ' ' ||
                                                                                get_message_text('SYS_LOCK_TABLE_ERROR'),
                                                   p_created_by              => p_created_by,
                                                   p_package_name            => p_package_name,
                                                   p_procedure_function_name => p_procedure_function_name);
    when e_not_null then
      g_err_line_id := create_sys_raise_app_errors(p_error_number            => c_error_number,
                                                   p_message_code            => 'SYS_NOT_NULL',
                                                   p_message                 => p_message || ' ' ||
                                                                                get_message_text('SYS_NOT_NULL'),
                                                   p_created_by              => p_created_by,
                                                   p_package_name            => p_package_name,
                                                   p_procedure_function_name => p_procedure_function_name);
    when e_value_error then
      g_err_line_id := create_sys_raise_app_errors(p_error_number            => c_error_number,
                                                   p_message_code            => 'SYS_VALUE_ERROR',
                                                   p_message                 => p_message || ' ' ||
                                                                                get_message_text('SYS_VALUE_ERROR'),
                                                   p_created_by              => p_created_by,
                                                   p_package_name            => p_package_name,
                                                   p_procedure_function_name => p_procedure_function_name);
    when dup_val_on_index then
      g_err_line_id := create_sys_raise_app_errors(p_error_number            => c_error_number,
                                                   p_message_code            => 'SYS_DUP_VAL_ON_INDEX',
                                                   p_message                 => p_message || ' ' ||
                                                                                get_message_text('SYS_DUP_VAL_ON_INDEX'),
                                                   p_created_by              => p_created_by,
                                                   p_package_name            => p_package_name,
                                                   p_procedure_function_name => p_procedure_function_name);
    when invalid_number then
      g_err_line_id := create_sys_raise_app_errors(p_error_number            => c_error_number,
                                                   p_message_code            => 'SYS_INVALID_NUMBER',
                                                   p_message                 => p_message || ' ' ||
                                                                                get_message_text('SYS_INVALID_NUMBER'),
                                                   p_created_by              => p_created_by,
                                                   p_package_name            => p_package_name,
                                                   p_procedure_function_name => p_procedure_function_name);
    when no_data_found then
      g_err_line_id := create_sys_raise_app_errors(p_error_number            => c_error_number,
                                                   p_message_code            => 'SYS_NO_DATA_FOUND',
                                                   p_message                 => p_message || ' ' ||
                                                                                get_message_text('SYS_NO_DATA_FOUND'),
                                                   p_created_by              => p_created_by,
                                                   p_package_name            => p_package_name,
                                                   p_procedure_function_name => p_procedure_function_name);
    when zero_divide then
      g_err_line_id := create_sys_raise_app_errors(p_error_number            => c_error_number,
                                                   p_message_code            => 'SYS_ZERO_DIVIDE',
                                                   p_message                 => p_message || ' ' ||
                                                                                get_message_text('SYS_ZERO_DIVIDE'),
                                                   p_created_by              => p_created_by,
                                                   p_package_name            => p_package_name,
                                                   p_procedure_function_name => p_procedure_function_name);
    when e_too_many_rows then
      g_err_line_id := create_sys_raise_app_errors(p_error_number            => c_error_number,
                                                   p_message_code            => 'SYS_TOO_MANY_ROWS',
                                                   p_message                 => p_message || ' ' ||
                                                                                get_message_text('SYS_TOO_MANY_ROWS'),
                                                   p_created_by              => p_created_by,
                                                   p_package_name            => p_package_name,
                                                   p_procedure_function_name => p_procedure_function_name);
    when e_too_large_for_column then
      g_err_line_id := create_sys_raise_app_errors(p_error_number            => c_error_number,
                                                   p_message_code            => 'SYS_TOO_LARGE_FOR_COLUMNL',
                                                   p_message                 => get_message_text('SYS_TOO_LARGE_FOR_COLUMNL') --|| ' ' || p_message
                                                  ,
                                                   p_created_by              => p_created_by,
                                                   p_package_name            => p_package_name,
                                                   p_procedure_function_name => p_procedure_function_name);
    
  end raise_sys_others_error;

end sys_raise_app_error_pkg;
/
spool off

exit
