WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_REGISTER_BM_PKG.log

create or replace package SYS_REGISTER_BM_PKG is

  -- Author  : ZHOUHAO
  -- Created : 2011/6/17 10:19:09
  -- Purpose : 

  -- Public type declarations

  -- Public constant declarations

  -- Public variable declarations

  -- Public function and procedure declarations
  procedure register_bm(p_service_name varchar2, p_bm_name varchar2);
  procedure register_bm(p_function_id number, p_bm_name varchar2);
end SYS_REGISTER_BM_PKG;
/
create or replace package body SYS_REGISTER_BM_PKG is

  -- Private type declarations

  -- Private constant declarations

  -- Private variable declarations

  -- Function and procedure implementations

  procedure register_bm(p_service_name varchar2, p_bm_name varchar2) is
    v_service_id  number;
    v_function_id number;
    v_count_flag  number;
  begin
    select service_id
      into v_service_id
      from sys_service t
     where t.service_name = p_service_name;
    for v_functions in (select function_id
                          from sys_function f
                         where f.service_id = v_service_id) loop
      v_function_id := v_functions.function_id;
      select count(1)
        into v_count_flag
        from sys_function_bm_access g
       where g.function_id = v_function_id
         and g.bm_name = p_bm_name;
      if v_count_flag != 0 then
        exit;
      else
        insert into sys_function_bm_access
          (access_id,
           function_id,
           bm_name,
           insert_option,
           update_option,
           query_option,
           delete_option,
           execute_option,
           created_by,
           creation_date,
           last_updated_by,
           last_update_date)
        values
          (sys_function_bm_access_s.nextval,
           v_function_id,
           p_bm_name,
           'Y',
           'Y',
           'Y',
           'Y',
           'Y',
           1,
           sysdate,
           1,
           sysdate);
      end if;
    end loop;
    exception 
      when no_data_found then
        null;
  end;
  
  procedure register_bm(p_function_id number, p_bm_name varchar2) is
    v_count_flag number;
  begin
    select count(1)
      into v_count_flag 
      from sys_function_bm_access g
     where g.function_id = p_function_id
       and g.bm_name = p_bm_name;
    if v_count_flag != 0 then
      null;
    else
      insert into sys_function_bm_access
        (access_id,
         function_id,
         bm_name,
         insert_option,
         update_option,
         query_option,
         delete_option,
         execute_option,
         created_by,
         creation_date,
         last_updated_by,
         last_update_date)
      values
        (sys_function_bm_access_s.nextval,
         p_function_id,
         p_bm_name,
         'Y',
         'Y',
         'Y',
         'Y',
         'Y',
         1,
         sysdate,
         1,
         sysdate);
    end if;
  end;
end SYS_REGISTER_BM_PKG;
/

spool off

exit