WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_ROLE_FUNCTION_PKG .log

create or replace package SYS_ROLE_FUNCTION_PKG is

  procedure add_role_function(p_role_code     varchar2,
                              p_function_code varchar2,
                              p_sequence     number,
                              p_expanded      varchar2,
                              p_start_date    date,
                              p_end_date      date,
                              p_created_by    number);

end SYS_ROLE_FUNCTION_PKG;
/
create or replace package body SYS_ROLE_FUNCTION_PKG is

  procedure add_role_function(p_role_code       varchar2,
                              p_function_code   varchar2,
                              p_sequence       number,
                              p_expanded        varchar2,
                              p_start_date      date,
                              p_end_date        date,
                              p_created_by      number) is
  
    v_role_id     number;
    v_function_id number;
 
  begin
    select SYS_ROLE.role_id
      into v_role_id
      from SYS_ROLE
     where SYS_ROLE.role_code = p_role_code;
    select sys_function.function_id
      into v_function_id
      from sys_function
     where sys_function.Function_Code = p_function_code;
  
    insert into SYS_ROLE_FUNCTION
    values
      (v_role_id,
       v_function_id,
       p_sequence,
       p_expanded,
       p_start_date,
       p_end_date,
       p_created_by,
       sysdate,
       p_created_by,
       sysdate);
    exception 
      when no_data_found then 
        null;
      when others then 
        null;
  end;
end SYS_ROLE_FUNCTION_PKG;
/
spool off

exit
