WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool sys_role_pkg.log

CREATE OR REPLACE PACKAGE "SYS_ROLE_PKG" is

  -- Author  : Bobo
  -- Created : 2009-3-31 13:57:11
  -- Purpose :

  function get_role_id return number;

  -- ɫ
  procedure insert_sys_role(p_role_code   varchar2,
                            p_role_name   varchar2,
                            p_description varchar2,
                            p_created_by  number,
                            p_start_date  date,
                            p_role_id     number,
                            p_end_date    date default null);

  --½ɫ
  procedure update_sys_role(p_role_id         number,
                            p_role_name       varchar2,
                            p_description     varchar2,
                            p_last_updated_by number,
                            p_start_date      date,
                            p_end_date        date);

  procedure delete_sys_role(p_role_code in varchar2);

  --嵱ǰɫµĹ
  procedure insert_function_group(p_role_id           number,
                                  p_function_group_id number,
                                  p_start_date        date,
                                  p_end_date          date,
                                  p_layout_sequence   number,
                                  p_created_by        number);

  --½ɫ
  procedure update_function_group(p_rowid             varchar2,
                                  p_function_group_id number,
                                  p_start_date        date,
                                  p_end_date          date,
                                  p_layout_sequence   number,
                                  p_last_updated_by   number);
  --ɾǰɫµĹ
  procedure remove_function_group(p_role_id           number,
                                  p_function_group_id number);

  --õǰɫǰµĹܴ ǷЧ
  --p_enabled_flag : Y(Ч) N(Ч)
  procedure set_sys_role_func_exclude_item(p_enabled_flag      varchar2,
                                           p_role_id           number,
                                           p_function_group_id number,
                                           p_function_id       number,
                                           p_created_by        number,
                                           p_last_updated_by   number);

  -- ɫ
  procedure sys_role_load(p_role_code       varchar2,
                          p_language_code   varchar2,
                          p_role_name       varchar2,
                          p_description     varchar2,
                          p_function_code_1 varchar2 default null);

  procedure delete_sys_role_load(p_role_code varchar2);

  procedure add_function_group_load(p_role_code           varchar2,
                                    p_function_group_code varchar2,
                                    p_start_date          date,
                                    p_end_date            date);

  procedure remove_function_group_load(p_role_code           varchar2,
                                       p_function_group_code varchar2);

end sys_role_pkg;


 
/
CREATE OR REPLACE PACKAGE BODY "SYS_ROLE_PKG" is
  e_end_date_error exception;
  e_null_check exception;
  e_layout_sequence_duplicate exception;

  function get_role_id return number is
    v_role_id sys_role.role_id%type;
  begin
    select sys_role_s.nextval into v_role_id from dual;
    return v_role_id;
  end get_role_id;

  procedure insert_sys_role(p_role_code   varchar2,
                            p_role_name   varchar2,
                            p_description varchar2,
                            p_created_by  number,
                            p_start_date  date,
                            p_role_id     number,
                            p_end_date    date default null) is
    v_description_id sys_role.description_id%type;
    v_role_name_id   sys_role.role_name_id%type;

  begin
    --step 1 insert  sys_function
    if p_start_date > nvl(p_end_date,
                          p_start_date) then
      raise e_end_date_error;
    end if;

    if p_role_name is null or p_description is null or p_start_date is null then
      raise e_null_check;
    end if;

    v_description_id := fnd_description_pkg.get_fnd_description_id;
    v_role_name_id   := fnd_description_pkg.get_fnd_description_id;

    insert into sys_role
      (role_id,
       role_code,
       start_date,
       end_date,
       last_updated_by,
       last_update_date,
       created_by,
       creation_date,
       description_id,
       role_name_id)
    values
      (p_role_id,
       upper(p_role_code),
       p_start_date,
       p_end_date,
       p_created_by,
       sysdate,
       p_created_by,
       sysdate,
       v_description_id,
       v_role_name_id);

    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                               p_ref_table        => 'SYS_ROLE',
                                               p_ref_field        => 'DESCRIPTION_ID',
                                               p_description_text => p_description,
                                               p_function_name    => '',
                                               p_created_by       => p_created_by,
                                               p_last_updated_by  => p_created_by,
                                               p_language_code    => userenv('lang'));

    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_role_name_id,
                                               p_ref_table        => 'SYS_ROLE',
                                               p_ref_field        => 'ROLE_NAME_ID',
                                               p_description_text => p_role_name,
                                               p_function_name    => '',
                                               p_created_by       => p_created_by,
                                               p_last_updated_by  => p_created_by,
                                               p_language_code    => userenv('lang'));

  exception
    when e_null_check then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_ROLE_NOT_NULL_ERROR',
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'sys_role_pkg',
                                                      p_procedure_function_name => 'insert_sys_role');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_end_date_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_END_DATE_ERROR',
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'sys_role_pkg',
                                                      p_procedure_function_name => 'insert_sys_role');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when dup_val_on_index then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_ROLE_UNIQUE_ERROR',
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'sys_role_pkg',
                                                      p_procedure_function_name => 'insert_sys_role');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_created_by,
                                                     p_package_name            => 'sys_role_pkg',
                                                     p_procedure_function_name => 'insert_sys_role');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end insert_sys_role;

  --½ɫ
  procedure update_sys_role(p_role_id         number,
                            p_role_name       varchar2,
                            p_description     varchar2,
                            p_last_updated_by number,
                            p_start_date      date,
                            p_end_date        date) is
    v_description_id sys_role.description_id%type;
    v_role_name_id   sys_role.role_name_id%type;
  begin
    if p_role_name is null or p_description is null or p_start_date is null then
      raise e_null_check;
    end if;

    if p_start_date > nvl(p_end_date,
                          p_start_date) then
      raise e_end_date_error;
    end if;
    select description_id,
           role_name_id
      into v_description_id,
           v_role_name_id
      from sys_role
     where role_id = p_role_id;

    update sys_role
       set start_date       = p_start_date,
           end_date         = p_end_date,
           last_update_date = sysdate,
           last_updated_by  = p_last_updated_by
     where role_id = p_role_id;

    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                               p_ref_table        => 'SYS_ROLE',
                                               p_ref_field        => 'DESCRIPTION_ID',
                                               p_description_text => p_description,
                                               p_function_name    => '',
                                               p_created_by       => p_last_updated_by,
                                               p_last_updated_by  => p_last_updated_by,
                                               p_language_code    => userenv('lang'));

    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_role_name_id,
                                               p_ref_table        => 'SYS_ROLE',
                                               p_ref_field        => 'ROLE_NAME_ID',
                                               p_description_text => p_role_name,
                                               p_function_name    => '',
                                               p_created_by       => p_last_updated_by,
                                               p_last_updated_by  => p_last_updated_by,
                                               p_language_code    => userenv('lang'));

  exception
    when e_null_check then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_ROLE_NOT_NULL_ERROR',
                                                      p_created_by              => p_last_updated_by,
                                                      p_package_name            => 'sys_role_pkg',
                                                      p_procedure_function_name => 'update_sys_role');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_end_date_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_END_DATE_ERROR',
                                                      p_created_by              => p_last_updated_by,
                                                      p_package_name            => 'sys_role_pkg',
                                                      p_procedure_function_name => 'update_sys_role');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_last_updated_by,
                                                     p_package_name            => 'sys_role_pkg',
                                                     p_procedure_function_name => 'update_sys_role');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end update_sys_role;

  procedure delete_sys_role(p_role_code varchar2) is
    v_desc_id      sys_role.description_id%type;
    v_role_name_id sys_role.role_name_id%type;
    v_role_id      sys_role.role_id%type;
  begin
    select a.description_id,
           a.role_name_id,
           a.role_id
      into v_desc_id,
           v_role_name_id,
           v_role_id
      from sys_role a
     where a.role_code = upper(p_role_code);

    --ɾ
    fnd_description_pkg.delete_fnd_descriptions(p_description_id => v_desc_id);
    fnd_description_pkg.delete_fnd_descriptions(p_description_id => v_role_name_id);

    --ɾɫµĹ
    delete from sys_role_function_group g where g.role_id = v_role_id;

    --ɾɫ
    delete from sys_role where role_code = upper(p_role_code);
  exception
    when no_data_found then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_ROLE_ROLE_NOT_FOUND',
                                                      p_created_by              => -1,
                                                      p_package_name            => 'sys_role_pkg',
                                                      p_procedure_function_name => 'delete_sys_role');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end delete_sys_role;

  procedure layout_sequence_check(p_role_id         number,
                                  p_layout_sequence number) is
    v_count number;
  begin
    if p_layout_sequence is not null then
      select count(1)
        into v_count
        from sys_role_function_group g
       where g.role_id = p_role_id
         and g.layout_sequence = p_layout_sequence;
      if v_count > 1 then
        raise e_layout_sequence_duplicate;
      end if;
    end if;
  end layout_sequence_check;

  procedure insert_function_group(p_role_id           number,
                                  p_function_group_id number,
                                  p_start_date        date,
                                  p_end_date          date,
                                  p_layout_sequence   number,
                                  p_created_by        number) is
  begin
    if p_start_date > nvl(p_end_date,
                          p_start_date) then
      raise e_end_date_error;
    end if;

    insert into sys_role_function_group
      (role_id,
       function_group_id,
       start_date,
       end_date,
       created_by,
       creation_date,
       last_updated_by,
       last_update_date,
       layout_sequence)
    values
      (p_role_id,
       p_function_group_id,
       p_start_date,
       p_end_date,
       p_created_by,
       sysdate,
       p_created_by,
       sysdate,
       p_layout_sequence);

    layout_sequence_check(p_role_id         => p_role_id,
                          p_layout_sequence => p_layout_sequence);
  exception
    when e_layout_sequence_duplicate then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_ROLE_LAYOUT_SEQUENCE_UNIQUE_ERROR',
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'sys_role_pkg',
                                                      p_procedure_function_name => 'insert_function_group');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_end_date_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_END_DATE_ERROR',
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'sys_role_pkg',
                                                      p_procedure_function_name => 'insert_function_group');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when dup_val_on_index then
      --鲻ظ
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_ROLE_UNIQUE2_ERROR',
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'sys_role_pkg',
                                                      p_procedure_function_name => 'insert_function_group');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_created_by,
                                                     p_package_name            => 'sys_role_pkg',
                                                     p_procedure_function_name => 'insert_function_group');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end insert_function_group;

  --½ɫ
  procedure update_function_group(p_rowid             varchar2,
                                  p_function_group_id number,
                                  p_start_date        date,
                                  p_end_date          date,
                                  p_layout_sequence   number,
                                  p_last_updated_by   number) is
    v_role_id sys_role_function_group.role_id%type;
  begin
    if p_start_date > nvl(p_end_date,
                          p_start_date) then
      raise e_end_date_error;
    end if;
    select role_id
      into v_role_id
      from sys_role_function_group
     where rowid = p_rowid;

    update sys_role_function_group a
       set a.function_group_id = p_function_group_id,
           a.last_updated_by   = p_last_updated_by,
           a.last_update_date  = sysdate,
           a.start_date        = p_start_date,
           a.end_date          = p_end_date,
           layout_sequence     = p_layout_sequence
     where rowid = p_rowid;

    layout_sequence_check(p_role_id         => v_role_id,
                          p_layout_sequence => p_layout_sequence);
  exception
    when e_layout_sequence_duplicate then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_ROLE_LAYOUT_SEQUENCE_UNIQUE_ERROR',
                                                      p_created_by              => p_last_updated_by,
                                                      p_package_name            => 'sys_role_pkg',
                                                      p_procedure_function_name => 'update_function_group');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_end_date_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_END_DATE_ERROR',
                                                      p_created_by              => p_last_updated_by,
                                                      p_package_name            => 'sys_role_pkg',
                                                      p_procedure_function_name => 'update_function_group');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when dup_val_on_index then
      --鲻ظ
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_ROLE_UNIQUE2_ERROR',
                                                      p_created_by              => p_last_updated_by,
                                                      p_package_name            => 'sys_role_pkg',
                                                      p_procedure_function_name => 'update_function_group');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_last_updated_by,
                                                     p_package_name            => 'sys_role_pkg',
                                                     p_procedure_function_name => 'update_function_group');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end update_function_group;

  procedure remove_function_group(p_role_id           number,
                                  p_function_group_id number) is
    v_role_id           sys_role.role_id%type;
    v_function_group_id sys_function_group.function_group_id%type;
  begin
    select role_id into v_role_id from sys_role where role_id = p_role_id;

    select function_group_id
      into v_function_group_id
      from sys_function_group
     where function_group_id = p_function_group_id;

    delete from sys_role_function_exclude_item
     where role_id = v_role_id
       and function_group_id = v_function_group_id;

    delete sys_role_function_group
     where role_id = v_role_id
       and function_group_id = v_function_group_id;
  exception
    when no_data_found then
      null;
  end remove_function_group;

  --õǰɫǰµĹܴ ǷЧ
  procedure set_sys_role_func_exclude_item(p_enabled_flag      varchar2,
                                           p_role_id           number,
                                           p_function_group_id number,
                                           p_function_id       number,
                                           p_created_by        number,
                                           p_last_updated_by   number) is
    v_exists number;
  begin
    if p_enabled_flag = 'N' then
      
      delete from sys_role_function_exclude_item
       where role_id = p_role_id
         and function_group_id = p_function_group_id
         and function_id = p_function_id;
    elsif p_enabled_flag = 'Y' then

      begin
        select 1
          into v_exists
          from sys_role_function_exclude_item
         where role_id = p_role_id
           and function_group_id = p_function_group_id
           and function_id = p_function_id;
      exception
        when no_data_found then
          insert into sys_role_function_exclude_item
            (role_id,
             function_group_id,
             function_id,
             last_update_date,
             last_updated_by,
             creation_date,
             created_by)
          values
            (p_role_id,
             p_function_group_id,
             p_function_id,
             sysdate,
             p_created_by,
             sysdate,
             p_last_updated_by);
      end;
    end if;

  end set_sys_role_func_exclude_item;

  --ɫ
  procedure sys_role_load(p_role_code       varchar2,
                          p_language_code   varchar2,
                          p_role_name       varchar2,
                          p_description     varchar2,
                          p_function_code_1 varchar2 default null) is
    v_role_id        sys_role.role_id%type;
    v_description_id sys_role.description_id%type;
    v_role_name_id   sys_role.role_name_id%type;

  begin
    --step 1 insert into sys_function
    begin
      select s.role_name_id,
             s.description_id
        into v_role_name_id,
             v_description_id
        from sys_role s
       where role_code = upper(p_role_code);
    exception
      when no_data_found then

        v_role_id        := get_role_id;
        v_role_name_id   := fnd_description_pkg.get_fnd_description_id;
        v_description_id := fnd_description_pkg.get_fnd_description_id;

        insert into sys_role
          (role_id,
           role_code,
           start_date,
           end_date,
           last_updated_by,
           last_update_date,
           created_by,
           creation_date,
           role_name_id,
           description_id)
        values
          (v_role_id,
           upper(p_role_code),
           sysdate,
           null,
           1,
           sysdate,
           1,
           sysdate,
           v_role_name_id,
           v_description_id);

    end;

    --step 2 insert description
    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_description_id,
                                               p_ref_table        => 'SYS_ROLE',
                                               p_ref_field        => 'DESCRIPTION_ID',
                                               p_description_text => p_description,
                                               p_function_name    => p_function_code_1,
                                               p_created_by       => 1,
                                               p_last_updated_by  => 1,
                                               p_language_code    => p_language_code);

    fnd_description_pkg.reset_fnd_descriptions(p_description_id   => v_role_name_id,
                                               p_ref_table        => 'SYS_ROLE',
                                               p_ref_field        => 'ROLE_NAME_ID',
                                               p_description_text => p_role_name,
                                               p_function_name    => p_function_code_1,
                                               p_created_by       => 1,
                                               p_last_updated_by  => 1,
                                               p_language_code    => p_language_code);

  end sys_role_load;

  procedure delete_sys_role_load(p_role_code varchar2) is
    v_desc_id      sys_role.description_id%type;
    v_role_name_id sys_role.role_name_id%type;
    v_role_id      sys_role.role_id%type;
  begin
    select a.description_id,
           a.role_name_id,
           a.role_id
      into v_desc_id,
           v_role_name_id,
           v_role_id
      from sys_role a
     where a.role_code = upper(p_role_code);

    --ɾ
    fnd_description_pkg.delete_fnd_descriptions(p_description_id => v_desc_id);
    fnd_description_pkg.delete_fnd_descriptions(p_description_id => v_role_name_id);

    --ɾɫµĹ
    delete from sys_role_function_group g where g.role_id = v_role_id;

    --ɾɫ
    delete from sys_role where role_code = upper(p_role_code);
  exception
    when no_data_found then
      null;
  end delete_sys_role_load;

  procedure add_function_group_load(p_role_code           varchar2,
                                    p_function_group_code varchar2,
                                    p_start_date          date,
                                    p_end_date            date) is
    v_role_id           sys_role.role_id%type;
    v_function_group_id sys_function_group.function_group_id%type;
    v_exists            number;
  begin
    select role_id
      into v_role_id
      from sys_role
     where role_code = upper(p_role_code);

    select function_group_id
      into v_function_group_id
      from sys_function_group
     where function_group_code = upper(p_function_group_code);

    begin
      select 1
        into v_exists
        from sys_role_function_group
       where role_id = v_role_id
         and function_group_id = v_function_group_id;

      update sys_role_function_group
         set start_date = p_start_date,
             end_date   = p_end_date
       where role_id = v_role_id
         and function_group_id = v_function_group_id;

    exception
      when no_data_found then
        insert into sys_role_function_group
          (role_id,
           function_group_id,
           start_date,
           end_date,
           created_by,
           creation_date,
           last_updated_by,
           last_update_date)
        values
          (v_role_id,
           v_function_group_id,
           sysdate,
           null,
           1,
           sysdate,
           1,
           sysdate);
    end;
  exception
    when no_data_found then
      null;
  end add_function_group_load;

  procedure remove_function_group_load(p_role_code           varchar2,
                                       p_function_group_code varchar2) is
    v_role_id           sys_role.role_id%type;
    v_function_group_id sys_function_group.function_group_id%type;
  begin
    select role_id
      into v_role_id
      from sys_role
     where role_code = upper(p_role_code);

    select function_group_id
      into v_function_group_id
      from sys_function_group
     where function_group_code = upper(p_function_group_code);

    delete sys_role_function_group
     where role_id = v_role_id
       and function_group_id = v_function_group_id;
  exception
    when no_data_found then
      null;
  end remove_function_group_load;

end sys_role_pkg;
/
spool off

exit
