WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool sys_runtime_archive_pkg.log

create or replace package sys_runtime_archive_pkg is

    -- Author  : ZHOUHAO
    -- Created : 2011/10/18 9:17:27
    -- Purpose : runtimeݹ鵵

    --ڹ鵵detailе
    procedure archive_detail;

    --ڹ鵵recordе
    procedure archive_record;

    --ڹ鵵exception_logе    
    procedure archive_exp_log;

    --ڹ鵵record,detail,exp_logе    
    procedure archive_total;

end sys_runtime_archive_pkg;
/
create or replace package body sys_runtime_archive_pkg is

    --ڹ鵵detailе
    procedure archive_detail is
        v_date date := trunc(sysdate);
    begin
        insert into sys_runtime_request_stat_day
            (select trunc(r.enter_time),
                    r.url,
                    d.name,
                    count(*),
                    avg(d.duration),
                    max(d.duration),
                    min(d.duration),
                    median(d.duration)
               from sys_runtime_request_detail d,
                    sys_runtime_request_record r
              where d.request_id = r.request_id
                and r.enter_time < v_date
              group by trunc(r.enter_time), r.url, d.name);
        delete from sys_runtime_request_detail r
         where r.enter_time < v_date;
    exception
        when no_data_found then
            sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_RUNTIME_NO_DETAL_RECORD_ERROR',
                                                            p_created_by              => 1,
                                                            p_package_name            => 'sys_runtime_pkg',
                                                            p_procedure_function_name => 'archive_detail');
        when others then
            sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                        sqlerrm,
                                                           p_created_by              => 1,
                                                           p_package_name            => 'sys_runtime_pkg',
                                                           p_procedure_function_name => 'archive_detail');
    end archive_detail;

    --ڹ鵵recordе
    procedure archive_record is
        v_date date := trunc(sysdate);
    begin
        insert into sys_runtime_req_rec_archive
            (select *
               from sys_runtime_request_record t
              where t.enter_time < v_date);
        delete from sys_runtime_request_record t
         where t.enter_time < v_date;
    exception
        when no_data_found then
            sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_RUNTIME_NO_RECORD_ERROR',
                                                            p_created_by              => 1,
                                                            p_package_name            => 'sys_runtime_pkg',
                                                            p_procedure_function_name => 'archive_record');
            raise_application_error(sys_raise_app_error_pkg.c_error_number,
                                    sys_raise_app_error_pkg.g_err_line_id);
        when others then
            sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                        sqlerrm,
                                                           p_created_by              => 1,
                                                           p_package_name            => 'sys_runtime_pkg',
                                                           p_procedure_function_name => 'archive_record');
    end archive_record;

    --ڹ鵵exception_logе    
    procedure archive_exp_log is
        v_date date := trunc(sysdate);
    begin
        insert into sys_runtime_exp_log_archive
            (select *
               from sys_runtime_exception_log t
              where t.creation_time < v_date);
        delete from sys_runtime_exception_log t
         where t.creation_time < v_date;
    exception
        when no_data_found then
            sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_RUNTIME_NO_RECORD_ERROR',
                                                            p_created_by              => 1,
                                                            p_package_name            => 'sys_runtime_pkg',
                                                            p_procedure_function_name => 'archive_exp_log');
            raise_application_error(sys_raise_app_error_pkg.c_error_number,
                                    sys_raise_app_error_pkg.g_err_line_id);
        when others then
            sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                        sqlerrm,
                                                           p_created_by              => 1,
                                                           p_package_name            => 'sys_runtime_pkg',
                                                           p_procedure_function_name => 'archive_exp_log');
    end archive_exp_log;

    procedure archive_total is
    
    begin
        sys_analytics_pkg.gatherDataForDay(trunc(sysdate - 1));
        archive_detail;
        archive_record;
        archive_exp_log;
    end archive_total;

end sys_runtime_archive_pkg;
/
spool off

exit