WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool sys_service_pkg.log
create or replace package sys_service_pkg as

  procedure sys_service_load(p_service           varchar2,
                             p_title              varchar2,
                             p_is_access_checked number,
                             p_is_login_requied  number,
                             p_is_system_access  number) ;

end sys_service_pkg;
/
create or replace package body sys_service_pkg as

  procedure sys_service_load(p_service           varchar2,
                             p_title              varchar2,
                             p_is_access_checked number,
                             p_is_login_requied  number,
                             p_is_system_access  number) is
    v_count_flag number;

  begin
    select count(1) into v_count_flag from sys_service t where t.service_name = p_service;
    if(v_count_flag = 0) then
      insert into sys_service
        (service_id,
         service_name,
         is_entry_page,
         is_access_checked,
         is_login_required,
         title,
         creation_date,
         last_update_date,
         created_by,
         last_updated_by,
         is_system_access)
      values
        (sys_service_s.nextval,
         p_service,
         0,
         p_is_access_checked,
         p_is_login_requied,
         p_title,
         sysdate,
         sysdate,
         1,
         1,
         p_is_system_access
        );
      else 
        null;
      end if;
  end;
end sys_service_pkg;
/

spool off

exit