WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool SYS_SSO_LOGIN_SESSION_PKG.log

create or replace package sys_sso_login_session_pkg is

  -- Author  : BOBO,Alan Lee
  -- Created : 2010-06-17 10:01:47
  -- Purpose :

  --SSO½

  --SSO Login Session
  function create_sso_login_session(p_user_id            in number,
                                    p_role_id            in number,
                                    p_company_id         in number,
                                    p_function_id        in number,
                                    p_user_language      in varchar2,
                                    p_app_ip_address     in varchar2,
                                    p_client_ip_address  in varchar2,
                                    p_machine_serial     in varchar2,
                                    p_note               in varchar2,
                                    p_encrypted_password in varchar2 default null)
    return varchar2;

  --ɾSSO Login Session  
  procedure delete_sso_login_session(p_encrypted_sso_session_id in varchar2);

end sys_sso_login_session_pkg;
/
create or replace package body sys_sso_login_session_pkg is

  --SSO Login Session
  function create_sso_login_session(p_user_id            in number,
                                    p_role_id            in number,
                                    p_company_id         in number,
                                    p_function_id        in number,
                                    p_user_language      in varchar2,
                                    p_app_ip_address     in varchar2,
                                    p_client_ip_address  in varchar2,
                                    p_machine_serial     in varchar2,
                                    p_note               in varchar2,
                                    p_encrypted_password in varchar2 default null)
    return varchar2 is
    v_sso_login_session_id     number;
    v_encrypted_sso_session_id varchar2(100);
    pragma autonomous_transaction;
  begin
  
    select sys_sso_login_session_s.nextval
      into v_sso_login_session_id
      from dual;
  
    v_encrypted_sso_session_id := sys_crypt.des_encrypt(to_char(v_sso_login_session_id));
  
    insert into sys_sso_login_session
      (sso_login_session_id,
       encrypted_sso_session_id,
       user_id,
       role_id,
       company_id,
       function_id,
       user_language,
       encrypted_password,
       app_ip_address,
       client_ip_address,
       machine_serial,
       login_time,
       note,
       last_update_date,
       last_updated_by,
       creation_date,
       created_by)
    values
      (v_sso_login_session_id,
       v_encrypted_sso_session_id,
       p_user_id,
       p_role_id,
       p_company_id,
       p_function_id,
       p_user_language,
       p_encrypted_password,
       p_app_ip_address,
       p_client_ip_address,
       p_machine_serial,
       sysdate,
       p_note,
       sysdate,
       1,
       sysdate,
       1);
  
    commit;
  
    return v_encrypted_sso_session_id;
  
  exception
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => 1,
                                                     p_package_name            => 'sys_sso_login_session_pkg',
                                                     p_procedure_function_name => 'create_sso_login_session');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    
  end create_sso_login_session;

  --ɾSSO Login Session
  procedure delete_sso_login_session(p_encrypted_sso_session_id in varchar2) is
  
  begin
  
    delete from sys_sso_login_session
     where encrypted_sso_session_id = p_encrypted_sso_session_id;
  
  exception
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => 1,
                                                     p_package_name            => 'sys_sso_login_session_pkg',
                                                     p_procedure_function_name => 'delete_sso_login_session');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    
  end delete_sso_login_session;

end sys_sso_login_session_pkg;
/
spool off

exit
