WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool sys_user_pkg.log

create or replace package sys_user_pkg is

  -- Author  : Zhanglei
  -- Created : 2009-3-10 10:21:38
  -- Purpose :

  --***********************************************************/*
  --  쳣
  --        e_employee_duplicate      Աظ
  --        e_end_date_error          ʼڴڽ
  --        e_password_complex_control    ڼ
  --        e_password_min_length          볤̫
  --        e_old_password_error     ԭ
  --***********************************************************/*
  
  e_employee_duplicate exception;
  e_end_date_error exception;
  e_password_complex_control exception; --븴
  e_password_min_length exception; --С
  e_old_password_error exception; --ԭ
  
  
  --У
  procedure password_rule_check(p_new_password varchar2);
  
  function get_user_id return number;

  --***********************************************************/*
  -- û
  /* parameter :
                 p_user_name            varchar2,     û
                 p_user_password     varchar2,  û
                 p_start_date           date,  ûЧڴ
                 p_end_date             date,  ûЧڵ
                 p_last_logon_date      date,  ûһε¼
                 p_description          varchar2,  û
                 p_password_lifespan_check      number,  Чʽ1-  2-½  3-
                 p_password_lifespan    number,  Ч¼
                 p_employee_id          number,   ûӦԱid
                 p_customer_id          number,   ûӦͻid
                 p_vender_id            number,   ûӦӦid
                 p_frozen_flag          varchar2, ־
                 p_frozen_date          date,     
                 p_password_start_date  date,     Чڴ
                 p_last_updated_by      number,   whoֶ
                 p_created_by           number    whoֶ
  */
  --************************************************************
  procedure insert_sys_user(p_user_name               varchar2,
                            p_user_password           varchar2,
                            p_start_date              date,
                            p_end_date                date,
                            p_description             varchar2,
                            p_password_lifespan_check number,
                            p_password_lifespan       number,
                            p_employee_id             number,
                            p_customer_id             number,
                            p_vender_id               number,
                            p_frozen_flag             varchar2,
                            p_frozen_date             date,
                            p_password_start_date     date,
                            p_last_updated_by         number,
                            p_created_by              number,
                            p_ip_address              varchar2);

  procedure update_sys_user(p_user_id                 number,
                            p_start_date              date,
                            p_end_date                date,
                            p_description             varchar2,
                            p_password_lifespan_check number, --Чʽ1-  2-½  3-
                            p_password_lifespan       number,
                            p_employee_id             number,
                            p_customer_id             number,
                            p_vender_id               number,
                            p_frozen_flag             varchar2,
                            p_frozen_date             date,
                            p_last_updated_by         number);

  --************************************************************
  -- ϵͳԱ޸
  -- parameter :
  --             p_user_name ¼û
  --************************************************************
  procedure change_password_by_admin(p_user_id         number,
                                     p_password        varchar2,
                                     p_ip_address      varchar2,
                                     p_last_updated_by number);

  --û޸
  procedure change_password_by_owner(p_user_id      number,
                                     p_old_password varchar2,
                                     p_new_password varchar2,
                                     p_ip_address   varchar2);

  --************************************************************
  -- 
  -- parameter :
  --             p_user_name ¼û
  --************************************************************
  procedure reset_password(p_user_id         number,
                           p_ip_address      varchar2,
                           p_last_updated_by number);

  --************************************************************
  -- ûᡢⶳ
  -- parameter :
  --             p_user_name ¼û
  --             p_frozen_flag ־λ
  --             p_last_updated_by 
  --************************************************************
  procedure reset_frozen_flag(p_user_name       varchar2,
                              p_frozen_flag     varchar2,
                              p_last_updated_by number);

  --ûӵеĽɫ˾,һɾֻʧЧ
  procedure insert_sys_user_role_groups(p_user_id    number,
                                        p_role_id    number,
                                        p_company_id number,
                                        p_start_date date default sysdate,
                                        p_end_date   date default null,
                                        p_created_by number);

  --ûӵеĽɫ˾
  procedure update_sys_user_role_groups(p_user_role_group_id number,
                                        p_role_id            number,
                                        p_company_id         number,
                                        p_start_date         date default sysdate,
                                        p_end_date           date default null,
                                        p_last_updated_by    number);

  --û
  procedure add_user_load(p_user_name     varchar2,
                          p_user_password varchar2,
                          p_description   varchar2,
                          p_start_date    date default sysdate,
                          p_end_date      date default null);

  procedure add_user_role_load(p_user       varchar2,
                               p_role       varchar2,
                               p_start_date date default sysdate,
                               p_end_date   date default null);

end sys_user_pkg;
/
create or replace package body sys_user_pkg is
  

  --У
  procedure password_rule_check(p_new_password varchar2) is
  begin
    --ڼ
    if nvl(sys_parameter_pkg.value('USER_PASSWORD_COMPLEX_CONTROL'),
           'N') = 'Y' then
      if regexp_like(p_new_password,
                     '[0-9][a-zA-Z]|[a-zA-Z][0-9]') = false then
        raise e_password_complex_control;
      end if;
    end if;

    --볤̫
    if nvl(sys_parameter_pkg.value('USER_PASSWORD_MIN_LENGTH'),
           0) > length(p_new_password) then
      raise e_password_min_length;
    end if;

  end password_rule_check;

  --¼ûʷ
  procedure insert_user_pwd_changed_logs(p_changed_user_id   number,
                                         p_modify_type       varchar2,
                                         p_ip_address        varchar2,
                                         p_original_password varchar2,
                                         p_new_password      varchar2,
                                         p_created_by        number) is
  begin
    insert into sys_user_pwd_changed_logs
      (changed_user_id,
       modify_type,
       ip_address,
       original_password,
       new_password,
       created_by,
       creation_date,
       last_updated_by,
       last_update_date)
    values
      (p_changed_user_id,
       p_modify_type,
       p_ip_address,
       p_original_password,
       p_new_password,
       p_created_by,
       sysdate,
       p_created_by,
       sysdate);
  end insert_user_pwd_changed_logs;

  function get_user_id return number is
    v_user_id sys_user.user_id%type;
  begin
    select sys_user_s.nextval into v_user_id from dual;
    return v_user_id;
  end get_user_id;

  --***********************************************************/*
  /* parameter :
                 p_user_id              number,       ûid
                 p_user_name            varchar2,     û
                 p_user_password        varchar2,  û
                 p_start_date           date,  ûЧڴ
                 p_end_date             date,  ûЧڵ
                 p_last_logon_date      date,  ûһε¼
                 p_description          varchar2,  û
                 p_password_lifespan_check      number,  Чʽ1-  2-½  3-
                 p_password_lifespan    number,  Ч¼
                 p_employee_id          number,   ûӦԱid
                 p_customer_id          number,   ûӦͻid
                 p_vender_id            number,   ûӦӦid
                 p_frozen_flag          varchar2, ־
                 p_frozen_date          date,     
                 p_password_start_date  date,     Чڴ
                 p_last_updated_by      number,   whoֶ
                 p_created_by           number    whoֶ
  */
  --************************************************************
  procedure insert_sys_user(p_user_name               varchar2,
                            p_user_password           varchar2,
                            p_start_date              date,
                            p_end_date                date,
                            p_description             varchar2,
                            p_password_lifespan_check number,
                            p_password_lifespan       number,
                            p_employee_id             number,
                            p_customer_id             number,
                            p_vender_id               number,
                            p_frozen_flag             varchar2,
                            p_frozen_date             date,
                            p_password_start_date     date,
                            p_last_updated_by         number,
                            p_created_by              number,
                            p_ip_address              varchar2) is
    v_encrypted_foundation_passwd sys_user.encrypted_foundation_password%type;
    v_encrypted_user_password     sys_user.encrypted_user_password%type;
    v_user_id                     sys_user.user_id%type;
    v_password_lifespan_days      sys_user.password_lifespan_days%type;
    v_password_lifespan_access    sys_user.password_lifespan_access%type;

    --v_exists number;

    e_password_lifespan_null exception;
    e_password_lifespan_error exception;
  begin

    if p_start_date > nvl(p_end_date,
                          p_start_date) then
      raise e_end_date_error;
    end if;

    --һԱԶʺ
    /*begin
      select 1
        into v_exists
        from dual
       where exists
       (select 1 from sys_user s where s.employee_id = p_employee_id);
      raise e_employee_duplicate;
    exception
      when no_data_found then
        null;
    end;*/

    v_encrypted_user_password     := sys_login_pkg.md5(p_user_password);
    v_encrypted_foundation_passwd := v_encrypted_user_password;
    v_user_id                     := get_user_id;

    --Уڲ
    if p_password_lifespan_check in (1, 2) and p_password_lifespan is null then
      raise e_password_lifespan_null;
    end if;

    if p_password_lifespan_check = 1 then
      v_password_lifespan_days   := p_password_lifespan;
      v_password_lifespan_access := null;
    elsif p_password_lifespan_check = 2 then
      v_password_lifespan_days   := null;
      v_password_lifespan_access := p_password_lifespan;
    elsif p_password_lifespan_check = 3 then
      v_password_lifespan_days   := null;
      v_password_lifespan_access := null;
    else
      raise e_password_lifespan_error;
    end if;

    insert into sys_user
      (user_id,
       user_name,
       encrypted_foundation_password,
       encrypted_user_password,
       start_date,
       end_date,
       last_logon_date,
       description,
       password_lifespan_days,
       password_lifespan_access,
       employee_id,
       customer_id,
       vender_id,
       frozen_flag,
       frozen_date,
       password_start_date,
       last_update_date,
       last_updated_by,
       creation_date,
       created_by)
    values
      (v_user_id,
       upper(p_user_name),
       v_encrypted_foundation_passwd,
       v_encrypted_user_password,
       p_start_date,
       p_end_date,
       sysdate,
       p_description,
       v_password_lifespan_days,
       v_password_lifespan_access,
       p_employee_id,
       p_customer_id,
       p_vender_id,
       p_frozen_flag,
       p_frozen_date,
       p_password_start_date,
       sysdate,
       p_last_updated_by,
       sysdate,
       p_created_by);

		--ûʷ¼
    insert_user_pwd_changed_logs(p_changed_user_id   => v_user_id,
                                 p_modify_type       => 'SYS',
                                 p_ip_address        => p_ip_address,
                                 p_original_password => v_encrypted_user_password,
                                 p_new_password      => v_encrypted_user_password,
                                 p_created_by        => p_last_updated_by);
  exception
    when e_end_date_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_END_DATE_ERROR',
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'INSERT_SYS_USER');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_employee_duplicate then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_EMPLOYEE_DUPLICATE',
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'INSERT_SYS_USER');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_password_lifespan_null then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_PASSWORD_LIFESPAN_NULL',
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'INSERT_SYS_USER');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_password_lifespan_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_PASSWORD_LIFESPAN_ERROR',
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'INSERT_SYS_USER');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when dup_val_on_index then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_UNIQUE_ERROR',
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'INSERT_SYS_USER');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_created_by,
                                                     p_package_name            => 'SYS_USER_PKG',
                                                     p_procedure_function_name => 'INSERT_SYS_USER');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end insert_sys_user;

  procedure update_sys_user(p_user_id                 number,
                            p_start_date              date,
                            p_end_date                date,
                            p_description             varchar2,
                            p_password_lifespan_check number, --Чʽ1-  2-½  3-
                            p_password_lifespan       number,
                            p_employee_id             number,
                            p_customer_id             number,
                            p_vender_id               number,
                            p_frozen_flag             varchar2,
                            p_frozen_date             date,
                            p_last_updated_by         number) is
    v_password_lifespan_days   sys_user.password_lifespan_days%type;
    v_password_lifespan_access sys_user.password_lifespan_access%type;

    --v_exists number;

    e_password_lifespan_null exception;
    e_password_lifespan_error exception;
  begin

    if p_start_date > nvl(p_end_date,
                          p_start_date) then
      raise e_end_date_error;
    end if;

    --һԱԶʺ
    /*begin
      select 1
        into v_exists
        from dual
       where exists
       (select 1 from sys_user s where s.employee_id = p_employee_id);
      raise e_employee_duplicate;
    exception
      when no_data_found then
        null;
    end;*/

    --Уڲ
    if p_password_lifespan_check in (1, 2) and p_password_lifespan is null then
      raise e_password_lifespan_null;
    end if;

    if p_password_lifespan_check = 1 then
      v_password_lifespan_days   := p_password_lifespan;
      v_password_lifespan_access := null;
    elsif p_password_lifespan_check = 2 then
      v_password_lifespan_days   := null;
      v_password_lifespan_access := p_password_lifespan;
    elsif p_password_lifespan_check = 3 then
      v_password_lifespan_days   := null;
      v_password_lifespan_access := null;
    else
      raise e_password_lifespan_error;
    end if;

    update sys_user s
       set s.start_date             = p_start_date,
           s.end_date               = p_end_date,
           s.description            = p_description,
           password_lifespan_days   = v_password_lifespan_days,
           password_lifespan_access = v_password_lifespan_access,
           employee_id              = p_employee_id,
           customer_id              = p_customer_id,
           vender_id                = p_vender_id,
           frozen_flag              = p_frozen_flag,
           frozen_date              = p_frozen_date,
           s.last_update_date       = sysdate,
           s.last_updated_by        = p_last_updated_by
     where s.user_id = p_user_id;
  exception
    when e_end_date_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_END_DATE_ERROR',
                                                      p_created_by              => p_last_updated_by,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'UPDATE_SYS_USER');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_employee_duplicate then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_EMPLOYEE_DUPLICATE',
                                                      p_created_by              => p_last_updated_by,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'UPDATE_SYS_USER');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_password_lifespan_null then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_PASSWORD_LIFESPAN_NULL',
                                                      p_created_by              => p_last_updated_by,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'UPDATE_SYS_USER');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_password_lifespan_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_PASSWORD_LIFESPAN_ERROR',
                                                      p_created_by              => p_last_updated_by,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'UPDATE_SYS_USER');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_last_updated_by,
                                                     p_package_name            => 'SYS_USER_PKG',
                                                     p_procedure_function_name => 'UPDATE_SYS_USER');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end update_sys_user;

  --************************************************************
  -- ޸
  -- parameter :
  --             p_user_name ¼û
  --             p_password  
  --************************************************************
  procedure change_password_by_admin(p_user_id         number,
                                     p_password        varchar2,
                                     p_ip_address      varchar2,
                                     p_last_updated_by number) is
    v_passwd            sys_user.encrypted_user_password%type;
    v_original_password sys_user.encrypted_user_password%type;
  begin
    v_passwd := sys_login_pkg.md5(p_password);

    select encrypted_user_password
      into v_original_password
      from sys_user
     where user_id = p_user_id;

    password_rule_check(p_new_password => p_password);

    update sys_user
       set encrypted_foundation_password = v_passwd,
           encrypted_user_password       = v_passwd,
           password_start_date           = sysdate,
           last_update_date              = sysdate,
           last_updated_by               = p_last_updated_by
     where user_id = p_user_id;

    insert_user_pwd_changed_logs(p_changed_user_id   => p_user_id,
                                 p_modify_type       => 'SYS',
                                 p_ip_address        => p_ip_address,
                                 p_original_password => v_original_password,
                                 p_new_password      => v_passwd,
                                 p_created_by        => p_last_updated_by);
  exception
    when e_password_complex_control then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_PASSWORD_COMPLEX_CONTROL',
                                                      p_created_by              => p_last_updated_by,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'change_password_by_admin');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_password_min_length then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_PASSWORD_MIN_LENGTH',
                                                      p_created_by              => p_last_updated_by,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'change_password_by_admin',
                                                      p_token_1                 => '#NUM',
                                                      p_token_value_1           => sys_parameter_pkg.value('USER_PASSWORD_MIN_LENGTH'));
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_old_password_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_OLD_PASSWORD_ERROR',
                                                      p_created_by              => p_last_updated_by,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'change_password_by_admin');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_last_updated_by,
                                                     p_package_name            => 'SYS_USER_PKG',
                                                     p_procedure_function_name => 'change_password');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

  end change_password_by_admin;

  --û޸
  procedure change_password_by_owner(p_user_id      number,
                                     p_old_password varchar2,
                                     p_new_password varchar2,
                                     p_ip_address   varchar2) is
    v_passwd sys_user.encrypted_user_password%type;
  begin
    v_passwd := sys_login_pkg.md5(p_new_password);

    password_rule_check(p_new_password => p_new_password);

    --ԭ
    update sys_user
       set encrypted_user_password       = v_passwd,
           encrypted_foundation_password = v_passwd,
           password_start_date           = sysdate,
           last_update_date              = sysdate,
           last_updated_by               = p_user_id
     where encrypted_user_password = sys_login_pkg.md5(p_old_password)
       and user_id = p_user_id;
    if sql%rowcount = 0 then
      raise e_old_password_error;
    end if;

    insert_user_pwd_changed_logs(p_changed_user_id   => p_user_id,
                                 p_modify_type       => 'SYS',
                                 p_ip_address        => p_ip_address,
                                 p_original_password => sys_login_pkg.md5(p_old_password),
                                 p_new_password      => v_passwd,
                                 p_created_by        => p_user_id);
  exception
    when e_password_complex_control then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_PASSWORD_COMPLEX_CONTROL',
                                                      p_created_by              => p_user_id,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'change_password_by_owner');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_password_min_length then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_PASSWORD_MIN_LENGTH',
                                                      p_created_by              => p_user_id,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'change_password_by_owner',
                                                      p_token_1                 => '#NUM',
                                                      p_token_value_1           => sys_parameter_pkg.value('USER_PASSWORD_MIN_LENGTH'));
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when e_old_password_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_OLD_PASSWORD_ERROR',
                                                      p_created_by              => p_user_id,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'change_password_by_owner');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_user_id,
                                                     p_package_name            => 'SYS_USER_PKG',
                                                     p_procedure_function_name => 'change_password_by_owner');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);

  end change_password_by_owner;

  --************************************************************
  -- 
  -- parameter :
  --             p_user_name ¼û
  --************************************************************
  procedure reset_password(p_user_id         number,
                           p_ip_address      varchar2,
                           p_last_updated_by number) is
    v_passwd            sys_user.encrypted_user_password%type;
    v_user_name         sys_user.user_name%type;
    v_original_password sys_user.encrypted_user_password%type;
  begin
    v_passwd := sys_login_pkg.md5(v_user_name);

    select encrypted_user_password,
           user_name
      into v_original_password,
           v_user_name
      from sys_user
     where user_id = p_user_id;

    update sys_user
       set encrypted_foundation_password = v_passwd,
           encrypted_user_password       = v_passwd,
           last_update_date              = sysdate,
           last_updated_by               = p_last_updated_by
     where user_id = p_user_id;

    insert_user_pwd_changed_logs(p_changed_user_id   => p_user_id,
                                 p_modify_type       => 'SYS',
                                 p_ip_address        => p_ip_address,
                                 p_original_password => v_original_password,
                                 p_new_password      => v_passwd,
                                 p_created_by        => p_last_updated_by);
  exception
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_last_updated_by,
                                                     p_package_name            => 'SYS_USER_PKG',
                                                     p_procedure_function_name => 'reset_password');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end reset_password;

  --************************************************************
  -- ûᡢⶳ
  -- parameter :
  --             p_user_name ¼û
  --             p_frozen_flag ־λ
  --             p_last_updated_by 
  --************************************************************
  procedure reset_frozen_flag(p_user_name       varchar2,
                              p_frozen_flag     varchar2,
                              p_last_updated_by number) is
  begin
    update sys_user s
       set s.frozen_flag      = nvl(p_frozen_flag,
                                    'N'),
           s.last_update_date = sysdate,
           s.last_updated_by  = p_last_updated_by,
           s.frozen_date      = sysdate
     where s.user_name = p_user_name;

  exception
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_last_updated_by,
                                                     p_package_name            => 'SYS_USER_PKG',
                                                     p_procedure_function_name => 'reset_frozen_flag');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end reset_frozen_flag;

  --ûӵеĽɫ,һɾֻʧЧ
  procedure insert_sys_user_role_groups(p_user_id    number,
                                        p_role_id    number,
                                        p_company_id number,
                                        p_start_date date default sysdate,
                                        p_end_date   date default null,
                                        p_created_by number) is
  begin
    if p_start_date > nvl(p_end_date,
                          p_start_date) then
      raise e_end_date_error;
    end if;

    insert into sys_user_role_groups
      (user_role_group_id,
       user_id,
       role_id,
       start_date,
       end_date,
       created_by,
       creation_date,
       last_updated_by,
       last_update_date,
       company_id)
    values
      (sys_user_role_groups_s.nextval,
       p_user_id,
       p_role_id,
       p_start_date,
       p_end_date,
       p_created_by,
       sysdate,
       p_created_by,
       sysdate,
       p_company_id);

  exception
    when e_end_date_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_END_DATE_ERROR',
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'insert_sys_user_role_groups');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when dup_val_on_index then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_ROLE_UNIQUE_ERROR',
                                                      p_created_by              => p_created_by,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'insert_sys_user_role_groups');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when others then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message                 => dbms_utility.format_error_backtrace || ' ' ||
                                                                                  sqlerrm,
                                                     p_created_by              => p_created_by,
                                                     p_package_name            => 'SYS_USER_PKG',
                                                     p_procedure_function_name => 'insert_sys_user_role_groups');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end insert_sys_user_role_groups;

  --ûӵеĽɫ˾
  procedure update_sys_user_role_groups(p_user_role_group_id number,
                                        p_role_id            number,
                                        p_company_id         number,
                                        p_start_date         date default sysdate,
                                        p_end_date           date default null,
                                        p_last_updated_by    number) is
  begin
    if p_start_date > nvl(p_end_date,
                          p_start_date) then
      raise e_end_date_error;
    end if;
    update sys_user_role_groups rg
       set rg.start_date       = p_start_date,
           rg.end_date         = p_end_date,
           rg.last_updated_by  = p_last_updated_by,
           rg.last_update_date = sysdate,
           rg.role_id          = p_role_id,
           rg.company_id       = p_company_id
     where rg.user_role_group_id = p_user_role_group_id;

  exception
    when e_end_date_error then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_PARAMETER_END_DATE_ERROR',
                                                      p_created_by              => p_last_updated_by,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'update_sys_user_role_groups');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
    when dup_val_on_index then
      sys_raise_app_error_pkg.raise_user_define_error(p_message_code            => 'SYS_USER_ROLE_UNIQUE_ERROR',
                                                      p_created_by              => p_last_updated_by,
                                                      p_package_name            => 'SYS_USER_PKG',
                                                      p_procedure_function_name => 'update_sys_user_role_groups');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end update_sys_user_role_groups;

  --û
  procedure add_user_load(p_user_name     varchar2,
                          p_user_password varchar2,
                          p_description   varchar2,
                          p_start_date    date default sysdate,
                          p_end_date      date default null) is
    v_exists_flag    varchar2(1) := 'N';
    v_encrypted_pass varchar2(100);
  begin
    select 'Y'
      into v_exists_flag
      from sys_user su
     where su.user_name = upper(p_user_name);
  exception
    when no_data_found then
      v_encrypted_pass := sys_login_pkg.md5(p_user_password);
      insert into sys_user
        (user_id,
         user_name,
         encrypted_foundation_password,
         encrypted_user_password,
         start_date,
         end_date,
         last_logon_date,
         description,
         password_lifespan_days,
         password_lifespan_access,
         employee_id,
         customer_id,
         vender_id,
         last_update_date,
         last_updated_by,
         creation_date,
         created_by)
        select sys_user_s.nextval,
               upper(p_user_name),
               v_encrypted_pass,
               v_encrypted_pass,
               p_start_date,
               p_end_date,
               null,
               p_description,
               null,
               null,
               null,
               null,
               null,
               sysdate,
               1,
               sysdate,
               1
          from dual;
  end add_user_load;

  procedure add_user_role_load(p_user       varchar2,
                               p_role       varchar2,
                               p_start_date date default sysdate,
                               p_end_date   date default null) is
    v_existed_flag varchar2(1) := 'N';
    v_user_id      number;
    v_role_id      number;
  begin
    select su.user_id
      into v_user_id
      from sys_user su
     where su.user_name = upper(p_user);
    select sr.role_id
      into v_role_id
      from sys_role sr
     where sr.role_code = upper(p_role);
    begin
      select 'Y'
        into v_existed_flag
        from sys_user_role_groups surg
       where surg.role_id = v_role_id
         and surg.user_id = v_user_id;
    exception
      when no_data_found then
        insert into sys_user_role_groups
          (user_role_group_id,
           user_id,
           role_id,
           start_date,
           end_date,
           created_by,
           creation_date,
           last_updated_by,
           last_update_date)
        values
          (sys_user_role_groups_s.nextval,
           v_user_id,
           v_role_id,
           p_start_date,
           p_end_date,
           1,
           sysdate,
           1,
           sysdate);
      when too_many_rows then
        null;
    end;
  exception
    when no_data_found then
      null;
  end add_user_role_load;

end sys_user_pkg;
/
spool off

exit