-- Create table
create table EXP_EMPLOYEE_TYPES
(
  EMPLOYEE_TYPE_ID   NUMBER not null,
  EMPLOYEE_TYPE_CODE VARCHAR2(30) not null,
  DESCRIPTION_ID     NUMBER not null,
  CODING_RULE_CODE   VARCHAR2(30),
  ENABLED_FLAG       VARCHAR2(1) default 'Y',
  CREATED_BY         NUMBER not null,
  CREATION_DATE      DATE not null,
  LAST_UPDATED_BY    NUMBER not null,
  LAST_UPDATE_DATE   DATE not null
)
tablespace AUTOHEC
  pctfree 10
  initrans 1
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
-- Add comments to the table 
comment on table EXP_EMPLOYEE_TYPES
  is 'Ա';
-- Add comments to the columns 
comment on column EXP_EMPLOYEE_TYPES.EMPLOYEE_TYPE_ID
  is 'ԱID';
comment on column EXP_EMPLOYEE_TYPES.EMPLOYEE_TYPE_CODE
  is 'Աʹ';
comment on column EXP_EMPLOYEE_TYPES.DESCRIPTION_ID
  is 'ID';
comment on column EXP_EMPLOYEE_TYPES.CODING_RULE_CODE
  is '';
comment on column EXP_EMPLOYEE_TYPES.ENABLED_FLAG
  is 'ñ־';
comment on column EXP_EMPLOYEE_TYPES.CREATED_BY
  is 'ûID';
comment on column EXP_EMPLOYEE_TYPES.CREATION_DATE
  is '';
comment on column EXP_EMPLOYEE_TYPES.LAST_UPDATED_BY
  is 'ûID';
comment on column EXP_EMPLOYEE_TYPES.LAST_UPDATE_DATE
  is '';
-- Create/Recreate primary, unique and foreign key constraints 
alter table EXP_EMPLOYEE_TYPES
  add constraint EXP_EMPLOYEE_TYPES_PK primary key (EMPLOYEE_TYPE_ID)
  using index 
  tablespace AUTOHEC
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
-- Create/Recreate indexes 
create unique index EXP_EMPLOYEE_TYPES_U1 on EXP_EMPLOYEE_TYPES (EMPLOYEE_TYPE_CODE)
  tablespace AUTOHEC
  pctfree 10
  initrans 2
  maxtrans 255
  storage
  (
    initial 64K
    minextents 1
    maxextents unlimited
  );
