WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool FND_COMPANY_LEVELS.log

prompt
prompt Creating table FND_COMPANY_LEVELS
prompt ============================
prompt
whenever sqlerror continue
 drop table FND_COMPANY_LEVELS ; 
whenever sqlerror exit failure rollback

-- Create table
create table FND_COMPANY_LEVELS
(
  COMPANY_LEVEL_ID      NUMBER not null,
  COMPANY_LEVEL_CODE    VARCHAR2(30) not null,
  DESCRIPTION_ID    NUMBER not null,
  ENABLED_FLAG     VARCHAR2(1) not null,
  CREATED_BY       NUMBER not null,
  CREATION_DATE    DATE not null,
  LAST_UPDATED_BY  NUMBER not null,
  LAST_UPDATE_DATE DATE not null
);
-- Create/Recreate primary, unique and foreign key constraints 
alter table FND_COMPANY_LEVELS
  add constraint FND_COMPANY_LEVELS_PK primary key (COMPANY_LEVEL_ID);
-- Create/Recreate indexes 
create unique index FND_COMPANY_LEVELS_U1 on FND_COMPANY_LEVELS (COMPANY_LEVEL_CODE);

                                   
spool off

exit
