WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool EXP_EMPLOYEES.log

prompt
prompt Creating table EXP_EMPLOYEES
prompt ============================
prompt
whenever sqlerror continue
 drop table EXP_EMPLOYEES ; 
whenever sqlerror exit failure rollback

-- Create table
create table EXP_EMPLOYEES
(
  EMPLOYEE_ID         NUMBER not null,
  EMPLOYEE_CODE       VARCHAR2(30) not null,
  NAME                VARCHAR2(50) not null,
  EMAIL               VARCHAR2(50),
  MOBIL               VARCHAR2(50),
  PHONE               VARCHAR2(50),
  BANK_OF_DEPOSIT     VARCHAR2(200),
  BANK_ACCOUNT        VARCHAR2(200),
  ENABLED_FLAG        VARCHAR2(1) not null,
  CREATED_BY          NUMBER not null,
  CREATION_DATE       DATE not null,
  LAST_UPDATED_BY     NUMBER not null,
  LAST_UPDATE_DATE    DATE not null,
  EMPLOYEE_TYPE_ID    NUMBER,
  ID_TYPE             VARCHAR2(50),
  ID_CODE             VARCHAR2(200),
  NOTES               VARCHAR2(200),
  NATIONAL_IDENTIFIER VARCHAR2(200)
);
-- Create/Recreate primary, unique and foreign key constraints 
alter table EXP_EMPLOYEES add constraint EXP_EMPLOYEES_PK primary key (EMPLOYEE_ID);
-- Create/Recreate indexes 
create unique index EXP_EMPLOYEES_U1 on EXP_EMPLOYEES (EMPLOYEE_CODE);

                                   
spool off

exit
