WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool EXP_EXPENSE_REQ_TYPES.log

prompt
prompt Creating table EXP_EXPENSE_REQ_TYPES
prompt ============================
prompt
whenever sqlerror continue
drop table EXP_EXPENSE_REQ_TYPES; 
whenever sqlerror exit failure rollback

-- Create table
create table EXP_EXPENSE_REQ_TYPES
(
  expense_requisition_type_id   NUMBER not null,
  company_id                    NUMBER not null,
  expense_requisition_type_code VARCHAR2(30) not null,
  description_id                NUMBER not null,
  reserve_budget                VARCHAR2(1),
  budget_control_enabled        VARCHAR2(1),
  document_page_type            VARCHAR2(30),
  currency_code                 VARCHAR2(10),
  expense_report_type_id        NUMBER,
  accrued_flag                  VARCHAR2(1) not null,
  enabled_flag                  VARCHAR2(1) not null,
  line_number_beginning         NUMBER,
  step_length                   NUMBER,
  auto_approve_flag             VARCHAR2(1),
  auto_audit_flag               VARCHAR2(1),
  one_off_flag                  VARCHAR2(1),
  tolerance_flag                VARCHAR2(1),
  tolerance_range               VARCHAR2(30),
  tolerance_ratio               NUMBER,
  payment_object                VARCHAR2(30),
  report_name                   VARCHAR2(100),
  created_by                    NUMBER not null,
  creation_date                 DATE not null,
  last_updated_by               NUMBER not null,
  last_update_date              DATE not null
);
-- Add comments to the table 
comment on table EXP_EXPENSE_REQ_TYPES
  is '뵥';
-- Add comments to the columns 
comment on column EXP_EXPENSE_REQ_TYPES.expense_requisition_type_id
  is '뵥ID';
comment on column EXP_EXPENSE_REQ_TYPES.company_id
  is '˾ID';
comment on column EXP_EXPENSE_REQ_TYPES.expense_requisition_type_code
  is '뵥';
comment on column EXP_EXPENSE_REQ_TYPES.description_id
  is 'ID';
comment on column EXP_EXPENSE_REQ_TYPES.currency_code
  is '';
comment on column EXP_EXPENSE_REQ_TYPES.expense_report_type_id
  is 'ID';
comment on column EXP_EXPENSE_REQ_TYPES.accrued_flag
  is 'Ԥ';
comment on column EXP_EXPENSE_REQ_TYPES.enabled_flag
  is 'ñ־';
comment on column EXP_EXPENSE_REQ_TYPES.line_number_beginning
  is 'ʼк';
comment on column EXP_EXPENSE_REQ_TYPES.step_length
  is '';
comment on column EXP_EXPENSE_REQ_TYPES.auto_approve_flag
  is '';
comment on column EXP_EXPENSE_REQ_TYPES.auto_audit_flag
  is '';
comment on column EXP_EXPENSE_REQ_TYPES.one_off_flag
  is 'һ־';
comment on column EXP_EXPENSE_REQ_TYPES.tolerance_flag
  is 'Ƿ޿';
comment on column EXP_EXPENSE_REQ_TYPES.tolerance_range
  is '';
comment on column EXP_EXPENSE_REQ_TYPES.tolerance_ratio
  is 'ʲΧ';
comment on column EXP_EXPENSE_REQ_TYPES.payment_object
  is '';
comment on column EXP_EXPENSE_REQ_TYPES.report_name
  is 'ļ';
comment on column EXP_EXPENSE_REQ_TYPES.created_by
  is 'ûID';
comment on column EXP_EXPENSE_REQ_TYPES.creation_date
  is '';
comment on column EXP_EXPENSE_REQ_TYPES.last_updated_by
  is 'ûID';
comment on column EXP_EXPENSE_REQ_TYPES.last_update_date
  is '';
comment on column EXP_EXPENSE_REQ_TYPES.document_page_type
  is 'ҳ';
-- Create/Recreate indexes 
create unique index EXP_EXPENSE_REQ_TYPES_U1 on EXP_EXPENSE_REQ_TYPES (COMPANY_ID, EXPENSE_REQUISITION_TYPE_CODE);
-- Create/Recreate primary, unique and foreign key constraints 
alter table EXP_EXPENSE_REQ_TYPES
  add constraint EXP_EXPENSE_REQ_TYPES_PK primary key (EXPENSE_REQUISITION_TYPE_ID)
  using index ;                          
spool off

exit
