WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool EXP_ORG_POSITION.log

prompt
prompt Creating table EXP_ORG_POSITION
prompt ============================
prompt
whenever sqlerror continue
 drop table EXP_ORG_POSITION ; 
whenever sqlerror exit failure rollback

-- Create table
create table EXP_ORG_POSITION
(
  POSITION_ID        NUMBER not null,
  UNIT_ID            NUMBER,
  POSITION_CODE      VARCHAR2(30),
  DESCRIPTION_ID     NUMBER,
  PARENT_POSITION_ID NUMBER,
  COMPANY_ID         NUMBER,
  EMPLOYEE_JOB_ID    NUMBER,
  ENABLED_FLAG       VARCHAR2(1) not null,
  CREATED_BY         NUMBER not null,
  CREATION_DATE      DATE not null,
  LAST_UPDATED_BY    NUMBER not null,
  LAST_UPDATE_DATE   DATE not null
);
-- Create/Recreate primary, unique and foreign key constraints 
alter table EXP_ORG_POSITION
  add constraint EXP_ORG_POSITION_PK primary key (POSITION_ID);
-- Create/Recreate indexes 
create unique index EXP_ORG_POSITION_U1 on EXP_ORG_POSITION (COMPANY_ID,POSITION_CODE);

create index EXP_ORG_POSITION_N1 on EXP_ORG_POSITION (PARENT_POSITION_ID);

                                   
spool off

exit
