WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool FND_CODING_RULE_DETAILS.log

prompt
prompt Creating table FND_CODING_RULE_DETAILS
prompt ============================
prompt
whenever sqlerror continue
drop table FND_CODING_RULE_DETAILS;
whenever sqlerror exit failure rollback

-- Create table
create table FND_CODING_RULE_DETAILS
(
  CODING_RULE_LINE_ID NUMBER not null,
  CODING_RULE_ID      NUMBER not null,
  SEQUENCE            NUMBER not null,
  SEGMENT_TYPE        VARCHAR2(30) not null,
  SEGMENT_VALUE       VARCHAR2(30),
  DATE_FORMAT         VARCHAR2(30),
  LENGTH              NUMBER,
  INCREMENTAL         NUMBER,
  START_VALUE         NUMBER,
  DISPLAY_FLAG	      VARCHAR2(1),
  CREATED_BY          NUMBER not null,
  CREATION_DATE       DATE not null,
  LAST_UPDATED_BY     NUMBER not null,
  LAST_UPDATE_DATE    DATE not null
);
-- Create/Recreate primary, unique and foreign key constraints 
alter table FND_CODING_RULE_DETAILS
  add constraint FND_CODING_RULE_DETAILS_PK primary key (CODING_RULE_LINE_ID);
-- Create/Recreate indexes 
create unique index FND_CODING_RULE_DETAILS_U1 on FND_CODING_RULE_DETAILS (CODING_RULE_ID, SEQUENCE);


spool off

exit
