WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool FND_CODING_RULE_OBJECTS.log

prompt
prompt Creating table FND_CODING_RULE_OBJECTS
prompt ============================
prompt
whenever sqlerror continue
drop table FND_CODING_RULE_OBJECTS;
whenever sqlerror exit failure rollback

-- Create table
create table FND_CODING_RULE_OBJECTS
(
  CODING_RULE_OBJECT_ID NUMBER not null,
  DOCUMENT_CATEGORY     VARCHAR2(30) not null,
  PRIORITY              NUMBER not null,
  DOCUMENT_TYPE         VARCHAR2(30),
  COMPANY_ID            NUMBER,
  OPERATION_UNIT_ID     NUMBER,
  ENABLED_FLAG          VARCHAR2(1) not null,
  CREATED_BY            NUMBER not null,
  CREATION_DATE         DATE not null,
  LAST_UPDATED_BY       NUMBER not null,
  LAST_UPDATE_DATE      DATE not null
);
-- Create/Recreate primary, unique and foreign key constraints 
alter table FND_CODING_RULE_OBJECTS
  add constraint FND_CODING_RULE_OBJECTS_PK primary key (CODING_RULE_OBJECT_ID);
alter table FND_CODING_RULE_OBJECTS
  add constraint FND_CODING_RULE_OBJECTS_U1 unique (DOCUMENT_CATEGORY, DOCUMENT_TYPE, COMPANY_ID, OPERATION_UNIT_ID);
-- Create/Recreate indexes 
create unique index FND_CODING_RULE_OBJECTS_U2 on FND_CODING_RULE_OBJECTS (DOCUMENT_CATEGORY, PRIORITY);



spool off

exit
