WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool FND_CODING_RULE_VALUES.log

prompt
prompt Creating table FND_CODING_RULE_VALUES
prompt ============================
prompt
whenever sqlerror continue
drop table FND_CODING_RULE_VALUES;
whenever sqlerror exit failure rollback

-- Create table
create table FND_CODING_RULE_VALUES
(
  CODING_RULE_ID    NUMBER not null,
  COMPANY_ID        NUMBER ,
	DOCUMENT_CATEGORY VARCHAR2(30) not null,
	DOCUMENT_TYPE     VARCHAR2(30),
  OPERATION_UNIT_ID NUMBER,
  YEAR              NUMBER,
  PERIOD_NAME       VARCHAR2(30),
  CURRENT_VALUE     NUMBER not null,
  CREATED_BY        NUMBER not null,
  CREATION_DATE     DATE not null,
  LAST_UPDATED_BY   NUMBER not null,
  LAST_UPDATE_DATE  DATE not null
);
-- Create/Recreate indexes 
create unique index FND_CODING_RULE_VALUES_U1 on FND_CODING_RULE_VALUES (CODING_RULE_ID, COMPANY_ID, YEAR, PERIOD_NAME, DOCUMENT_TYPE, OPERATION_UNIT_ID, DOCUMENT_CATEGORY);



spool off

exit
