WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool FND_CODING_RULES.log

prompt
prompt Creating table FND_CODING_RULES
prompt ============================
prompt
whenever sqlerror continue
drop table FND_CODING_RULES;
whenever sqlerror exit failure rollback

-- Create table
create table FND_CODING_RULES
(
  CODING_RULE_OBJECT_ID NUMBER not null,
  CODING_RULE_ID        NUMBER not null,
  CODING_RULE_CODE      VARCHAR2(30) not null,
  DESCRIPTION_ID        NUMBER not null,
  NOTE                  VARCHAR2(2000),
  RESET_FREQUENCE       VARCHAR2(30) not null,
  ENABLED_FLAG          VARCHAR2(1) not null,
  CREATED_BY            NUMBER not null,
  CREATION_DATE         DATE not null,
  LAST_UPDATED_BY       NUMBER not null,
  LAST_UPDATE_DATE      DATE not null
);
-- Create/Recreate primary, unique and foreign key constraints 
alter table FND_CODING_RULES
  add constraint FND_CODING_RULES_PK primary key (CODING_RULE_ID);

-- Create/Recreate indexes 
create index FND_CODING_RULES_N1 on FND_CODING_RULES (CODING_RULE_OBJECT_ID, CODING_RULE_ID);

create unique index FND_CODING_RULES_U1 on FND_CODING_RULES (CODING_RULE_CODE);


spool off

exit
