WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;


spool FND_COMPANIES.log

prompt
prompt Creating table FND_COMPANIES
prompt ============================
prompt
whenever sqlerror continue
  drop table FND_COMPANIES;
whenever sqlerror exit failure rollback
create table FND_COMPANIES
(
  company_id            NUMBER not null,
  company_code          VARCHAR2(30) not null,
  company_type          VARCHAR2(30) not null,
  company_short_name_id NUMBER not null,
  company_full_name_id  NUMBER not null,
  company_icon          BLOB,
  set_of_books_id       NUMBER,
  address               VARCHAR2(2000),
  company_level_id      NUMBER,
  parent_company_id     NUMBER,
  chief_position_id     NUMBER,
  start_date_active     DATE not null,
  end_date_active       DATE,
  last_update_date      DATE not null,
  last_updated_by       NUMBER(15) not null,
  creation_date         DATE not null,
  created_by            NUMBER(15) not null
)
;
create index FND_COMPANIES_N1 on FND_COMPANIES (SET_OF_BOOKS_ID);
create index FND_COMPANIES_N2 on FND_COMPANIES (SET_OF_BOOKS_ID, COMPANY_ID);
create unique index FND_COMPANIES_U1 on FND_COMPANIES (COMPANY_CODE);
alter table FND_COMPANIES
  add constraint FND_COMPANIES_PK primary key (COMPANY_ID);

spool off


exit
